/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.tcp;

import java.net.InetSocketAddress;
import org.opendaylight.netconf.transport.api.AbstractTransportStack;
import org.opendaylight.netconf.transport.api.TransportChannelListener;
import org.opendaylight.netconf.transport.tcp.TCPClient;
import org.opendaylight.netconf.transport.tcp.TCPServer;
import org.opendaylight.netconf.transport.tcp.TCPTransportChannel;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IetfInetUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;

public abstract sealed class TCPTransportStack
extends AbstractTransportStack<TCPTransportChannel>
permits TCPClient, TCPServer {
    TCPTransportStack(TransportChannelListener<? super TCPTransportChannel> listener) {
        super(listener);
    }

    static final InetSocketAddress socketAddressOf(Host host, PortNumber port) {
        IpAddress addr = host.getIpAddress();
        return addr != null ? TCPTransportStack.socketAddressOf(addr, port) : InetSocketAddress.createUnresolved(host.getDomainName().getValue(), port.getValue().toJava());
    }

    static final InetSocketAddress socketAddressOf(IpAddress addr, PortNumber port) {
        int portNum;
        int n = portNum = port == null ? 0 : port.getValue().toJava();
        if (addr == null) {
            return port == null ? null : new InetSocketAddress(portNum);
        }
        return new InetSocketAddress(IetfInetUtil.inetAddressFor((IpAddress)addr), portNum);
    }
}

