/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.tls;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;

final class KeyUtils {
    static final String RSA_ALGORITHM = "RSA";
    static final String EC_ALGORITHM = "EC";

    private KeyUtils() {
    }

    static PrivateKey buildPrivateKey(String keyAlgorithm, byte[] bytes) throws UnsupportedConfigurationException {
        try {
            return KeyFactory.getInstance(keyAlgorithm).generatePrivate(new PKCS8EncodedKeySpec(bytes));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new UnsupportedConfigurationException("Cannot build private key for " + keyAlgorithm, (Throwable)e);
        }
    }

    static PublicKey buildX509PublicKey(String keyAlgorithm, byte[] bytes) throws UnsupportedConfigurationException {
        try {
            return KeyFactory.getInstance(keyAlgorithm).generatePublic(new X509EncodedKeySpec(bytes));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new UnsupportedConfigurationException("Cannot build private key for " + keyAlgorithm, (Throwable)e);
        }
    }

    static PublicKey buildPublicKeyFromSshEncoding(byte[] bytes) throws UnsupportedConfigurationException {
        try {
            ECPublicKeyParameters ecParams;
            RSAKeyParameters rsaParams;
            AsymmetricKeyParameter parsed = OpenSSHPublicKeyUtil.parsePublicKey((byte[])bytes);
            byte[] converted = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)parsed).getEncoded();
            if (parsed instanceof RSAKeyParameters && !(rsaParams = (RSAKeyParameters)parsed).isPrivate()) {
                return KeyUtils.buildX509PublicKey(RSA_ALGORITHM, converted);
            }
            if (parsed instanceof ECPublicKeyParameters && !(ecParams = (ECPublicKeyParameters)parsed).isPrivate()) {
                return KeyUtils.buildX509PublicKey(EC_ALGORITHM, converted);
            }
            throw new UnsupportedConfigurationException("Invalid OpenSSH public key; Expected RSA or EC public key; Current:" + String.valueOf(parsed));
        }
        catch (IOException e) {
            throw new UnsupportedConfigurationException("Cannot parse OpenSSH public key", (Throwable)e);
        }
    }

    static void validateKeyPair(PublicKey publicKey, PrivateKey privateKey) throws UnsupportedConfigurationException {
        String signAlgorithm;
        if (privateKey instanceof RSAPrivateKey) {
            signAlgorithm = "SHA256withRSA";
        } else if (privateKey instanceof ECPrivateKey) {
            signAlgorithm = "SHA256withECDSA";
        } else {
            throw new UnsupportedConfigurationException("Unsupported key type " + String.valueOf(privateKey));
        }
        try {
            byte[] original = new byte[1024];
            ThreadLocalRandom.current().nextBytes(original);
            Signature signature = Signature.getInstance(signAlgorithm);
            signature.initSign(privateKey);
            signature.update(original);
            byte[] signed = signature.sign();
            signature.initVerify(publicKey);
            signature.update(original);
            if (!signature.verify(signed)) {
                throw new UnsupportedConfigurationException("Private key mismatches Public key");
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new UnsupportedConfigurationException("Key pair validation failed", (Throwable)e);
        }
    }

    static void validatePublicKey(PublicKey publicKey, Certificate certificate) throws UnsupportedConfigurationException {
        if (!Objects.equals(publicKey, certificate.getPublicKey())) {
            throw new UnsupportedConfigurationException("Certificate mismatches Public key");
        }
    }
}

