/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.tls;

import com.google.common.util.concurrent.ListenableFuture;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.handler.ssl.SslContext;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.transport.api.AbstractOverlayTransportStack;
import org.opendaylight.netconf.transport.api.TransportChannelListener;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.netconf.transport.tcp.TCPClient;
import org.opendaylight.netconf.transport.tcp.TCPServer;
import org.opendaylight.netconf.transport.tls.SslHandlerFactory;
import org.opendaylight.netconf.transport.tls.TLSTransportChannel;
import org.opendaylight.netconf.transport.tls.TLSTransportStack;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.client.rev241010.TcpClientGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tcp.server.rev241010.TcpServerGrouping;

public final class TLSServer
extends TLSTransportStack {
    private TLSServer(TransportChannelListener<? super TLSTransportChannel> listener, SslContext sslContext) {
        super(listener, sslContext);
    }

    private TLSServer(TransportChannelListener<? super TLSTransportChannel> listener, SslHandlerFactory factory) {
        super(listener, factory);
    }

    public static @NonNull ListenableFuture<TLSServer> connect(TransportChannelListener listener, Bootstrap bootstrap, TcpClientGrouping connectParams, SslHandlerFactory factory) throws UnsupportedConfigurationException {
        TLSServer server = new TLSServer((TransportChannelListener<? super TLSTransportChannel>)listener, factory);
        return TLSServer.transformUnderlay((AbstractOverlayTransportStack)server, (ListenableFuture)TCPClient.connect((TransportChannelListener)server.asListener(), (Bootstrap)bootstrap, (TcpClientGrouping)connectParams));
    }

    public static @NonNull ListenableFuture<TLSServer> listen(TransportChannelListener listener, ServerBootstrap bootstrap, TcpServerGrouping listenParams, SslHandlerFactory factory) throws UnsupportedConfigurationException {
        TLSServer server = new TLSServer((TransportChannelListener<? super TLSTransportChannel>)listener, factory);
        return TLSServer.transformUnderlay((AbstractOverlayTransportStack)server, (ListenableFuture)TCPServer.listen((TransportChannelListener)server.asListener(), (ServerBootstrap)bootstrap, (TcpServerGrouping)listenParams));
    }
}

