/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.tls;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.util.Objects;
import org.opendaylight.netconf.transport.api.AbstractOverlayTransportStack;
import org.opendaylight.netconf.transport.api.TransportChannel;
import org.opendaylight.netconf.transport.api.TransportChannelListener;
import org.opendaylight.netconf.transport.tls.FixedSslHandlerFactory;
import org.opendaylight.netconf.transport.tls.SslHandlerFactory;
import org.opendaylight.netconf.transport.tls.TLSClient;
import org.opendaylight.netconf.transport.tls.TLSServer;
import org.opendaylight.netconf.transport.tls.TLSTransportChannel;

public abstract sealed class TLSTransportStack
extends AbstractOverlayTransportStack<TLSTransportChannel>
permits TLSClient, TLSServer {
    private final SslHandlerFactory factory;

    TLSTransportStack(TransportChannelListener<? super TLSTransportChannel> listener, SslContext sslContext) {
        this(listener, new FixedSslHandlerFactory(sslContext));
    }

    TLSTransportStack(TransportChannelListener<? super TLSTransportChannel> listener, SslHandlerFactory factory) {
        super(listener);
        this.factory = Objects.requireNonNull(factory);
    }

    protected final void onUnderlayChannelEstablished(TransportChannel underlayChannel) {
        Channel channel = underlayChannel.channel();
        SslHandler sslHandler = this.factory.createSslHandler(channel);
        channel.pipeline().addLast(new ChannelHandler[]{sslHandler});
        sslHandler.handshakeFuture().addListener(future -> {
            Throwable cause = future.cause();
            if (cause != null) {
                this.notifyTransportChannelFailed(cause);
                channel.close();
            } else {
                this.addTransportChannel((TransportChannel)new TLSTransportChannel(underlayChannel));
            }
        });
    }
}

