/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.tls;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.netconf.transport.tls.KeyStoreUtils;
import org.opendaylight.netconf.transport.tls.KeyUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.AsymmetricKeyPairGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.EcPrivateKeyFormat;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.PrivateKeyFormat;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.PublicKeyFormat;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.RsaPrivateKeyFormat;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.SshPublicKeyFormat;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010.SubjectPublicKeyInfoFormat;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010._private.key.grouping.PrivateKeyType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.crypto.types.rev241010._private.key.grouping._private.key.type.CleartextPrivateKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.keystore.rev241010.InlineOrKeystoreAsymmetricKeyGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.keystore.rev241010.InlineOrKeystoreEndEntityCertWithKeyGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.keystore.rev241010.inline.or.keystore.asymmetric.key.grouping.inline.or.keystore.Inline;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.keystore.rev241010.inline.or.keystore.asymmetric.key.grouping.inline.or.keystore.inline.InlineDefinition;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.InlineOrTruststoreCertsGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.inline.or.truststore.certs.grouping.inline.or.truststore.inline.inline.definition.Certificate;

final class ConfigUtils {
    static final char[] EMPTY_SECRET = new char[0];
    static final String DEFAULT_PRIVATE_KEY_ALIAS = "private";
    static final String DEFAULT_CERTIFICATE_ALIAS = "certificate";

    private ConfigUtils() {
    }

    static void setX509Certificates(@NonNull KeyStore keyStore, @Nullable InlineOrTruststoreCertsGrouping caCerts, @Nullable InlineOrTruststoreCertsGrouping eeCerts) throws UnsupportedConfigurationException {
        ImmutableMap certMap = ImmutableMap.builder().putAll(ConfigUtils.extractCertificates(caCerts, "ca-")).putAll(ConfigUtils.extractCertificates(eeCerts, "ee-")).build();
        for (Map.Entry entry : certMap.entrySet()) {
            try {
                keyStore.setCertificateEntry((String)entry.getKey(), (java.security.cert.Certificate)entry.getValue());
            }
            catch (KeyStoreException e) {
                throw new UnsupportedConfigurationException("Failed to load certificate", (Throwable)e);
            }
        }
    }

    private static Map<String, java.security.cert.Certificate> extractCertificates(@Nullable InlineOrTruststoreCertsGrouping certs, @NonNull String aliasPrefix) throws UnsupportedConfigurationException {
        if (certs == null) {
            return Map.of();
        }
        org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.inline.or.truststore.certs.grouping.inline.or.truststore.Inline inline = ConfigUtils.ofType(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.inline.or.truststore.certs.grouping.inline.or.truststore.Inline.class, certs.getInlineOrTruststore());
        org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.inline.or.truststore.certs.grouping.inline.or.truststore.inline.InlineDefinition inlineDef = inline.getInlineDefinition();
        if (inlineDef == null) {
            throw new UnsupportedConfigurationException("Missing inline definition in " + String.valueOf(inline));
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Certificate cert : inlineDef.nonnullCertificate().values()) {
            try {
                String alias = aliasPrefix + cert.requireName();
                mapBuilder.put((Object)alias, (Object)KeyStoreUtils.buildX509Certificate(cert.requireCertData().getValue()));
            }
            catch (IOException | CertificateException e) {
                throw new UnsupportedConfigurationException("Failed to parse certificate " + String.valueOf(cert), (Throwable)e);
            }
        }
        return mapBuilder.build();
    }

    static void setAsymmetricKey(@NonNull KeyStore keyStore, @NonNull InlineOrKeystoreAsymmetricKeyGrouping input) throws UnsupportedConfigurationException {
        Inline inline = ConfigUtils.ofType(Inline.class, input.getInlineOrKeystore());
        InlineDefinition inlineDef = inline.getInlineDefinition();
        if (inlineDef == null) {
            throw new UnsupportedConfigurationException("Missing inline definition in " + String.valueOf(inline));
        }
        KeyPair keyPair = ConfigUtils.extractKeyPair((AsymmetricKeyPairGrouping)inlineDef);
        KeyUtils.validateKeyPair(keyPair.getPublic(), keyPair.getPrivate());
        try {
            keyStore.setKeyEntry(DEFAULT_PRIVATE_KEY_ALIAS, keyPair.getPrivate(), EMPTY_SECRET, null);
        }
        catch (KeyStoreException e) {
            throw new UnsupportedConfigurationException("Failed to load private key", (Throwable)e);
        }
    }

    static void setEndEntityCertificateWithKey(@NonNull KeyStore keyStore, @NonNull InlineOrKeystoreEndEntityCertWithKeyGrouping input) throws UnsupportedConfigurationException {
        java.security.cert.Certificate certificate;
        org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.keystore.rev241010.inline.or.keystore.end.entity.cert.with.key.grouping.inline.or.keystore.Inline inline = ConfigUtils.ofType(org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.keystore.rev241010.inline.or.keystore.end.entity.cert.with.key.grouping.inline.or.keystore.Inline.class, input.getInlineOrKeystore());
        org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.keystore.rev241010.inline.or.keystore.end.entity.cert.with.key.grouping.inline.or.keystore.inline.InlineDefinition inlineDef = inline.getInlineDefinition();
        if (inlineDef == null) {
            throw new UnsupportedConfigurationException("Missing inline definition in " + String.valueOf(inline));
        }
        KeyPair keyPair = ConfigUtils.extractKeyPair((AsymmetricKeyPairGrouping)inlineDef);
        try {
            certificate = KeyStoreUtils.buildX509Certificate(inlineDef.requireCertData().getValue());
        }
        catch (IOException | CertificateException e) {
            throw new UnsupportedConfigurationException("Failed to load certificate" + String.valueOf(inlineDef), (Throwable)e);
        }
        KeyUtils.validateKeyPair(keyPair.getPublic(), keyPair.getPrivate());
        KeyUtils.validatePublicKey(keyPair.getPublic(), certificate);
        try {
            keyStore.setCertificateEntry(DEFAULT_CERTIFICATE_ALIAS, certificate);
            keyStore.setKeyEntry(DEFAULT_PRIVATE_KEY_ALIAS, keyPair.getPrivate(), EMPTY_SECRET, new java.security.cert.Certificate[]{certificate});
        }
        catch (KeyStoreException e) {
            throw new UnsupportedConfigurationException("Failed to load certificate and/or private key", (Throwable)e);
        }
    }

    private static KeyPair extractKeyPair(AsymmetricKeyPairGrouping input) throws UnsupportedConfigurationException {
        boolean isSshPublicKey;
        String keyAlgorithm;
        PrivateKeyFormat privateKeyFormat = input.getPrivateKeyFormat();
        if (EcPrivateKeyFormat.VALUE.equals((Object)privateKeyFormat)) {
            keyAlgorithm = "EC";
        } else if (RsaPrivateKeyFormat.VALUE.equals((Object)privateKeyFormat)) {
            keyAlgorithm = "RSA";
        } else {
            throw new UnsupportedConfigurationException("Unsupported private key format " + String.valueOf(privateKeyFormat));
        }
        PrivateKeyType privateKeyType = input.getPrivateKeyType();
        if (!(privateKeyType instanceof CleartextPrivateKey)) {
            throw new UnsupportedConfigurationException("Unsupported private key type " + String.valueOf(input.getPrivateKeyType()));
        }
        CleartextPrivateKey clearText = (CleartextPrivateKey)privateKeyType;
        byte[] privateKeyBytes = clearText.requireCleartextPrivateKey();
        PrivateKey privateKey = KeyUtils.buildPrivateKey(keyAlgorithm, privateKeyBytes);
        PublicKeyFormat publicKeyFormat = input.getPublicKeyFormat();
        if (SubjectPublicKeyInfoFormat.VALUE.equals((Object)publicKeyFormat)) {
            isSshPublicKey = false;
        } else if (SshPublicKeyFormat.VALUE.equals((Object)publicKeyFormat)) {
            isSshPublicKey = true;
        } else {
            throw new UnsupportedConfigurationException("Unsupported public key format " + String.valueOf(publicKeyFormat));
        }
        PublicKey publicKey = isSshPublicKey ? KeyUtils.buildPublicKeyFromSshEncoding(input.getPublicKey()) : KeyUtils.buildX509PublicKey(keyAlgorithm, input.getPublicKey());
        return new KeyPair(publicKey, privateKey);
    }

    private static <T> T ofType(Class<T> expectedType, Object obj) throws UnsupportedConfigurationException {
        if (!expectedType.isInstance(obj)) {
            throw new UnsupportedConfigurationException("Expected type: " + String.valueOf(expectedType) + " actual: " + String.valueOf(obj.getClass()));
        }
        return expectedType.cast(obj);
    }
}

