/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;

final class KeyStoreUtils {
    private static final char[] EMPTY_SECRET = new char[0];

    private KeyStoreUtils() {
    }

    static @NonNull KeyStore newKeyStore() throws UnsupportedConfigurationException {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new UnsupportedConfigurationException("Cannot instantiate key store", (Throwable)e);
        }
        return keyStore;
    }

    static @NonNull KeyManagerFactory buildKeyManagerFactory(@NonNull KeyStore keyStore) throws UnsupportedConfigurationException {
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, EMPTY_SECRET);
            return kmf;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new UnsupportedConfigurationException("Cannot instantiate key manager", (Throwable)e);
        }
    }

    static @NonNull TrustManagerFactory buildTrustManagerFactory(@NonNull KeyStore keyStore) throws UnsupportedConfigurationException {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            return tmf;
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new UnsupportedConfigurationException("Cannot instantiate trust manager", (Throwable)e);
        }
    }

    static Certificate buildX509Certificate(byte[] bytes) throws CertificateException, IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            Certificate certificate = CertificateFactory.getInstance("X.509").generateCertificate(in);
            return certificate;
        }
    }
}

