/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.tls;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.netconf.transport.tls.KeyStoreUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.common.rev241010.HelloParamsGrouping;

final class SSLEngineFactory {
    private static final char[] EMPTY_CHARS = new char[0];
    private final SSLContext sslContext;

    private SSLEngineFactory(HelloParamsGrouping helloParams) throws UnsupportedConfigurationException {
        TrustManagerFactory tmf;
        KeyManagerFactory kmf;
        KeyStore keyStore = KeyStoreUtils.newKeyStore();
        try {
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedConfigurationException("Cannot instantiate key manager", (Throwable)e);
        }
        try {
            kmf.init(keyStore, EMPTY_CHARS);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new UnsupportedConfigurationException("Cannot initialize key manager", (Throwable)e);
        }
        try {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedConfigurationException("Cannot instantiate trust manager", (Throwable)e);
        }
        try {
            tmf.init(keyStore);
        }
        catch (KeyStoreException e) {
            throw new UnsupportedConfigurationException("Cannot initialize trust manager", (Throwable)e);
        }
        try {
            this.sslContext = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedConfigurationException("TLS context cannot be allocated", (Throwable)e);
        }
        try {
            this.sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        }
        catch (KeyManagementException e) {
            throw new UnsupportedConfigurationException("TLS context cannot be initialized", (Throwable)e);
        }
    }
}

