/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.transport.tls;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.netty.channel.Channel;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import java.lang.runtime.SwitchBootstraps;
import java.net.SocketAddress;
import java.security.KeyStore;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.transport.api.UnsupportedConfigurationException;
import org.opendaylight.netconf.transport.tls.ConfigUtils;
import org.opendaylight.netconf.transport.tls.KeyStoreUtils;
import org.opendaylight.netconf.transport.tls.impl.IetfTlsCommonFeatureProvider;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.iana.tls.cipher.suite.algs.rev241016.TlsCipherSuiteAlgorithm;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.keystore.rev241010.InlineOrKeystoreAsymmetricKeyGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.keystore.rev241010.InlineOrKeystoreEndEntityCertWithKeyGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.TlsClientGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.tls.client.grouping.ClientIdentity;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.tls.client.grouping.ServerAuthentication;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.tls.client.grouping.client.identity.auth.type.RawPublicKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.tls.client.grouping.client.identity.auth.type.raw._public.key.RawPrivateKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.common.rev241010.HelloParamsGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.common.rev241010.Tls12;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.common.rev241010.Tls13;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.common.rev241010.TlsVersionBase;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.common.rev241010.hello.params.grouping.CipherSuites;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.common.rev241010.hello.params.grouping.TlsVersions;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.server.rev241010.TlsServerGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.server.rev241010.tls.server.grouping.ClientAuthentication;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.server.rev241010.tls.server.grouping.ServerIdentity;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.server.rev241010.tls.server.grouping.server.identity.AuthType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.server.rev241010.tls.server.grouping.server.identity.auth.type.Certificate;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.InlineOrTruststoreCertsGrouping;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.truststore.rev241010.InlineOrTruststorePublicKeysGrouping;

public abstract class SslHandlerFactory {
    private static final ImmutableMap<TlsCipherSuiteAlgorithm, String> CIPHER_SUITES = SslHandlerFactory.index(TlsCipherSuiteAlgorithm.TLSAES128CCMSHA256, TlsCipherSuiteAlgorithm.TLSAES256GCMSHA384, TlsCipherSuiteAlgorithm.TLSCHACHA20POLY1305SHA256, TlsCipherSuiteAlgorithm.TLSDHEPSKWITHAES128CCM, TlsCipherSuiteAlgorithm.TLSDHEPSKWITHAES128GCMSHA256, TlsCipherSuiteAlgorithm.TLSDHEPSKWITHAES256CCM, TlsCipherSuiteAlgorithm.TLSDHEPSKWITHAES256GCMSHA384, TlsCipherSuiteAlgorithm.TLSDHEPSKWITHCHACHA20POLY1305SHA256, TlsCipherSuiteAlgorithm.TLSDHERSAWITHAES128CCM, TlsCipherSuiteAlgorithm.TLSDHERSAWITHAES128GCMSHA256, TlsCipherSuiteAlgorithm.TLSDHERSAWITHAES256CCM, TlsCipherSuiteAlgorithm.TLSDHERSAWITHAES256GCMSHA384, TlsCipherSuiteAlgorithm.TLSDHERSAWITHCHACHA20POLY1305SHA256, TlsCipherSuiteAlgorithm.TLSECDHEECDSAWITHAES128GCMSHA256, TlsCipherSuiteAlgorithm.TLSECDHEECDSAWITHAES256GCMSHA384, TlsCipherSuiteAlgorithm.TLSECDHEECDSAWITHCHACHA20POLY1305SHA256, TlsCipherSuiteAlgorithm.TLSECDHEPSKWITHAES128CCMSHA256, TlsCipherSuiteAlgorithm.TLSECDHEPSKWITHAES128GCMSHA256, TlsCipherSuiteAlgorithm.TLSECDHEPSKWITHAES256GCMSHA384, TlsCipherSuiteAlgorithm.TLSECDHEPSKWITHCHACHA20POLY1305SHA256, TlsCipherSuiteAlgorithm.TLSECDHERSAWITHAES128GCMSHA256, TlsCipherSuiteAlgorithm.TLSECDHERSAWITHAES256GCMSHA384, TlsCipherSuiteAlgorithm.TLSECDHERSAWITHCHACHA20POLY1305SHA256);

    private static ImmutableMap<TlsCipherSuiteAlgorithm, String> index(TlsCipherSuiteAlgorithm ... algs) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)algs.length);
        for (TlsCipherSuiteAlgorithm alg : algs) {
            builder.put((Object)alg, (Object)alg.getName());
        }
        return builder.build();
    }

    public final @Nullable SslHandler createSslHandler(@NonNull Channel channel) {
        SslContext sslContext = this.getSslContext(channel.remoteAddress());
        return sslContext == null ? null : sslContext.newHandler(channel.alloc());
    }

    protected abstract @Nullable SslContext getSslContext(SocketAddress var1);

    protected static final @NonNull SslContext createSslContext(@NonNull TlsClientGrouping clientParams) throws UnsupportedConfigurationException {
        return SslHandlerFactory.createSslContext(clientParams, null);
    }

    protected static final @NonNull SslContext createSslContext(@NonNull TlsClientGrouping clientParams, @Nullable ApplicationProtocolConfig apn) throws UnsupportedConfigurationException {
        ServerAuthentication serverAuth;
        SslContextBuilder builder = SslContextBuilder.forClient().applicationProtocolConfig(apn).endpointIdentificationAlgorithm(null);
        ClientIdentity clientIdentity = clientParams.getClientIdentity();
        if (clientIdentity != null) {
            org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.tls.client.grouping.client.identity.AuthType authType = clientIdentity.getAuthType();
            if (authType instanceof org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.tls.client.grouping.client.identity.auth.type.Certificate) {
                org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.tls.client.grouping.client.identity.auth.type.Certificate cert = (org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.tls.client.grouping.client.identity.auth.type.Certificate)authType;
                org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.client.rev241010.tls.client.grouping.client.identity.auth.type.certificate.Certificate certificate = cert.getCertificate();
                if (certificate == null) {
                    throw new UnsupportedConfigurationException("Missing certificate in " + String.valueOf(cert));
                }
                builder.keyManager(SslHandlerFactory.newKeyManager((InlineOrKeystoreEndEntityCertWithKeyGrouping)certificate));
            } else if (authType instanceof RawPublicKey) {
                RawPublicKey rawKey = (RawPublicKey)authType;
                RawPrivateKey rawPrivateKey = rawKey.getRawPrivateKey();
                if (rawPrivateKey == null) {
                    throw new UnsupportedConfigurationException("Missing key in " + String.valueOf(rawKey));
                }
                builder.keyManager(SslHandlerFactory.newKeyManager((InlineOrKeystoreAsymmetricKeyGrouping)rawPrivateKey));
            } else if (authType != null) {
                throw new UnsupportedConfigurationException("Unsupported client authentication type " + String.valueOf(authType));
            }
        }
        if ((serverAuth = clientParams.getServerAuthentication()) != null) {
            TrustManagerFactory trustManager = SslHandlerFactory.newTrustManager((InlineOrTruststoreCertsGrouping)serverAuth.getCaCerts(), (InlineOrTruststoreCertsGrouping)serverAuth.getEeCerts(), (InlineOrTruststorePublicKeysGrouping)serverAuth.getRawPublicKeys());
            if (trustManager == null) {
                throw new UnsupportedOperationException("No server authentication methods in " + String.valueOf(serverAuth));
            }
            builder.trustManager(trustManager);
        }
        return SslHandlerFactory.buildSslContext(builder, (HelloParamsGrouping)clientParams.getHelloParams());
    }

    protected static final @NonNull SslContext createSslContext(@NonNull TlsServerGrouping serverParams) throws UnsupportedConfigurationException {
        return SslHandlerFactory.createSslContext(serverParams, null);
    }

    protected static final @NonNull SslContext createSslContext(@NonNull TlsServerGrouping serverParams, @Nullable ApplicationProtocolConfig apn) throws UnsupportedConfigurationException {
        SslContextBuilder builder;
        ServerIdentity serverIdentity = serverParams.getServerIdentity();
        if (serverIdentity == null) {
            throw new UnsupportedConfigurationException("Missing server identity");
        }
        AuthType authType = serverIdentity.getAuthType();
        if (authType instanceof Certificate) {
            Certificate cert = (Certificate)authType;
            org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.server.rev241010.tls.server.grouping.server.identity.auth.type.certificate.Certificate certificate = cert.getCertificate();
            if (certificate == null) {
                throw new UnsupportedConfigurationException("Missing certificate in " + String.valueOf(cert));
            }
            builder = SslContextBuilder.forServer((KeyManagerFactory)SslHandlerFactory.newKeyManager((InlineOrKeystoreEndEntityCertWithKeyGrouping)certificate));
        } else if (authType instanceof org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.server.rev241010.tls.server.grouping.server.identity.auth.type.RawPrivateKey) {
            org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.server.rev241010.tls.server.grouping.server.identity.auth.type.RawPrivateKey rawKey = (org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.server.rev241010.tls.server.grouping.server.identity.auth.type.RawPrivateKey)authType;
            org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.tls.server.rev241010.tls.server.grouping.server.identity.auth.type.raw._private.key.RawPrivateKey rawPrivateKey = rawKey.getRawPrivateKey();
            if (rawPrivateKey == null) {
                throw new UnsupportedConfigurationException("Missing key in " + String.valueOf(rawKey));
            }
            builder = SslContextBuilder.forServer((KeyManagerFactory)SslHandlerFactory.newKeyManager((InlineOrKeystoreAsymmetricKeyGrouping)rawPrivateKey));
        } else {
            if (authType != null) {
                throw new UnsupportedConfigurationException("Unsupported server authentication type " + String.valueOf(authType));
            }
            throw new UnsupportedConfigurationException("Missing server authentication type");
        }
        ClientAuthentication clientAuth = serverParams.getClientAuthentication();
        if (clientAuth != null) {
            TrustManagerFactory trustManager = SslHandlerFactory.newTrustManager((InlineOrTruststoreCertsGrouping)clientAuth.getCaCerts(), (InlineOrTruststoreCertsGrouping)clientAuth.getEeCerts(), (InlineOrTruststorePublicKeysGrouping)clientAuth.getRawPublicKeys());
            if (trustManager == null) {
                throw new UnsupportedOperationException("No client authentication methods in " + String.valueOf(clientAuth));
            }
            builder.clientAuth(ClientAuth.REQUIRE).trustManager(trustManager);
        } else {
            builder.clientAuth(ClientAuth.NONE);
        }
        return SslHandlerFactory.buildSslContext(builder.applicationProtocolConfig(apn), (HelloParamsGrouping)serverParams.getHelloParams());
    }

    private static @Nullable TrustManagerFactory newTrustManager(@Nullable InlineOrTruststoreCertsGrouping caCerts, @Nullable InlineOrTruststoreCertsGrouping eeCerts, @Nullable InlineOrTruststorePublicKeysGrouping publicKeys) throws UnsupportedConfigurationException {
        if (publicKeys != null) {
            throw new UnsupportedConfigurationException("Public key authentication not implemented");
        }
        if (caCerts != null || eeCerts != null) {
            KeyStore keyStore = KeyStoreUtils.newKeyStore();
            ConfigUtils.setX509Certificates(keyStore, caCerts, eeCerts);
            return KeyStoreUtils.buildTrustManagerFactory(keyStore);
        }
        return null;
    }

    private static KeyManagerFactory newKeyManager(@NonNull InlineOrKeystoreEndEntityCertWithKeyGrouping endEntityCert) throws UnsupportedConfigurationException {
        KeyStore keyStore = KeyStoreUtils.newKeyStore();
        ConfigUtils.setEndEntityCertificateWithKey(keyStore, endEntityCert);
        return KeyStoreUtils.buildKeyManagerFactory(keyStore);
    }

    private static KeyManagerFactory newKeyManager(@NonNull InlineOrKeystoreAsymmetricKeyGrouping rawPrivateKey) throws UnsupportedConfigurationException {
        KeyStore keyStore = KeyStoreUtils.newKeyStore();
        ConfigUtils.setAsymmetricKey(keyStore, rawPrivateKey);
        return KeyStoreUtils.buildKeyManagerFactory(keyStore);
    }

    private static @NonNull SslContext buildSslContext(SslContextBuilder builder, HelloParamsGrouping helloParams) throws UnsupportedConfigurationException {
        if (helloParams != null) {
            List ciphers;
            CipherSuites cipherSuites;
            TlsVersions tlsVersions = helloParams.getTlsVersions();
            if (tlsVersions != null) {
                builder.protocols(SslHandlerFactory.createTlsStrings(SslHandlerFactory.createTlsVersions(tlsVersions)));
            }
            if ((cipherSuites = helloParams.getCipherSuites()) != null && (ciphers = cipherSuites.getCipherSuite()) != null && !ciphers.isEmpty()) {
                builder.ciphers(SslHandlerFactory.createCipherStrings(ciphers));
            }
        }
        try {
            return builder.build();
        }
        catch (SSLException e) {
            throw new UnsupportedConfigurationException("Cannot instantiate TLS context", (Throwable)e);
        }
    }

    private static List<TlsVersionBase> createTlsVersions(TlsVersions versions) throws UnsupportedConfigurationException {
        TlsVersionBase min = (TlsVersionBase)Objects.requireNonNullElse(versions.getMin(), Tls12.I.VALUE);
        TlsVersionBase max = (TlsVersionBase)Objects.requireNonNullElse(versions.getMax(), Tls13.I.VALUE);
        TlsVersionBase tlsVersionBase = min;
        Objects.requireNonNull(tlsVersionBase);
        TlsVersionBase tlsVersionBase2 = tlsVersionBase;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Tls12.I.class, Tls13.I.class}, (Object)tlsVersionBase2, n)) {
            case 0 -> {
                Tls12.I min12 = (Tls12.I)tlsVersionBase2;
                TlsVersionBase v1 = max;
                Objects.requireNonNull(v1);
                TlsVersionBase var8_6 = v1;
                int var9_8 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Tls12.I.class, Tls13.I.class}, (Object)var8_6, var9_8)) {
                    case 0: {
                        Tls12.I max12 = (Tls12.I)var8_6;
                        yield List.of(max12);
                    }
                    case 1: {
                        Tls13.I max13 = (Tls13.I)var8_6;
                        yield List.of(min12, max13);
                    }
                }
                throw new UnsupportedConfigurationException("Unsupported TLS version " + String.valueOf(min));
            }
            case 1 -> {
                Tls13.I min13 = (Tls13.I)tlsVersionBase2;
                TlsVersionBase v3 = max;
                Objects.requireNonNull(v3);
                TlsVersionBase var11_12 = v3;
                int var12_13 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Tls12.I.class, Tls13.I.class}, (Object)var11_12, var12_13)) {
                    case 0: {
                        Tls12.I max12 = (Tls12.I)var11_12;
                        throw new UnsupportedConfigurationException("Invalid TLS version range in " + String.valueOf(versions));
                    }
                    case 1: {
                        Tls13.I max13 = (Tls13.I)var11_12;
                        yield List.of(Tls13.I.VALUE);
                    }
                }
                throw new UnsupportedConfigurationException("Unsupported TLS version " + String.valueOf(min));
            }
            default -> throw new UnsupportedConfigurationException("Unsupported TLS version " + String.valueOf(min));
        };
    }

    private static String[] createTlsStrings(List<TlsVersionBase> versions) throws UnsupportedConfigurationException {
        String[] ret = new String[versions.size()];
        int idx = 0;
        for (TlsVersionBase version : versions) {
            String str = IetfTlsCommonFeatureProvider.algorithmNameOf(version);
            if (str == null) {
                throw new UnsupportedConfigurationException("Unhandled TLS version " + String.valueOf(version));
            }
            ret[idx++] = str;
        }
        return ret;
    }

    private static ImmutableList<String> createCipherStrings(List<TlsCipherSuiteAlgorithm> ciphers) throws UnsupportedConfigurationException {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)ciphers.size());
        for (TlsCipherSuiteAlgorithm cipher : ciphers) {
            String str = (String)CIPHER_SUITES.get((Object)cipher);
            if (str == null) {
                throw new UnsupportedConfigurationException("Unhandled cipher suite " + String.valueOf(cipher));
            }
            builder.add((Object)str);
        }
        return builder.build();
    }
}

