/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.yanglib.writer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.yanglib.writer.YangLibrarySchemaSourceUrlProvider;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.datastores.rev180214.Datastore;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.datastores.rev180214.Operational;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.ModulesState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.ModulesStateBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.RevisionIdentifier;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.YangLibrary;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.YangLibraryBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.list.CommonLeafs;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.list.Module;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.list.ModuleBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.list.module.Deviation;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.list.module.DeviationBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.list.module.DeviationKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.set.parameters.module.SubmoduleBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.yang.library.parameters.DatastoreBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.yang.library.parameters.ModuleSetBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.yang.library.parameters.SchemaBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.binding.util.BindingMap;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleLike;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;

final class YangLibraryContentBuilderUtil {
    @Deprecated
    private static final CommonLeafs.Revision EMPTY_REVISION = new CommonLeafs.Revision("");
    static final String DEFAULT_MODULE_SET_NAME = "ODL_modules";
    static final String DEFAULT_SCHEMA_NAME = "ODL_schema";

    private YangLibraryContentBuilderUtil() {
    }

    @NonNullByDefault
    static YangLibrary buildYangLibrary(EffectiveModelContext context, String contentId, YangLibrarySchemaSourceUrlProvider urlProvider) {
        Map<QNameModule, Set<Module>> deviationsMap = YangLibraryContentBuilderUtil.getDeviationsMap(context);
        return new YangLibraryBuilder().setModuleSet(BindingMap.of((KeyAware)new ModuleSetBuilder().setName(DEFAULT_MODULE_SET_NAME).setModule((Map)context.getModules().stream().map(module -> YangLibraryContentBuilderUtil.buildModule(module, deviationsMap, urlProvider)).collect(BindingMap.toMap())).build())).setSchema(BindingMap.of((KeyAware)new SchemaBuilder().setName(DEFAULT_SCHEMA_NAME).setModuleSet(Set.of(DEFAULT_MODULE_SET_NAME)).build())).setDatastore(BindingMap.of((KeyAware)new DatastoreBuilder().setName((Datastore)Operational.VALUE).setSchema(DEFAULT_SCHEMA_NAME).build())).setContentId(contentId).build();
    }

    private static @NonNull org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.set.parameters.Module buildModule(@NonNull Module module, @NonNull Map<QNameModule, Set<Module>> deviationsMap, @NonNull YangLibrarySchemaSourceUrlProvider urlProvider) {
        return new org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.set.parameters.ModuleBuilder().setName(YangLibraryContentBuilderUtil.buildModuleKeyName((ModuleLike)module)).setRevision(YangLibraryContentBuilderUtil.buildRevision((ModuleLike)module)).setNamespace(new Uri(module.getNamespace().toString())).setFeature(YangLibraryContentBuilderUtil.buildFeatures((ModuleLike)module)).setDeviation(YangLibraryContentBuilderUtil.buildDeviations(module, deviationsMap)).setLocation(YangLibraryContentBuilderUtil.buildSchemaSourceUrls((ModuleLike)module, urlProvider)).setSubmodule((Map)module.getSubmodules().stream().map(subModule -> new SubmoduleBuilder().setName(YangLibraryContentBuilderUtil.buildModuleKeyName((ModuleLike)subModule)).setRevision(YangLibraryContentBuilderUtil.buildRevision((ModuleLike)subModule)).setLocation(YangLibraryContentBuilderUtil.buildSchemaSourceUrls((ModuleLike)subModule, urlProvider)).build()).collect(BindingMap.toMap())).build();
    }

    @Deprecated
    static ModulesState buildModuleState(@NonNull EffectiveModelContext context, @NonNull String moduleSetId, @NonNull YangLibrarySchemaSourceUrlProvider urlProvider) {
        Map<QNameModule, Set<Module>> deviationsMap = YangLibraryContentBuilderUtil.getDeviationsMap(context);
        return new ModulesStateBuilder().setModule((Map)context.getModules().stream().map(module -> YangLibraryContentBuilderUtil.buildLegacyModule(module, deviationsMap, urlProvider)).collect(BindingMap.toMap())).setModuleSetId(moduleSetId).build();
    }

    @Deprecated
    private static @NonNull org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.list.Module buildLegacyModule(@NonNull Module module, @NonNull Map<QNameModule, Set<Module>> deviationsMap, @NonNull YangLibrarySchemaSourceUrlProvider urlProvider) {
        return new ModuleBuilder().setName(YangLibraryContentBuilderUtil.buildModuleKeyName((ModuleLike)module)).setRevision(YangLibraryContentBuilderUtil.buildLegacyRevision((ModuleLike)module)).setNamespace(new Uri(module.getNamespace().toString())).setFeature(YangLibraryContentBuilderUtil.buildFeatures((ModuleLike)module)).setSchema(YangLibraryContentBuilderUtil.buildSchemaSourceUrl((ModuleLike)module, urlProvider)).setConformanceType(YangLibraryContentBuilderUtil.hasDeviations(module) ? Module.ConformanceType.Implement : Module.ConformanceType.Import).setDeviation(YangLibraryContentBuilderUtil.buildLegacyDeviations(module, deviationsMap)).setSubmodule((Map)module.getSubmodules().stream().map(subModule -> new org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.list.module.SubmoduleBuilder().setName(YangLibraryContentBuilderUtil.buildModuleKeyName((ModuleLike)subModule)).setRevision(YangLibraryContentBuilderUtil.buildLegacyRevision((ModuleLike)subModule)).setSchema(YangLibraryContentBuilderUtil.buildSchemaSourceUrl((ModuleLike)subModule, urlProvider)).build()).collect(BindingMap.toMap())).build();
    }

    private static RevisionIdentifier buildRevision(ModuleLike module) {
        Revision revision = module.getQNameModule().revision();
        return revision != null ? new RevisionIdentifier(revision.toString()) : null;
    }

    @Deprecated
    private static CommonLeafs.Revision buildLegacyRevision(ModuleLike module) {
        Revision revision = module.getQNameModule().revision();
        return revision != null ? new CommonLeafs.Revision(new RevisionIdentifier(revision.toString())) : EMPTY_REVISION;
    }

    private static YangIdentifier buildModuleKeyName(ModuleLike module) {
        Revision revision = module.getQNameModule().revision();
        return revision == null ? new YangIdentifier(module.getName()) : new YangIdentifier(module.getName() + "_" + revision);
    }

    @Deprecated
    private static @Nullable Uri buildSchemaSourceUrl(@NonNull ModuleLike module, @NonNull YangLibrarySchemaSourceUrlProvider urlProvider) {
        Set<Uri> uris = YangLibraryContentBuilderUtil.buildSchemaSourceUrls(module, urlProvider);
        return uris == null ? null : uris.iterator().next();
    }

    private static @Nullable Set<Uri> buildSchemaSourceUrls(@NonNull ModuleLike module, @NonNull YangLibrarySchemaSourceUrlProvider urlProvider) {
        Set<Uri> uris = urlProvider.getSchemaSourceUrl(DEFAULT_MODULE_SET_NAME, module.getName(), module.getRevision().orElse(null));
        return uris.isEmpty() ? null : uris;
    }

    private static @Nullable Set<YangIdentifier> buildFeatures(ModuleLike module) {
        Collection moduleFeatures = module.getFeatures();
        if (moduleFeatures == null || moduleFeatures.isEmpty()) {
            return null;
        }
        QNameModule namespace = module.getQNameModule();
        Set<YangIdentifier> features = module.getFeatures().stream().map(SchemaNode::getQName).filter(featureName -> namespace.equals((Object)featureName.getModule())).map(featureName -> new YangIdentifier(featureName.getLocalName())).collect(Collectors.toUnmodifiableSet());
        return features.isEmpty() ? null : features;
    }

    private static boolean hasDeviations(Module module) {
        return module.getDeviations() != null && !module.getDeviations().isEmpty();
    }

    private static @Nullable Set<YangIdentifier> buildDeviations(Module module, Map<QNameModule, Set<Module>> deviationsMap) {
        Set<Module> deviationModules = deviationsMap.get(module.getQNameModule());
        return deviationModules == null ? null : (Set)deviationModules.stream().map(devModule -> new YangIdentifier(YangLibraryContentBuilderUtil.buildModuleKeyName((ModuleLike)devModule))).collect(ImmutableSet.toImmutableSet());
    }

    @Deprecated
    private static @Nullable Map<DeviationKey, Deviation> buildLegacyDeviations(Module module, Map<QNameModule, Set<Module>> deviationsMap) {
        Set<Module> deviationModules = deviationsMap.get(module.getQNameModule());
        return deviationModules == null ? null : (Map)deviationModules.stream().map(devModule -> new DeviationBuilder().setName(YangLibraryContentBuilderUtil.buildModuleKeyName((ModuleLike)devModule)).setRevision(YangLibraryContentBuilderUtil.buildLegacyRevision((ModuleLike)devModule)).build()).collect(BindingMap.toMap());
    }

    private static @NonNull Map<QNameModule, Set<Module>> getDeviationsMap(EffectiveModelContext context) {
        HashMap<QNameModule, Set> result = new HashMap<QNameModule, Set>();
        for (Module module : context.getModules()) {
            if (module.getDeviations() == null || module.getDeviations().isEmpty()) continue;
            for (org.opendaylight.yangtools.yang.model.api.Deviation deviation : module.getDeviations()) {
                QNameModule targetQname = deviation.getTargetPath().lastNodeIdentifier().getModule();
                result.computeIfAbsent(targetQname, key -> new HashSet()).add(module);
            }
        }
        return ImmutableMap.copyOf(result);
    }
}

