/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.yanglib.writer;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.TransactionChain;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.netconf.yanglib.writer.YangLibraryContentBuilderUtil;
import org.opendaylight.netconf.yanglib.writer.YangLibrarySchemaSourceUrlProvider;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.ModulesState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.YangLibrary;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class YangLibraryWriter
implements FutureCallback<Empty> {
    private static final Logger LOG = LoggerFactory.getLogger(YangLibraryWriter.class);
    private static final InstanceIdentifier<YangLibrary> YANG_LIBRARY_INSTANCE_IDENTIFIER = InstanceIdentifier.create(YangLibrary.class);
    @Deprecated
    private static final InstanceIdentifier<ModulesState> MODULES_STATE_INSTANCE_IDENTIFIER = InstanceIdentifier.create(ModulesState.class);
    private final AtomicLong idCounter = new AtomicLong();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final @NonNull YangLibrarySchemaSourceUrlProvider urlProvider;
    private final DataBroker dataBroker;
    private final boolean writeLegacy;
    private final Registration reg;
    private TransactionChain currentChain;

    YangLibraryWriter(DOMSchemaService schemaService, DataBroker dataBroker, boolean writeLegacy, YangLibrarySchemaSourceUrlProvider urlProvider) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
        this.urlProvider = Objects.requireNonNull(urlProvider);
        this.writeLegacy = writeLegacy;
        this.reg = schemaService.registerSchemaContextListener(this::onModelContextUpdated);
        LOG.info("ietf-yang-library writer started with modules-state {}", (Object)(writeLegacy ? "enabled" : "disabled"));
    }

    synchronized ListenableFuture<Empty> shutdown() {
        ListenableFuture future;
        if (!this.closed.compareAndSet(false, true)) {
            return null;
        }
        this.reg.close();
        try (TransactionChain chain = this.acquireChain();){
            future = chain.future();
            WriteTransaction tx = chain.newWriteOnlyTransaction();
            tx.delete(LogicalDatastoreType.OPERATIONAL, YANG_LIBRARY_INSTANCE_IDENTIFIER);
            tx.delete(LogicalDatastoreType.OPERATIONAL, MODULES_STATE_INSTANCE_IDENTIFIER);
            tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

                public void onSuccess(CommitInfo info) {
                    LOG.debug("ietf-yang-library cleaned successfully");
                }

                public void onFailure(Throwable throwable) {
                }
            }, MoreExecutors.directExecutor());
        }
        this.currentChain = null;
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Empty>(){

            public void onSuccess(Empty value) {
                LOG.info("ietf-yang-library writer stopped");
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("ietf-yang-library writer stopped uncleanly", throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return future;
    }

    private void onModelContextUpdated(EffectiveModelContext context) {
        if (context.findModule(YangLibrary.QNAME.getModule()).isPresent()) {
            this.updateYangLibrary(context);
        } else {
            LOG.warn("ietf-yang-library not present in context, skipping update");
        }
    }

    private synchronized void updateYangLibrary(EffectiveModelContext context) {
        if (this.closed.get()) {
            LOG.debug("ietf-yang-library writer closed, skipping update");
            return;
        }
        String nextId = String.valueOf(this.idCounter.incrementAndGet());
        LOG.debug("ietf-yang-library writer starting update to {}", (Object)nextId);
        WriteTransaction tx = this.acquireChain().newWriteOnlyTransaction();
        tx.put(LogicalDatastoreType.OPERATIONAL, YANG_LIBRARY_INSTANCE_IDENTIFIER, (DataObject)YangLibraryContentBuilderUtil.buildYangLibrary(context, nextId, this.urlProvider));
        if (this.writeLegacy) {
            tx.put(LogicalDatastoreType.OPERATIONAL, MODULES_STATE_INSTANCE_IDENTIFIER, (DataObject)YangLibraryContentBuilderUtil.buildModuleState(context, nextId, this.urlProvider));
        } else {
            tx.delete(LogicalDatastoreType.OPERATIONAL, MODULES_STATE_INSTANCE_IDENTIFIER);
        }
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.debug("ietf-yang-library updated successfully");
            }

            public void onFailure(Throwable throwable) {
            }
        }, MoreExecutors.directExecutor());
    }

    private TransactionChain acquireChain() {
        TransactionChain local = this.currentChain;
        if (local == null) {
            this.currentChain = local = this.dataBroker.createMergingTransactionChain();
            LOG.debug("Allocated new transaction chain");
            local.addCallback((FutureCallback)this);
        }
        return local;
    }

    public synchronized void onSuccess(Empty result) {
        LOG.debug("ietf-yang-library writer transaction chain succeeded");
        this.currentChain = null;
    }

    public synchronized void onFailure(Throwable cause) {
        LOG.info("ietf-yang-library writer transaction chain failed", cause);
        this.currentChain = null;
    }
}

