/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.yanglib.writer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.singleton.api.ClusterSingletonService;
import org.opendaylight.mdsal.singleton.api.ClusterSingletonServiceProvider;
import org.opendaylight.mdsal.singleton.api.ServiceGroupIdentifier;
import org.opendaylight.netconf.yanglib.writer.YangLibrarySchemaSourceUrlProvider;
import org.opendaylight.netconf.yanglib.writer.YangLibraryWriter;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.Empty;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(service={}, configurationPid={"org.opendaylight.netconf.yanglib"})
@Designate(ocd=Configuration.class)
public final class YangLibraryWriterSingleton
implements ClusterSingletonService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(YangLibraryWriterSingleton.class);
    private static final @NonNull ServiceGroupIdentifier SGI = new ServiceGroupIdentifier("yanglib-mdsal-writer");
    private final @NonNull YangLibrarySchemaSourceUrlProvider urlProvider;
    private final DOMSchemaService schemaService;
    private final DataBroker dataBroker;
    private final boolean writeLegacy;
    private YangLibraryWriter instance;
    private Registration reg;

    public YangLibraryWriterSingleton(ClusterSingletonServiceProvider cssProvider, DOMSchemaService schemaService, DataBroker dataBroker, boolean writeLegacy, @Nullable YangLibrarySchemaSourceUrlProvider urlProvider) {
        this.schemaService = Objects.requireNonNull(schemaService);
        this.dataBroker = Objects.requireNonNull(dataBroker);
        this.urlProvider = YangLibraryWriterSingleton.orEmptyProvider(urlProvider);
        this.writeLegacy = writeLegacy;
        this.reg = cssProvider.registerClusterSingletonService((ClusterSingletonService)this);
        LOG.info("ietf-yang-library writer registered");
    }

    public YangLibraryWriterSingleton(ClusterSingletonServiceProvider cssProvider, DOMSchemaService schemaService, DataBroker dataBroker, boolean writeLegacy) {
        this(cssProvider, schemaService, dataBroker, writeLegacy, null);
    }

    @Inject
    public YangLibraryWriterSingleton(ClusterSingletonServiceProvider cssProvider, DOMSchemaService schemaService, DataBroker dataBroker, Optional<YangLibrarySchemaSourceUrlProvider> urlProvider) {
        this(cssProvider, schemaService, dataBroker, true, urlProvider.orElse(null));
    }

    @Activate
    public YangLibraryWriterSingleton(@Reference ClusterSingletonServiceProvider cssProvider, @Reference DOMSchemaService schemaService, @Reference DataBroker dataBroker, @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY) @Nullable YangLibrarySchemaSourceUrlProvider urlProvider, Configuration configuration) {
        this(cssProvider, schemaService, dataBroker, configuration.write$_$legacy(), urlProvider);
    }

    @Override
    @PreDestroy
    @Deactivate
    public synchronized void close() {
        if (this.reg == null) {
            return;
        }
        this.reg.close();
        this.reg = null;
        LOG.info("ietf-yang-library writer unregistered");
    }

    private static @NonNull YangLibrarySchemaSourceUrlProvider orEmptyProvider(@Nullable YangLibrarySchemaSourceUrlProvider urlProvider) {
        return urlProvider != null ? urlProvider : YangLibraryWriterSingleton.emptyProvider();
    }

    @VisibleForTesting
    static @NonNull YangLibrarySchemaSourceUrlProvider emptyProvider() {
        return (moduleSetName, moduleName, revision) -> Set.of();
    }

    public ServiceGroupIdentifier getIdentifier() {
        return SGI;
    }

    public synchronized void instantiateServiceInstance() {
        this.instance = new YangLibraryWriter(this.schemaService, this.dataBroker, this.writeLegacy, this.urlProvider);
    }

    public synchronized ListenableFuture<Empty> closeServiceInstance() {
        YangLibraryWriter local = this.instance;
        if (local == null) {
            return Empty.immediateFuture();
        }
        this.instance = null;
        return local.shutdown();
    }

    @ObjectClassDefinition
    public static @interface Configuration {
        @AttributeDefinition(description="Maintain RFC7895-compatible modules-state container. Defaults to true.")
        public boolean write$_$legacy() default true;
    }
}

