/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.odlparent.bundlestest.lib;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.karaf.bundle.core.BundleInfo;
import org.apache.karaf.bundle.core.BundleService;
import org.apache.karaf.bundle.core.BundleState;
import org.opendaylight.odlparent.bundlestest.lib.BundleDiagInfos;
import org.opendaylight.odlparent.bundlestest.lib.BundleSymbolicNameWithVersion;
import org.opendaylight.odlparent.bundlestest.lib.SystemState;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

final class BundleDiagInfosImpl
implements BundleDiagInfos {
    private static final long serialVersionUID = 1L;
    private static final Map<String, BundleState> WHITELISTED_BUNDLES = new HashMap<String, BundleState>();
    private final List<String> okBundleStateInfoTexts;
    private final List<String> nokBundleStateInfoTexts;
    private final List<String> whitelistedBundleStateInfoTexts;
    private final Map<BundleState, Integer> bundleStatesCounters;
    private final Map<BundleSymbolicNameWithVersion, BundleState> bundlesStateMap;

    private BundleDiagInfosImpl(List<String> okBundleStateInfoTexts, List<String> nokBundleStateInfoTexts, List<String> whitelistedBundleStateInfoTexts, Map<BundleState, Integer> bundleStatesCounters, Map<BundleSymbolicNameWithVersion, BundleState> bundlesStateMap) {
        this.okBundleStateInfoTexts = okBundleStateInfoTexts;
        this.nokBundleStateInfoTexts = nokBundleStateInfoTexts;
        this.whitelistedBundleStateInfoTexts = whitelistedBundleStateInfoTexts;
        this.bundleStatesCounters = bundleStatesCounters;
        this.bundlesStateMap = bundlesStateMap;
    }

    public static BundleDiagInfos forContext(BundleContext bundleContext, BundleService bundleService) {
        ArrayList<CallSite> okBundleStateInfoTexts = new ArrayList<CallSite>();
        ArrayList<CallSite> nokBundleStateInfoTexts = new ArrayList<CallSite>();
        ArrayList<CallSite> whitelistedBundleStateInfoTexts = new ArrayList<CallSite>();
        HashMap<BundleSymbolicNameWithVersion, BundleState> bundlesStateMap = new HashMap<BundleSymbolicNameWithVersion, BundleState>();
        EnumMap<BundleState, Integer> bundleStatesCounters = new EnumMap<BundleState, Integer>(BundleState.class);
        for (BundleState bundleState : BundleState.values()) {
            bundleStatesCounters.put(bundleState, 0);
        }
        for (BundleState bundleState : bundleContext.getBundles()) {
            String msg;
            String bundleSymbolicName = bundleState.getSymbolicName();
            BundleSymbolicNameWithVersion bundleSymbolicNameWithVersion = new BundleSymbolicNameWithVersion(bundleSymbolicName, bundleState.getVersion().toString());
            BundleInfo karafBundleInfo = bundleService.getInfo((Bundle)bundleState);
            String diagText = bundleService.getDiag((Bundle)bundleState);
            BundleState karafBundleState = karafBundleInfo.getState();
            bundlesStateMap.put(bundleSymbolicNameWithVersion, karafBundleState);
            String bundleStateDiagText = "OSGi state = " + BundleDiagInfosImpl.bundleStateToText(bundleState.getState()) + ", Karaf bundleState = " + karafBundleState + (String)(diagText.isEmpty() ? "" : ", due to: " + diagText);
            if (WHITELISTED_BUNDLES.get(bundleSymbolicName) != null && WHITELISTED_BUNDLES.get(bundleSymbolicName).equals((Object)karafBundleState)) {
                msg = "WHITELISTED " + bundleSymbolicNameWithVersion + ": " + bundleStateDiagText;
                whitelistedBundleStateInfoTexts.add((CallSite)((Object)msg));
                continue;
            }
            bundleStatesCounters.compute(karafBundleState, (key, counter) -> counter + 1);
            if (karafBundleState != BundleState.Active && karafBundleState != BundleState.Resolved) {
                msg = "NOK " + bundleSymbolicNameWithVersion + ": " + bundleStateDiagText;
                nokBundleStateInfoTexts.add((CallSite)((Object)msg));
                continue;
            }
            msg = "OK " + bundleSymbolicNameWithVersion + ": " + bundleStateDiagText;
            okBundleStateInfoTexts.add((CallSite)((Object)msg));
        }
        return new BundleDiagInfosImpl(Collections.unmodifiableList(okBundleStateInfoTexts), Collections.unmodifiableList(nokBundleStateInfoTexts), Collections.unmodifiableList(whitelistedBundleStateInfoTexts), Collections.unmodifiableMap(bundleStatesCounters), Collections.unmodifiableMap(bundlesStateMap));
    }

    private static String bundleStateToText(int state) {
        return switch (state) {
            case 2 -> "Installed";
            case 4 -> "Resolved";
            case 8 -> "Starting";
            case 32 -> "Active";
            case 16 -> "Stopping";
            case 1 -> "Uninstalled";
            default -> state + "???";
        };
    }

    @Override
    public SystemState getSystemState() {
        if (this.bundleStatesCounters.get(BundleState.Failure) > 0) {
            return SystemState.Failure;
        }
        if (this.bundleStatesCounters.get(BundleState.Stopping) > 0) {
            return SystemState.Stopping;
        }
        if (this.bundleStatesCounters.get(BundleState.Installed) == 0 && this.bundleStatesCounters.get(BundleState.Unknown) == 0 && this.bundleStatesCounters.get(BundleState.GracePeriod) == 0 && this.bundleStatesCounters.get(BundleState.Waiting) == 0 && this.bundleStatesCounters.get(BundleState.Starting) == 0 && this.bundleStatesCounters.get(BundleState.Stopping) == 0 && this.bundleStatesCounters.get(BundleState.Failure) == 0) {
            return SystemState.Active;
        }
        return SystemState.Booting;
    }

    @Override
    public String getFullDiagnosticText() {
        StringBuilder sb = new StringBuilder(this.getSummaryText());
        int failureNumber = 1;
        for (String nokBundleStateInfoText : this.getNokBundleStateInfoTexts()) {
            sb.append('\n');
            sb.append(failureNumber++);
            sb.append(". ");
            sb.append(nokBundleStateInfoText);
        }
        return sb.toString();
    }

    @Override
    public String getSummaryText() {
        return "diag: " + this.getSystemState() + " " + this.bundleStatesCounters.toString();
    }

    @Override
    public Map<BundleSymbolicNameWithVersion, BundleState> getBundlesStateMap() {
        return this.bundlesStateMap;
    }

    @Override
    public List<String> getNokBundleStateInfoTexts() {
        return this.nokBundleStateInfoTexts;
    }

    @Override
    public List<String> getOkBundleStateInfoTexts() {
        return this.okBundleStateInfoTexts;
    }

    @Override
    public List<String> getWhitelistedBundleStateInfoTexts() {
        return this.whitelistedBundleStateInfoTexts;
    }

    public String toString() {
        return this.getFullDiagnosticText();
    }

    static {
        WHITELISTED_BUNDLES.put("slf4j.log4j12", BundleState.Installed);
        WHITELISTED_BUNDLES.put("org.apache.karaf.scr.management", BundleState.Waiting);
    }
}

