/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.odlparent.bundlestest.lib;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

class ServiceReferenceUtil {
    ServiceReferenceUtil() {
    }

    public Map<String, Object> getProperties(ServiceReference<?> serviceRef) {
        String[] propertyKeys = serviceRef.getPropertyKeys();
        HashMap<String, Object> properties = new HashMap<String, Object>(propertyKeys.length);
        for (String propertyKey : propertyKeys) {
            List<Object> propertyValue = serviceRef.getProperty(propertyKey);
            if (propertyValue != null && propertyValue.getClass().isArray()) {
                propertyValue = Arrays.asList((Object[])propertyValue);
            }
            properties.put(propertyKey, propertyValue);
        }
        return properties;
    }

    public List<String> getUsingBundleSymbolicNames(ServiceReference<?> serviceRef) {
        Bundle[] usingBundles = serviceRef.getUsingBundles();
        if (usingBundles == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(usingBundles).map(Bundle::getSymbolicName).collect(Collectors.toList());
    }
}

