/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.odlparent.bundlestest.lib;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.karaf.bundle.core.BundleService;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.hamcrest.Matcher;
import org.opendaylight.odlparent.bundlestest.lib.BundleDiagInfos;
import org.opendaylight.odlparent.bundlestest.lib.BundleDiagInfosImpl;
import org.opendaylight.odlparent.bundlestest.lib.BundleServiceSummaryMatcher;
import org.opendaylight.odlparent.bundlestest.lib.ServiceReferenceUtil;
import org.opendaylight.odlparent.bundlestest.lib.SystemState;
import org.opendaylight.odlparent.bundlestest.lib.SystemStateFailureException;
import org.opendaylight.odlparent.bundlestest.lib.TimeInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"CRLF_INJECTION_LOGS"}, justification="multi-line logs are internal, without input from untrusted external source")
public class TestBundleDiag {
    private static final Logger LOG = LoggerFactory.getLogger(TestBundleDiag.class);
    private final BundleContext bundleContext;
    private final BundleService bundleService;

    public TestBundleDiag(BundleContext bundleContext, BundleService bundleService) {
        this.bundleContext = bundleContext;
        this.bundleService = bundleService;
    }

    public void checkBundleDiagInfos(long timeout, TimeUnit timeoutUnit) throws SystemStateFailureException {
        this.checkBundleDiagInfos(timeout, timeoutUnit, (timeInfo, bundleDiagInfos) -> LOG.info("checkBundleDiagInfos: Elapsed time {}s, remaining time {}s, {}", new Object[]{timeInfo.getElapsedTimeInMS() / 1000L, timeInfo.getRemainingTimeInMS() / 1000L, bundleDiagInfos.getFullDiagnosticText()}));
    }

    public void checkBundleDiagInfos(long timeout, TimeUnit timeoutUnit, BiConsumer<TimeInfo, BundleDiagInfos> awaitingListener) throws SystemStateFailureException {
        LOG.info("checkBundleDiagInfos() started...");
        try {
            Awaitility.await((String)"checkBundleDiagInfos").pollDelay(0L, TimeUnit.MILLISECONDS).pollInterval(1L, TimeUnit.SECONDS).atMost(timeout, timeoutUnit).conditionEvaluationListener(condition -> awaitingListener.accept(new TimeInfo(condition.getElapsedTimeInMS(), condition.getRemainingTimeInMS()), (BundleDiagInfosImpl)condition.getValue())).until(this::getBundleDiagInfos, (Matcher)new BundleServiceSummaryMatcher());
            BundleDiagInfos bundleInfos = this.getBundleDiagInfos();
            SystemState systemState = bundleInfos.getSystemState();
            if (systemState.equals((Object)SystemState.Failure) || systemState.equals((Object)SystemState.Stopping)) {
                LOG.error("diag failure; BundleService reports bundle(s) which failed or are already stopping (details in following INFO and ERROR log messages...)");
                this.logBundleDiagInfos(bundleInfos);
                throw new SystemStateFailureException("diag failed; some bundles failed to start", bundleInfos);
            }
            LOG.info("diag successful; system state active ({})", (Object)bundleInfos.getFullDiagnosticText());
        }
        catch (ConditionTimeoutException e) {
            LOG.error("diag failure; BundleService reports bundle(s) which are still not active (details in following INFO and ERROR log messages...)");
            BundleDiagInfos bundleInfos = this.getBundleDiagInfos();
            this.logBundleDiagInfos(bundleInfos);
            throw new SystemStateFailureException("diag timeout; some bundles are still not active:", bundleInfos, e);
        }
    }

    private void logBundleDiagInfos(BundleDiagInfos bundleInfos) {
        try {
            this.logOSGiServices();
        }
        catch (IllegalStateException e) {
            LOG.warn("logOSGiServices() failed (never mind); too late during shutdown already?", (Throwable)e);
        }
        for (String okBundleStateInfo : bundleInfos.getOkBundleStateInfoTexts()) {
            LOG.info(okBundleStateInfo);
        }
        for (String whitelistedBundleStateInfo : bundleInfos.getWhitelistedBundleStateInfoTexts()) {
            LOG.warn(whitelistedBundleStateInfo);
        }
        for (String nokBundleStateInfo : bundleInfos.getNokBundleStateInfoTexts()) {
            LOG.error(nokBundleStateInfo);
        }
    }

    private BundleDiagInfos getBundleDiagInfos() {
        return BundleDiagInfosImpl.forContext(this.bundleContext, this.bundleService);
    }

    private void logOSGiServices() {
        ServiceReferenceUtil util = new ServiceReferenceUtil();
        LOG.info("Now going to log all known services, to help diagnose root cause of diag failure BundleService reported bundle(s) which are not active");
        try {
            for (ServiceReference serviceRef : this.bundleContext.getAllServiceReferences(null, null)) {
                Bundle bundle = serviceRef.getBundle();
                if (bundle != null) {
                    LOG.info("{} defines OSGi Service {} used by {}", new Object[]{bundle.getSymbolicName(), util.getProperties(serviceRef), util.getUsingBundleSymbolicNames(serviceRef)});
                    continue;
                }
                LOG.trace("skipping reporting service reference as the underlying bundle is null");
            }
        }
        catch (InvalidSyntaxException e) {
            LOG.error("logOSGiServices() failed due to InvalidSyntaxException", (Throwable)e);
        }
    }
}

