/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.odlparent.featuretest;

import java.net.URL;
import java.rmi.NoSuchObjectException;
import java.util.Objects;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.opendaylight.odlparent.featuretest.Util;

public class PerFeatureRunNotifier
extends RunNotifier {
    private final RunNotifier delegate;
    private final URL repoUrl;
    private final String featureName;
    private final String featureVersion;

    public PerFeatureRunNotifier(URL repoUrl, String featureName, String featureVersion, RunNotifier delegate) {
        this.repoUrl = Objects.requireNonNull(repoUrl);
        this.featureName = Objects.requireNonNull(featureName);
        this.featureVersion = Objects.requireNonNull(featureVersion);
        this.delegate = Objects.requireNonNull(delegate);
    }

    private Failure convertFailure(Failure failure) {
        return new Failure(Util.convertDescription(this.repoUrl, this.featureName, this.featureVersion, failure.getDescription()), failure.getException());
    }

    public void addListener(RunListener listener) {
        this.delegate.addListener(listener);
    }

    public void removeListener(RunListener listener) {
        this.delegate.removeListener(listener);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public void fireTestRunStarted(Description description) {
        this.delegate.fireTestRunStarted(Util.convertDescription(this.repoUrl, this.featureName, this.featureVersion, description));
    }

    public void fireTestRunFinished(Result result) {
        this.delegate.fireTestRunFinished(result);
    }

    public void fireTestStarted(Description description) {
        this.delegate.fireTestStarted(Util.convertDescription(this.repoUrl, this.featureName, this.featureVersion, description));
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public void fireTestFailure(Failure failure) {
        if (!(failure.getException() instanceof NoSuchObjectException)) {
            this.delegate.fireTestFailure(this.convertFailure(failure));
        }
    }

    public void fireTestAssumptionFailed(Failure failure) {
        this.delegate.fireTestAssumptionFailed(this.convertFailure(failure));
    }

    public void fireTestIgnored(Description description) {
        this.delegate.fireTestIgnored(Util.convertDescription(this.repoUrl, this.featureName, this.featureVersion, description));
    }

    public void fireTestFinished(Description description) {
        this.delegate.fireTestFinished(Util.convertDescription(this.repoUrl, this.featureName, this.featureVersion, description));
    }

    public void pleaseStop() {
        this.delegate.pleaseStop();
    }

    public void addFirstListener(RunListener listener) {
        this.delegate.addFirstListener(listener);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

