/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.odlparent.featuretest;

import java.net.URL;
import java.util.Objects;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.opendaylight.odlparent.featuretest.PerFeatureRunNotifier;
import org.opendaylight.odlparent.featuretest.Util;
import org.ops4j.pax.exam.junit.PaxExam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerFeatureRunner
extends Runner
implements Filterable,
Sortable {
    private static final Logger LOG = LoggerFactory.getLogger(PerFeatureRunner.class);
    private final String featureVersion;
    private final String featureName;
    private final PaxExam delegate;
    private final URL repoUrl;

    public PerFeatureRunner(URL repoUrl, String featureName, String featureVersion, Class<?> testClass) throws InitializationError {
        this.repoUrl = Objects.requireNonNull(repoUrl);
        this.featureName = Objects.requireNonNull(featureName);
        this.featureVersion = Objects.requireNonNull(featureVersion);
        System.setProperty("org.opendaylight.featuretest.uri", repoUrl.toString());
        System.setProperty("org.opendaylight.featuretest.featurename", featureName);
        System.setProperty("org.opendaylight.featuretest.featureversion", featureVersion);
        this.delegate = new PaxExam(Objects.requireNonNull(testClass));
    }

    public Description getDescription() {
        return Util.convertDescription(this.repoUrl, this.featureName, this.featureVersion, this.delegate.getDescription());
    }

    public void run(RunNotifier notifier) {
        LOG.info("About to run test for feature: {} {}", (Object)this.featureName, (Object)this.featureVersion);
        System.setProperty("org.opendaylight.featuretest.uri", this.repoUrl.toString());
        System.setProperty("org.opendaylight.featuretest.featurename", this.featureName);
        System.setProperty("org.opendaylight.featuretest.featureversion", this.featureVersion);
        this.delegate.run((RunNotifier)new PerFeatureRunNotifier(this.repoUrl, this.featureName, this.featureVersion, notifier));
    }

    public int testCount() {
        return this.delegate.testCount();
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        this.delegate.filter(filter);
    }

    public void sort(Sorter sorter) {
        this.delegate.sort(sorter);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public URL getRepoUrl() {
        return this.repoUrl;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getFeatureVersion() {
        return this.featureVersion;
    }
}

