/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.odlparent.featuretest;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.karaf.bundle.core.BundleService;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.awaitility.Awaitility;
import org.eclipse.jdt.annotation.NonNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opendaylight.odlparent.bundlestest.lib.TestBundleDiag;
import org.opendaylight.odlparent.featuretest.KarafConstants;
import org.opendaylight.odlparent.featuretest.PerRepoTestRunner;
import org.opendaylight.odlparent.featuretest.ReflectionUtil;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.ProbeBuilder;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.karaf.container.internal.JavaVersionUtil;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.options.extra.VMOption;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=PerRepoTestRunner.class)
public class SingleFeatureTest {
    private static final String MAVEN_REPO_LOCAL = "maven.repo.local";
    private static final String ETC_ORG_OPS4J_PAX_URL_MVN_CFG = "etc/org.ops4j.pax.url.mvn.cfg";
    private static final String ETC_ORG_OPS4J_PAX_LOGGING_CFG = "etc/org.ops4j.pax.logging.cfg";
    private static final String KEEP_UNPACK_DIRECTORY_PROP = "karaf.keep.unpack";
    private static final String PROFILE_PROP = "karaf.featureTest.profile";
    private static final String BUNDLES_DIAG_SKIP_PROP = "sft.diag.skip";
    private static final String BUNDLES_DIAG_TIMEOUT_PROP = "sft.diag.timeout";
    private static final String HEAP_MAX_PROP = "sft.heap.max";
    private static final String DEFAULT_HEAP_MAX = "2g";
    private static final String HEAP_DUMP_PATH_PROP = "sft.heap.dump.path";
    private static final String DEFAULT_HEAP_DUMP_PATH = "/dev/null";
    private static final Logger LOG = LoggerFactory.getLogger(SingleFeatureTest.class);
    private static final String ORG_OPS4J_PAX_LOGGING_CFG = "etc/org.ops4j.pax.logging.cfg";
    private static final String KARAF_DISTRO_TYPE = "zip";
    private static final String KARAF_DISTRO_ARTIFACTID = "opendaylight-karaf-empty";
    private static final String KARAF_DISTRO_GROUPID = "org.opendaylight.odlparent";
    private static final String KARAF_DISTRO_TYPE_PROP = "karaf.distro.type";
    private static final String KARAF_DISTRO_ARTIFACTID_PROP = "karaf.distro.artifactId";
    private static final String KARAF_DISTRO_GROUPID_PROP = "karaf.distro.groupId";
    private static final String EXTERNAL_DEFAULT_REPOSITORIES = "https://repo1.maven.org/maven2@id=central ";
    @Inject
    private @NonNull BundleContext bundleContext;
    @Inject
    private @NonNull BundleService bundleService;
    @Inject
    private @NonNull FeaturesService featuresService;
    private String karafReleaseVersion;
    private String karafDistroVersion;

    @ProbeBuilder
    public TestProbeBuilder probeConfiguration(TestProbeBuilder probe) {
        ReflectionUtil.addAllClassesInSameAndSubPackageOfClass(probe, TestBundleDiag.class);
        ReflectionUtil.addAllClassesInSameAndSubPackageOfClass(probe, Awaitility.class);
        ReflectionUtil.addAllClassesInSameAndSubPackageOfPackage(probe, "com.google.common");
        return probe;
    }

    @Configuration
    public Option[] config() throws IOException {
        String envMaxHeap = System.getProperty(HEAP_MAX_PROP);
        String maxHeap = envMaxHeap != null ? envMaxHeap : DEFAULT_HEAP_MAX;
        String envHeapDumpPath = System.getProperty(HEAP_DUMP_PATH_PROP);
        String heapDumpPath = envHeapDumpPath != null ? envHeapDumpPath : DEFAULT_HEAP_DUMP_PATH;
        File karafLogFile = new File("target/SFT/karaf.log").getAbsoluteFile();
        karafLogFile.getParentFile().mkdir();
        Option[] baseConfig = new Option[]{new VMOption("-Xmx" + maxHeap), new VMOption("-XX:+HeapDumpOnOutOfMemoryError"), new VMOption("-XX:HeapDumpPath=" + heapDumpPath), CoreOptions.when((boolean)System.getProperty("os.name").toLowerCase().startsWith("linux")).useOptions(new Option[]{new VMOption("-Djava.security.egd=file:/dev/./urandom")}), CoreOptions.when((boolean)Boolean.getBoolean(PROFILE_PROP)).useOptions(new Option[]{new VMOption("-XX:StartFlightRecording=disk=true,settings=profile,dumponexit=true,filename=" + SingleFeatureTest.getNewJFRFile())}), this.getKarafDistroOption(), CoreOptions.when((boolean)Boolean.getBoolean(KEEP_UNPACK_DIRECTORY_PROP)).useOptions(new Option[]{KarafDistributionOption.keepRuntimeFolder()}), KarafDistributionOption.configureConsole().ignoreLocalConsole().ignoreRemoteShell(), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.INFO), this.mvnLocalRepoOption(), KarafDistributionOption.editConfigurationFilePut((String)ETC_ORG_OPS4J_PAX_URL_MVN_CFG, (String)"org.ops4j.pax.url.mvn.defaultRepositories", (Object)"file:${karaf.home}/${karaf.default.repository}@id=system.repository"), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.ops4j.pax.logging.cfg", (String)"log4j2.appender.rolling.fileName", (Object)karafLogFile.getPath()), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.ops4j.pax.logging.cfg", (String)"log4j2.appender.rolling.filePattern", (Object)(karafLogFile.getPath() + ".%i")), SingleFeatureTest.disableExternalSnapshotRepositories(), CoreOptions.propagateSystemProperty((String)"org.opendaylight.featuretest.uri"), CoreOptions.propagateSystemProperty((String)"org.opendaylight.featuretest.featurename"), CoreOptions.propagateSystemProperty((String)"org.opendaylight.featuretest.featureversion"), CoreOptions.propagateSystemProperty((String)BUNDLES_DIAG_SKIP_PROP), CoreOptions.propagateSystemProperty((String)BUNDLES_DIAG_TIMEOUT_PROP), CoreOptions.systemPackages((String[])new String[]{"com.sun.media.sound", "sun.net", "sun.nio.ch"}), CoreOptions.bootDelegationPackages((String[])new String[]{"jdk.jfr", "jdk.jfr.consumer", "jdk.jfr.event", "jdk.jfr.event.handlers", "jdk.jfr.internal.*"}), KarafDistributionOption.features((UrlReference)CoreOptions.maven().groupId("org.apache.karaf.features").artifactId("standard").type("xml").classifier("features").versionAsInProject(), (String[])new String[]{"scr"}), SingleFeatureTest.jacocoOption()};
        if (JavaVersionUtil.getMajorVersion() <= 8) {
            return baseConfig;
        }
        String version = this.getKarafReleaseVersion();
        return OptionUtils.combine((Option[])baseConfig, (Option[])new Option[]{new VMOption("--add-reads=java.xml=java.logging"), new VMOption("--add-exports=java.base/org.apache.karaf.specs.locator=java.xml,ALL-UNNAMED"), new VMOption("--patch-module"), new VMOption("java.base=lib/endorsed/org.apache.karaf.specs.locator-" + version + ".jar"), new VMOption("--patch-module"), new VMOption("java.xml=lib/endorsed/org.apache.karaf.specs.java.xml-" + version + ".jar"), new VMOption("--add-opens"), new VMOption("java.base/java.security=ALL-UNNAMED"), new VMOption("--add-opens"), new VMOption("java.base/java.net=ALL-UNNAMED"), new VMOption("--add-opens"), new VMOption("java.base/java.lang=ALL-UNNAMED"), new VMOption("--add-opens"), new VMOption("java.base/java.util=ALL-UNNAMED"), new VMOption("--add-opens"), new VMOption("java.naming/javax.naming.spi=ALL-UNNAMED"), new VMOption("--add-opens"), new VMOption("java.rmi/sun.rmi.transport.tcp=ALL-UNNAMED"), new VMOption("--add-exports=java.base/sun.net.www.protocol.http=ALL-UNNAMED"), new VMOption("--add-exports=java.base/sun.net.www.protocol.https=ALL-UNNAMED"), new VMOption("--add-exports=java.base/sun.net.www.protocol.jar=ALL-UNNAMED"), new VMOption("--add-exports=jdk.naming.rmi/com.sun.jndi.url.rmi=ALL-UNNAMED"), new VMOption("-classpath"), new VMOption("lib/jdk9plus/*" + File.pathSeparator + "lib/boot/*")});
    }

    private static Option jacocoOption() {
        String sftArgLine = System.getProperty("sftArgLine");
        return sftArgLine == null || sftArgLine.isBlank() ? null : new VMOption(sftArgLine);
    }

    private static String getNewJFRFile() throws IOException {
        return File.createTempFile("SingleFeatureTest-Karaf-JavaFlightRecorder", ".jfr").getAbsolutePath();
    }

    private String getKarafReleaseVersion() throws IOException {
        if (this.karafReleaseVersion == null) {
            this.karafReleaseVersion = KarafConstants.karafReleaseVersion();
        }
        return this.karafReleaseVersion;
    }

    private String getKarafDistroVersion() {
        if (this.karafDistroVersion == null) {
            this.karafDistroVersion = KarafConstants.karafDistroVersion();
        }
        return this.karafDistroVersion;
    }

    private static Option disableExternalSnapshotRepositories() {
        return KarafDistributionOption.editConfigurationFilePut((String)ETC_ORG_OPS4J_PAX_URL_MVN_CFG, (String)"org.ops4j.pax.url.mvn.repositories", (Object)EXTERNAL_DEFAULT_REPOSITORIES);
    }

    protected Option mvnLocalRepoOption() {
        String mvnRepoLocal = System.getProperty(MAVEN_REPO_LOCAL, "");
        LOG.info("mvnLocalRepo \"{}\"", (Object)mvnRepoLocal);
        return KarafDistributionOption.editConfigurationFilePut((String)ETC_ORG_OPS4J_PAX_URL_MVN_CFG, (String)"org.ops4j.pax.url.mvn.localRepository", (Object)mvnRepoLocal);
    }

    protected Option getKarafDistroOption() throws IOException {
        String groupId = System.getProperty(KARAF_DISTRO_GROUPID_PROP, KARAF_DISTRO_GROUPID);
        String artifactId = System.getProperty(KARAF_DISTRO_ARTIFACTID_PROP, KARAF_DISTRO_ARTIFACTID);
        String type = System.getProperty(KARAF_DISTRO_TYPE_PROP, KARAF_DISTRO_TYPE);
        LOG.info("Using karaf distro {} {} {} {}", new Object[]{groupId, artifactId, this.getKarafDistroVersion(), type});
        return KarafDistributionOption.karafDistributionConfiguration().frameworkUrl((MavenUrlReference)CoreOptions.maven().groupId(groupId).artifactId(artifactId).type(type).version(this.getKarafDistroVersion())).name("OpenDaylight").unpackDirectory(new File("target/pax")).useDeployFolder(false);
    }

    private static URI getRepoUri() throws URISyntaxException {
        return new URI(SingleFeatureTest.getProperty("org.opendaylight.featuretest.uri"));
    }

    private static String getProperty(String propName) {
        String prop = System.getProperty(propName);
        Assert.assertNotNull((String)("Missing property :" + propName), (Object)prop);
        return prop;
    }

    private void checkRepository(URI repoUri) throws Exception {
        for (Repository r : this.featuresService.listRepositories()) {
            if (!r.getURI().equals(repoUri)) continue;
            return;
        }
        Assert.fail((String)("Repository not found: " + repoUri));
    }

    @Before
    public void installRepo() throws Exception {
        URI repoUri = SingleFeatureTest.getRepoUri();
        LOG.info("Attempting to add repository {}", (Object)repoUri);
        this.featuresService.addRepository(repoUri);
        this.checkRepository(repoUri);
        LOG.info("Successfully loaded repository {}", (Object)repoUri);
    }

    @Test(timeout=600000L)
    public void installFeatureCatchAndLog() throws Exception {
        try {
            this.installFeature();
        }
        catch (Throwable t) {
            LOG.error("installFeature() failed", t);
            throw t;
        }
    }

    public void installFeature() throws Exception {
        this.bundleContext = this.bundleContext.getBundle(0L).getBundleContext();
        String featureName = SingleFeatureTest.getProperty("org.opendaylight.featuretest.featurename");
        String featureVersion = SingleFeatureTest.getProperty("org.opendaylight.featuretest.featureversion");
        LOG.info("Attempting to install feature {} {}", (Object)featureName, (Object)featureVersion);
        this.featuresService.installFeature(featureName, featureVersion, EnumSet.of(FeaturesService.Option.Verbose));
        LOG.info("installFeature() completed");
        Feature feature = this.featuresService.getFeature(featureName, featureVersion);
        LOG.info("getFeature() completed");
        Assert.assertNotNull((String)("Attempt to get feature " + featureName + " " + featureVersion + "resulted in null"), (Object)feature);
        boolean isInstalled = this.featuresService.isInstalled(feature);
        LOG.info("isInstalled() completed");
        Assert.assertTrue((String)("Failed to install Feature: " + featureName + " " + featureVersion), (boolean)isInstalled);
        LOG.info("Successfully installed feature {} {}", (Object)featureName, (Object)featureVersion);
        if (!Boolean.getBoolean(BUNDLES_DIAG_SKIP_PROP)) {
            LOG.info("new TestBundleDiag().checkBundleDiagInfos() STARTING");
            Integer timeOutInSeconds = Integer.getInteger(BUNDLES_DIAG_TIMEOUT_PROP, 300);
            new TestBundleDiag(this.bundleContext, this.bundleService).checkBundleDiagInfos((long)timeOutInSeconds.intValue(), TimeUnit.SECONDS);
            LOG.info("new TestBundleDiag().checkBundleDiagInfos() ENDED");
        } else {
            LOG.warn("SKIPPING TestBundleDiag because system property {} is true: {}", (Object)BUNDLES_DIAG_SKIP_PROP, (Object)featureName);
        }
    }
}

