package org.opendaylight.serviceutils.metrics;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MetricDescriptor}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMetricDescriptor.builder()}.
 */
@Generated(from = "MetricDescriptor", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableMetricDescriptor extends MetricDescriptor {
  private final Object anchor;
  private final String project;
  private final String module;
  private final String id;
  private final String description;

  private ImmutableMetricDescriptor(ImmutableMetricDescriptor.Builder builder) {
    this.anchor = builder.anchor;
    this.project = builder.project;
    this.module = builder.module;
    this.id = builder.id;
    this.description = builder.descriptionIsSet()
        ? builder.description
        : Objects.requireNonNull(super.description(), "description");
  }

  private ImmutableMetricDescriptor(
      Object anchor,
      String project,
      String module,
      String id,
      String description) {
    this.anchor = anchor;
    this.project = project;
    this.module = module;
    this.id = id;
    this.description = description;
  }

  /**
   * Instance of the class "containing" this Metric.
   */
  @Override
  public Object anchor() {
    return anchor;
  }

  /**
   * Name of OpenDaylight project the Metric is for, unique at opendaylight.org.
   * E.g. "netvirt" or "genius" or "openflowplugin" or "infrautils" etc.
   * The project/module/id together must be unique within ODL.
   * Valid values match <code>[a-z0-9]+</code> (lower case and no dots nor underscores).
   */
  @Override
  public String project() {
    return project;
  }

  /**
   * Name of OpenDaylight module the Metric is for, unique within given {@link #project()}.
   * E.g. "vpnmanager" or "lockmanager" or "jobcoordinator" etc.
   * The project/module/id together must be unique within ODL.
   * Valid values match <code>[a-z0-9]+</code> (lower case and no dots nor underscores).
   */
  @Override
  public String module() {
    return module;
  }

  /**
   * ID of the Metric, unique within given {@link #project()} + {@link #module()}.
   * E.g. "jobsPending" or "dropped_packets" or "traffic" etc. The
   * project/module/id together must be unique within ODL. Valid values match
   * <code>[a-zA-Z0-9_]+</code> (lower and upper case and underscore allowed, but
   * not starting with).  The dot character is not allowed here because at least
   * one of the implementations (Prometheus.io) does not accept dots in its IDs.
   */
  @Override
  public String id() {
    return id;
  }

  /**
   * Human readable description of the Metric.  E.g. "Counts the number of bla bla bla".
   * No validation of valid values; anything goes.  Defaults to be the same as id();
   * but highly recommended to be set so that external Dashboard type UIs can show it
   * as documentation or help for this Metric.
   */
  @Override
  public String description() {
    return description;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MetricDescriptor#anchor() anchor} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for anchor
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMetricDescriptor withAnchor(Object value) {
    if (this.anchor == value) return this;
    Object newValue = Objects.requireNonNull(value, "anchor");
    return validate(new ImmutableMetricDescriptor(newValue, this.project, this.module, this.id, this.description));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MetricDescriptor#project() project} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for project
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMetricDescriptor withProject(String value) {
    String newValue = Objects.requireNonNull(value, "project");
    if (this.project.equals(newValue)) return this;
    return validate(new ImmutableMetricDescriptor(this.anchor, newValue, this.module, this.id, this.description));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MetricDescriptor#module() module} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for module
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMetricDescriptor withModule(String value) {
    String newValue = Objects.requireNonNull(value, "module");
    if (this.module.equals(newValue)) return this;
    return validate(new ImmutableMetricDescriptor(this.anchor, this.project, newValue, this.id, this.description));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MetricDescriptor#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMetricDescriptor withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return validate(new ImmutableMetricDescriptor(this.anchor, this.project, this.module, newValue, this.description));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MetricDescriptor#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMetricDescriptor withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return validate(new ImmutableMetricDescriptor(this.anchor, this.project, this.module, this.id, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMetricDescriptor} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMetricDescriptor
        && equalTo(0, (ImmutableMetricDescriptor) another);
  }

  private boolean equalTo(int synthetic, ImmutableMetricDescriptor another) {
    return anchor.equals(another.anchor)
        && project.equals(another.project)
        && module.equals(another.module)
        && id.equals(another.id)
        && description.equals(another.description);
  }

  /**
   * Computes a hash code from attributes: {@code anchor}, {@code project}, {@code module}, {@code id}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + anchor.hashCode();
    h += (h << 5) + project.hashCode();
    h += (h << 5) + module.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + description.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MetricDescriptor} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MetricDescriptor")
        .omitNullValues()
        .add("anchor", anchor)
        .add("project", project)
        .add("module", module)
        .add("id", id)
        .add("description", description)
        .toString();
  }

  private static ImmutableMetricDescriptor validate(ImmutableMetricDescriptor instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link MetricDescriptor} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MetricDescriptor instance
   */
  public static ImmutableMetricDescriptor copyOf(MetricDescriptor instance) {
    if (instance instanceof ImmutableMetricDescriptor) {
      return (ImmutableMetricDescriptor) instance;
    }
    return ((ImmutableMetricDescriptor.Builder) ImmutableMetricDescriptor.builder())
        .anchor(instance.anchor())
        .project(instance.project())
        .module(instance.module())
        .id(instance.id())
        .description(instance.description())
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMetricDescriptor ImmutableMetricDescriptor}.
   * <pre>
   * ImmutableMetricDescriptor.builder()
   *    .anchor(Object) // required {@link MetricDescriptor#anchor() anchor}
   *    .project(String) // required {@link MetricDescriptor#project() project}
   *    .module(String) // required {@link MetricDescriptor#module() module}
   *    .id(String) // required {@link MetricDescriptor#id() id}
   *    .description(String) // optional {@link MetricDescriptor#description() description}
   *    .build();
   * </pre>
   * @return A new ImmutableMetricDescriptor builder
   */
  public static AnchorBuildStage builder() {
    return new ImmutableMetricDescriptor.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMetricDescriptor ImmutableMetricDescriptor}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MetricDescriptor", generator = "Immutables")
  public static final class Builder
      implements AnchorBuildStage, ProjectBuildStage, ModuleBuildStage, IdBuildStage, BuildFinal {
    private static final long INIT_BIT_ANCHOR = 0x1L;
    private static final long INIT_BIT_PROJECT = 0x2L;
    private static final long INIT_BIT_MODULE = 0x4L;
    private static final long INIT_BIT_ID = 0x8L;
    private static final long OPT_BIT_DESCRIPTION = 0x1L;
    private long initBits = 0xfL;
    private long optBits;

    private Object anchor;
    private String project;
    private String module;
    private String id;
    private String description;

    private Builder() {
    }

    /**
     * Initializes the value for the {@link MetricDescriptor#anchor() anchor} attribute.
     * @param anchor The value for anchor 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder anchor(Object anchor) {
      checkNotIsSet(anchorIsSet(), "anchor");
      this.anchor = Objects.requireNonNull(anchor, "anchor");
      initBits &= ~INIT_BIT_ANCHOR;
      return this;
    }

    /**
     * Initializes the value for the {@link MetricDescriptor#project() project} attribute.
     * @param project The value for project 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder project(String project) {
      checkNotIsSet(projectIsSet(), "project");
      this.project = Objects.requireNonNull(project, "project");
      initBits &= ~INIT_BIT_PROJECT;
      return this;
    }

    /**
     * Initializes the value for the {@link MetricDescriptor#module() module} attribute.
     * @param module The value for module 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder module(String module) {
      checkNotIsSet(moduleIsSet(), "module");
      this.module = Objects.requireNonNull(module, "module");
      initBits &= ~INIT_BIT_MODULE;
      return this;
    }

    /**
     * Initializes the value for the {@link MetricDescriptor#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      checkNotIsSet(idIsSet(), "id");
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link MetricDescriptor#description() description} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MetricDescriptor#description() description}.</em>
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(String description) {
      checkNotIsSet(descriptionIsSet(), "description");
      this.description = Objects.requireNonNull(description, "description");
      optBits |= OPT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMetricDescriptor ImmutableMetricDescriptor}.
     * @return An immutable instance of MetricDescriptor
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMetricDescriptor build() {
      checkRequiredAttributes();
      return ImmutableMetricDescriptor.validate(new ImmutableMetricDescriptor(this));
    }

    private boolean descriptionIsSet() {
      return (optBits & OPT_BIT_DESCRIPTION) != 0;
    }

    private boolean anchorIsSet() {
      return (initBits & INIT_BIT_ANCHOR) == 0;
    }

    private boolean projectIsSet() {
      return (initBits & INIT_BIT_PROJECT) == 0;
    }

    private boolean moduleIsSet() {
      return (initBits & INIT_BIT_MODULE) == 0;
    }

    private boolean idIsSet() {
      return (initBits & INIT_BIT_ID) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of MetricDescriptor is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!anchorIsSet()) attributes.add("anchor");
      if (!projectIsSet()) attributes.add("project");
      if (!moduleIsSet()) attributes.add("module");
      if (!idIsSet()) attributes.add("id");
      return "Cannot build MetricDescriptor, some of required attributes are not set " + attributes;
    }
  }

  @Generated(from = "MetricDescriptor", generator = "Immutables")
  public interface AnchorBuildStage {
    /**
     * Initializes the value for the {@link MetricDescriptor#anchor() anchor} attribute.
     * @param anchor The value for anchor 
     * @return {@code this} builder for use in a chained invocation
     */
    ProjectBuildStage anchor(Object anchor);
  }

  @Generated(from = "MetricDescriptor", generator = "Immutables")
  public interface ProjectBuildStage {
    /**
     * Initializes the value for the {@link MetricDescriptor#project() project} attribute.
     * @param project The value for project 
     * @return {@code this} builder for use in a chained invocation
     */
    ModuleBuildStage project(String project);
  }

  @Generated(from = "MetricDescriptor", generator = "Immutables")
  public interface ModuleBuildStage {
    /**
     * Initializes the value for the {@link MetricDescriptor#module() module} attribute.
     * @param module The value for module 
     * @return {@code this} builder for use in a chained invocation
     */
    IdBuildStage module(String module);
  }

  @Generated(from = "MetricDescriptor", generator = "Immutables")
  public interface IdBuildStage {
    /**
     * Initializes the value for the {@link MetricDescriptor#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    BuildFinal id(String id);
  }

  @Generated(from = "MetricDescriptor", generator = "Immutables")
  public interface BuildFinal {

    /**
     * Initializes the value for the {@link MetricDescriptor#description() description} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MetricDescriptor#description() description}.</em>
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    BuildFinal description(String description);

    /**
     * Builds a new {@link ImmutableMetricDescriptor ImmutableMetricDescriptor}.
     * @return An immutable instance of MetricDescriptor
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    ImmutableMetricDescriptor build();
  }
}
