/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.serviceutils.metrics;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.opendaylight.serviceutils.metrics.MetricDescriptor;

@Generated(from="MetricDescriptor", generator="Immutables")
public final class ImmutableMetricDescriptor
extends MetricDescriptor {
    private final Object anchor;
    private final String project;
    private final String module;
    private final String id;
    private final String description;

    private ImmutableMetricDescriptor(Builder builder) {
        this.anchor = builder.anchor;
        this.project = builder.project;
        this.module = builder.module;
        this.id = builder.id;
        this.description = builder.descriptionIsSet() ? builder.description : Objects.requireNonNull(super.description(), "description");
    }

    private ImmutableMetricDescriptor(Object anchor, String project, String module, String id, String description) {
        this.anchor = anchor;
        this.project = project;
        this.module = module;
        this.id = id;
        this.description = description;
    }

    @Override
    public Object anchor() {
        return this.anchor;
    }

    @Override
    public String project() {
        return this.project;
    }

    @Override
    public String module() {
        return this.module;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String description() {
        return this.description;
    }

    public final ImmutableMetricDescriptor withAnchor(Object value) {
        if (this.anchor == value) {
            return this;
        }
        Object newValue = Objects.requireNonNull(value, "anchor");
        return ImmutableMetricDescriptor.validate(new ImmutableMetricDescriptor(newValue, this.project, this.module, this.id, this.description));
    }

    public final ImmutableMetricDescriptor withProject(String value) {
        String newValue = Objects.requireNonNull(value, "project");
        if (this.project.equals(newValue)) {
            return this;
        }
        return ImmutableMetricDescriptor.validate(new ImmutableMetricDescriptor(this.anchor, newValue, this.module, this.id, this.description));
    }

    public final ImmutableMetricDescriptor withModule(String value) {
        String newValue = Objects.requireNonNull(value, "module");
        if (this.module.equals(newValue)) {
            return this;
        }
        return ImmutableMetricDescriptor.validate(new ImmutableMetricDescriptor(this.anchor, this.project, newValue, this.id, this.description));
    }

    public final ImmutableMetricDescriptor withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return ImmutableMetricDescriptor.validate(new ImmutableMetricDescriptor(this.anchor, this.project, this.module, newValue, this.description));
    }

    public final ImmutableMetricDescriptor withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return ImmutableMetricDescriptor.validate(new ImmutableMetricDescriptor(this.anchor, this.project, this.module, this.id, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMetricDescriptor && this.equalTo(0, (ImmutableMetricDescriptor)another);
    }

    private boolean equalTo(int synthetic, ImmutableMetricDescriptor another) {
        return this.anchor.equals(another.anchor) && this.project.equals(another.project) && this.module.equals(another.module) && this.id.equals(another.id) && this.description.equals(another.description);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.anchor.hashCode();
        h += (h << 5) + this.project.hashCode();
        h += (h << 5) + this.module.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.description.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MetricDescriptor").omitNullValues().add("anchor", this.anchor).add("project", (Object)this.project).add("module", (Object)this.module).add("id", (Object)this.id).add("description", (Object)this.description).toString();
    }

    private static ImmutableMetricDescriptor validate(ImmutableMetricDescriptor instance) {
        instance.check();
        return instance;
    }

    public static ImmutableMetricDescriptor copyOf(MetricDescriptor instance) {
        if (instance instanceof ImmutableMetricDescriptor) {
            return (ImmutableMetricDescriptor)instance;
        }
        return ((Builder)ImmutableMetricDescriptor.builder()).anchor(instance.anchor()).project(instance.project()).module(instance.module()).id(instance.id()).description(instance.description()).build();
    }

    public static AnchorBuildStage builder() {
        return new Builder();
    }

    @Generated(from="MetricDescriptor", generator="Immutables")
    public static final class Builder
    implements AnchorBuildStage,
    ProjectBuildStage,
    ModuleBuildStage,
    IdBuildStage,
    BuildFinal {
        private static final long INIT_BIT_ANCHOR = 1L;
        private static final long INIT_BIT_PROJECT = 2L;
        private static final long INIT_BIT_MODULE = 4L;
        private static final long INIT_BIT_ID = 8L;
        private static final long OPT_BIT_DESCRIPTION = 1L;
        private long initBits = 15L;
        private long optBits;
        private Object anchor;
        private String project;
        private String module;
        private String id;
        private String description;

        private Builder() {
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder anchor(Object anchor) {
            Builder.checkNotIsSet(this.anchorIsSet(), "anchor");
            this.anchor = Objects.requireNonNull(anchor, "anchor");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder project(String project) {
            Builder.checkNotIsSet(this.projectIsSet(), "project");
            this.project = Objects.requireNonNull(project, "project");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder module(String module) {
            Builder.checkNotIsSet(this.moduleIsSet(), "module");
            this.module = Objects.requireNonNull(module, "module");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            Builder.checkNotIsSet(this.idIsSet(), "id");
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder description(String description) {
            Builder.checkNotIsSet(this.descriptionIsSet(), "description");
            this.description = Objects.requireNonNull(description, "description");
            this.optBits |= 1L;
            return this;
        }

        @Override
        public ImmutableMetricDescriptor build() {
            this.checkRequiredAttributes();
            return ImmutableMetricDescriptor.validate(new ImmutableMetricDescriptor(this));
        }

        private boolean descriptionIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean anchorIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean projectIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean moduleIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean idIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of MetricDescriptor is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.anchorIsSet()) {
                attributes.add("anchor");
            }
            if (!this.projectIsSet()) {
                attributes.add("project");
            }
            if (!this.moduleIsSet()) {
                attributes.add("module");
            }
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            return "Cannot build MetricDescriptor, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="MetricDescriptor", generator="Immutables")
    public static interface AnchorBuildStage {
        public ProjectBuildStage anchor(Object var1);
    }

    @Generated(from="MetricDescriptor", generator="Immutables")
    public static interface BuildFinal {
        public BuildFinal description(String var1);

        public ImmutableMetricDescriptor build();
    }

    @Generated(from="MetricDescriptor", generator="Immutables")
    public static interface IdBuildStage {
        public BuildFinal id(String var1);
    }

    @Generated(from="MetricDescriptor", generator="Immutables")
    public static interface ModuleBuildStage {
        public IdBuildStage module(String var1);
    }

    @Generated(from="MetricDescriptor", generator="Immutables")
    public static interface ProjectBuildStage {
        public ModuleBuildStage project(String var1);
    }
}

