/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.serviceutils.upgrade.impl;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.serviceutils.upgrade.UpgradeState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.upgrade.rev180702.UpgradeConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.upgrade.rev180702.UpgradeConfigBuilder;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(service={UpgradeState.class}, immediate=true)
public final class UpgradeStateListener
implements UpgradeState,
DataListener<UpgradeConfig>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeStateListener.class);
    private final AtomicBoolean isUpgradeInProgress = new AtomicBoolean(false);
    private final DataBroker dataBroker;
    private final Registration registration;

    @Inject
    @Activate
    public UpgradeStateListener(@Reference DataBroker dataBroker) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
        this.registration = dataBroker.registerDataListener(DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, (InstanceIdentifier)InstanceIdentifier.create(UpgradeConfig.class)), (DataListener)this);
    }

    @Override
    @PreDestroy
    @Deactivate
    public void close() {
        this.registration.close();
    }

    @Override
    public boolean isUpgradeInProgress() {
        return this.isUpgradeInProgress.get();
    }

    public void dataChangedTo(UpgradeConfig data) {
        boolean upgradeConfig = data != null && data.requireUpgradeInProgress() != false;
        this.isUpgradeInProgress.set(upgradeConfig);
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        tx.put(LogicalDatastoreType.OPERATIONAL, InstanceIdentifier.create(UpgradeConfig.class), (DataObject)new UpgradeConfigBuilder().setUpgradeInProgress(upgradeConfig).build());
        try {
            tx.commit().get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Failed to write mdsal config", (Throwable)e);
        }
    }
}

