/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.upgrade.rev180702;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.serviceutils.upgrade.rev180702.UpgradeConfig;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class UpgradeConfigBuilder {
    private Boolean _upgradeInProgress;
    Map<Class<? extends Augmentation<UpgradeConfig>>, Augmentation<UpgradeConfig>> augmentation = Map.of();

    public UpgradeConfigBuilder() {
    }

    public UpgradeConfigBuilder(UpgradeConfig base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpgradeConfig>>, Augmentation<UpgradeConfig>>(aug);
        }
        this._upgradeInProgress = base.getUpgradeInProgress();
    }

    public static @NonNull UpgradeConfig empty() {
        return LazyEmpty.INSTANCE;
    }

    public Boolean getUpgradeInProgress() {
        return this._upgradeInProgress;
    }

    public <E$$ extends Augmentation<UpgradeConfig>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public UpgradeConfigBuilder setUpgradeInProgress(Boolean value) {
        this._upgradeInProgress = value;
        return this;
    }

    public UpgradeConfigBuilder addAugmentation(Augmentation<UpgradeConfig> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UpgradeConfig>>, Augmentation<UpgradeConfig>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public UpgradeConfigBuilder removeAugmentation(Class<? extends Augmentation<UpgradeConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull UpgradeConfig build() {
        return new UpgradeConfigImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull UpgradeConfig INSTANCE = new UpgradeConfigBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class UpgradeConfigImpl
    extends AbstractAugmentable<UpgradeConfig>
    implements UpgradeConfig {
        private final Boolean _upgradeInProgress;
        private int hash = 0;
        private volatile boolean hashValid = false;

        UpgradeConfigImpl(UpgradeConfigBuilder base) {
            super(base.augmentation);
            this._upgradeInProgress = base.getUpgradeInProgress();
        }

        @Override
        public Boolean getUpgradeInProgress() {
            return this._upgradeInProgress;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = UpgradeConfig.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return UpgradeConfig.bindingEquals(this, obj);
        }

        public String toString() {
            return UpgradeConfig.bindingToString(this);
        }
    }
}

