/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.api;

import com.google.common.annotations.Beta;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.data.codec.api.MissingSchemaException;

@Beta
public final class MissingSchemaForClassException
extends MissingSchemaException {
    private static final long serialVersionUID = 1L;
    private transient Class<?> bindingClass;

    public MissingSchemaForClassException(Class<?> clz) {
        super(String.format("Schema is not available for %s", clz));
        this.bindingClass = Objects.requireNonNull(clz);
    }

    public @Nullable Class<?> getBindingClass() {
        return this.bindingClass;
    }

    private Object readResolve() {
        this.bindingClass = null;
        return this;
    }
}

