/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.WildcardType;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.Action;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.BaseIdentity;
import org.opendaylight.yangtools.binding.BaseNotification;
import org.opendaylight.yangtools.binding.BindingInstanceIdentifier;
import org.opendaylight.yangtools.binding.ChoiceIn;
import org.opendaylight.yangtools.binding.DataContainer;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.binding.DataObjectStep;
import org.opendaylight.yangtools.binding.EntryObject;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.KeyedListAction;
import org.opendaylight.yangtools.binding.Notification;
import org.opendaylight.yangtools.binding.OpaqueObject;
import org.opendaylight.yangtools.binding.RpcInput;
import org.opendaylight.yangtools.binding.RpcOutput;
import org.opendaylight.yangtools.binding.YangData;
import org.opendaylight.yangtools.binding.contract.BuiltInType;
import org.opendaylight.yangtools.binding.data.codec.api.BindingAugmentationCodecTreeNode;
import org.opendaylight.yangtools.binding.data.codec.api.BindingCodecTree;
import org.opendaylight.yangtools.binding.data.codec.api.BindingCodecTreeNode;
import org.opendaylight.yangtools.binding.data.codec.api.BindingDataContainerCodecTreeNode;
import org.opendaylight.yangtools.binding.data.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.yangtools.binding.data.codec.api.BindingInstanceIdentifierCodec;
import org.opendaylight.yangtools.binding.data.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.binding.data.codec.api.BindingNormalizedNodeWriterFactory;
import org.opendaylight.yangtools.binding.data.codec.api.BindingStreamEventWriter;
import org.opendaylight.yangtools.binding.data.codec.api.BindingYangDataCodecTreeNode;
import org.opendaylight.yangtools.binding.data.codec.api.CommonDataObjectCodecTreeNode;
import org.opendaylight.yangtools.binding.data.codec.api.IncorrectNestingException;
import org.opendaylight.yangtools.binding.data.codec.api.MissingSchemaException;
import org.opendaylight.yangtools.binding.data.codec.dynamic.DynamicBindingDataCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.ActionCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.AnydataCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.AnyxmlCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.AugmentationCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.BindingToNormalizedStreamWriter;
import org.opendaylight.yangtools.binding.data.codec.impl.BuiltInValueCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.CaseCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.ChoiceCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContextFactory;
import org.opendaylight.yangtools.binding.data.codec.impl.CommonDataObjectCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.CompositeValueCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.ContainerLikeCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.DataContainerCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.DataContainerSerializer;
import org.opendaylight.yangtools.binding.data.codec.impl.DataContainerSerializerRegistry;
import org.opendaylight.yangtools.binding.data.codec.impl.DataContainerStreamer;
import org.opendaylight.yangtools.binding.data.codec.impl.DataContainerStreamerGenerator;
import org.opendaylight.yangtools.binding.data.codec.impl.IdentifiableItemCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.IdentityCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.InstanceIdentifierCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.LeafNodeCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.LeafSetNodeCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.ListCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.MapCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.NotificationCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.SchemaUnawareCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.StructuralContainerCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.UnionTypeCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.ValueCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.ValueContext;
import org.opendaylight.yangtools.binding.data.codec.impl.ValueNodeCodecContext;
import org.opendaylight.yangtools.binding.data.codec.spi.AbstractBindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.binding.data.codec.spi.BindingDOMCodecServices;
import org.opendaylight.yangtools.binding.data.codec.spi.BindingSchemaMapping;
import org.opendaylight.yangtools.binding.loader.BindingClassLoader;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.reflect.BindingReflections;
import org.opendaylight.yangtools.binding.runtime.api.ActionRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.yangtools.binding.runtime.api.BindingRuntimeTypes;
import org.opendaylight.yangtools.binding.runtime.api.ChoiceRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.ContainerLikeRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.ContainerRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.DataRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.GeneratedRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.InputRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.ListRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.ModuleRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.NotificationRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.OutputRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangDataName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.ValueNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizationResultHolder;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PresenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeDefinitionAware;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BindingCodecContext
extends AbstractBindingNormalizedNodeSerializer
implements DynamicBindingDataCodec,
CodecContextFactory,
DataContainerSerializerRegistry,
Immutable,
BindingDOMCodecServices {
    private static final Logger LOG = LoggerFactory.getLogger(BindingCodecContext.class);
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier FAKE_NODEID = new YangInstanceIdentifier.NodeIdentifier(QName.create((String)"fake", (String)"fake"));
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BindingClassLoader.Builder BCL_BUILDER;
    @VisibleForTesting
    static final @NonNull SchemaUnawareCodec NOOP_CODEC;
    private final LoadingCache<Class<?>, DataContainerStreamer<?>> streamers = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, DataContainerStreamer<?>>(){

        public DataContainerStreamer<?> load(Class<?> key) throws ReflectiveOperationException {
            Class<DataContainerStreamer<?>> streamer = DataContainerStreamerGenerator.generateStreamer(BindingCodecContext.this.loader, BindingCodecContext.this, key);
            Field instance = streamer.getDeclaredField("INSTANCE");
            return (DataContainerStreamer)instance.get(null);
        }
    });
    private final LoadingCache<Class<?>, DataContainerSerializer> serializers = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, DataContainerSerializer>(){

        public DataContainerSerializer load(Class<?> key) throws ExecutionException {
            return new DataContainerSerializer(BindingCodecContext.this, (DataContainerStreamer)BindingCodecContext.this.streamers.get(key));
        }
    });
    private final LoadingCache<Class<? extends DataObject>, DataContainerCodecContext<?, ?, ?>> childrenByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<? extends DataObject>, DataContainerCodecContext<?, ?, ?>>(){

        public DataContainerCodecContext<?, ?, ?> load(Class<? extends DataObject> key) {
            GeneratedRuntimeType childSchema = BindingCodecContext.this.context.getTypes().bindingChild(JavaTypeName.create(key));
            if (childSchema instanceof ContainerLikeRuntimeType) {
                ContainerRuntimeType container;
                ContainerLikeRuntimeType containerLike = (ContainerLikeRuntimeType)childSchema;
                if (childSchema instanceof ContainerRuntimeType && ((ContainerEffectiveStatement)(container = (ContainerRuntimeType)childSchema).statement()).findFirstEffectiveSubstatement(PresenceEffectiveStatement.class).isEmpty()) {
                    return new StructuralContainerCodecContext<DataObject>(key, container, (CodecContextFactory)BindingCodecContext.this);
                }
                return new ContainerLikeCodecContext<DataObject>(key, containerLike, BindingCodecContext.this);
            }
            if (childSchema instanceof ListRuntimeType) {
                ListRuntimeType list = (ListRuntimeType)childSchema;
                return list.keyType() == null ? new MapCodecContext(key, list, BindingCodecContext.this) : MapCodecContext.of(key, list, BindingCodecContext.this);
            }
            if (childSchema instanceof ChoiceRuntimeType) {
                ChoiceRuntimeType choice = (ChoiceRuntimeType)childSchema;
                return new ChoiceCodecContext<ChoiceIn>(key.asSubclass(ChoiceIn.class), choice, BindingCodecContext.this);
            }
            if (childSchema == null) {
                throw DataContainerCodecContext.childNullException(BindingCodecContext.this.context, key, "%s is not top-level item.", key);
            }
            throw new IncorrectNestingException("%s is not a valid data tree child of %s", new Object[]{key, this});
        }
    });
    private final LoadingCache<@NonNull QName, CodecContext> childrenByDomArg = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<QName, CodecContext>(){

        public CodecContext load(QName qname) throws ClassNotFoundException {
            BindingRuntimeTypes type = BindingCodecContext.this.context.getTypes();
            RuntimeType child = type.schemaTreeChild(qname);
            if (child == null) {
                QNameModule module = qname.getModule();
                if (type.findModule(module).isEmpty()) {
                    throw new MissingSchemaException("Module " + String.valueOf(module) + " is not present in current schema context.");
                }
                throw new IncorrectNestingException("Argument %s is not valid child of %s", new Object[]{qname, type});
            }
            if (!(child instanceof DataRuntimeType)) {
                throw new IncorrectNestingException("Argument %s is not valid data tree child of %s", new Object[]{qname, type});
            }
            EffectiveStatement childSchema = child.statement();
            if (childSchema instanceof DataNodeContainer || childSchema instanceof ChoiceSchemaNode) {
                return BindingCodecContext.this.getStreamChild(BindingCodecContext.this.context.loadClass(child.javaType()));
            }
            if (childSchema instanceof AnydataSchemaNode || childSchema instanceof AnyxmlSchemaNode || childSchema instanceof LeafSchemaNode || childSchema instanceof LeafListSchemaNode) {
                ModuleRuntimeType module = (ModuleRuntimeType)type.findModule(qname.getModule()).orElseThrow();
                ImmutableMap<Method, ValueNodeCodecContext> moduleChildren = BindingCodecContext.this.getLeafNodes(BindingCodecContext.this.context.loadClass((Type)module.javaType()), (EffectiveStatement<?, ?>)module.statement());
                for (ValueNodeCodecContext moduleChild : moduleChildren.values()) {
                    if (!qname.equals((Object)moduleChild.getDomPathArgument().getNodeType())) continue;
                    return moduleChild;
                }
                throw new IllegalArgumentException("Failed to resolve " + String.valueOf(child) + " in " + String.valueOf(module));
            }
            throw new UnsupportedOperationException("Unsupported child type " + String.valueOf(childSchema.getClass()));
        }
    });
    private final LoadingCache<Class<? extends DataObject>, ChoiceCodecContext<?>> choicesByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<? extends DataObject>, ChoiceCodecContext<?>>(){

        public ChoiceCodecContext<?> load(Class<? extends DataObject> caseType) {
            Class<?> choiceClass = 6.findCaseChoice(caseType);
            if (choiceClass == null) {
                throw new IllegalArgumentException(String.valueOf(caseType) + " is not a valid case representation");
            }
            CompositeRuntimeType compositeRuntimeType = BindingCodecContext.this.context.getSchemaDefinition(choiceClass);
            if (compositeRuntimeType instanceof ChoiceRuntimeType) {
                ChoiceRuntimeType choiceType = (ChoiceRuntimeType)compositeRuntimeType;
                return new ChoiceCodecContext(choiceClass, choiceType, BindingCodecContext.this);
            }
            throw new IllegalArgumentException(String.valueOf(caseType) + " does not refer to a choice");
        }

        private static Class<?> findCaseChoice(Class<? extends DataObject> caseClass) {
            for (java.lang.reflect.Type type : caseClass.getGenericInterfaces()) {
                Class typeClass;
                if (!(type instanceof Class) || !ChoiceIn.class.isAssignableFrom(typeClass = (Class)type)) continue;
                return typeClass.asSubclass(ChoiceIn.class);
            }
            return null;
        }
    });
    private final LoadingCache<Class<? extends Action<?, ?, ?>>, ActionCodecContext> actionsByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<? extends Action<?, ?, ?>>, ActionCodecContext>(){

        public ActionCodecContext load(Class<? extends Action<?, ?, ?>> action) {
            if (KeyedListAction.class.isAssignableFrom(action)) {
                return this.prepareActionContext(2, 3, 4, action, KeyedListAction.class);
            }
            if (Action.class.isAssignableFrom(action)) {
                return this.prepareActionContext(1, 2, 3, action, Action.class);
            }
            throw new IllegalArgumentException("The specific action type does not exist for action " + action.getName());
        }

        private ActionCodecContext prepareActionContext(int inputOffset, int outputOffset, int expectedArgsLength, Class<? extends Action<?, ?, ?>> action, Class<?> actionType) {
            java.lang.reflect.Type[] args = ((ParameterizedType)ClassLoaderUtils.findParameterizedType(action, actionType).orElseThrow(() -> new IllegalStateException(String.valueOf(action) + " does not specialize " + String.valueOf(actionType)))).getActualTypeArguments();
            Preconditions.checkArgument((args.length == expectedArgsLength ? 1 : 0) != 0, (String)"Unexpected (%s) Action generatic arguments", (int)args.length);
            ActionRuntimeType schema = BindingCodecContext.this.context.getActionDefinition(action);
            return new ActionCodecContext(new ContainerLikeCodecContext<RpcInput>(7.asClass(args[inputOffset], RpcInput.class), (ContainerLikeRuntimeType<?, ?>)schema.input(), BindingCodecContext.this), new ContainerLikeCodecContext<RpcOutput>(7.asClass(args[outputOffset], RpcOutput.class), (ContainerLikeRuntimeType<?, ?>)schema.output(), BindingCodecContext.this));
        }

        private static <T extends DataObject> Class<? extends T> asClass(java.lang.reflect.Type type, Class<T> target) {
            Verify.verify((boolean)(type instanceof Class), (String)"Type %s is not a class", (Object)type);
            return ((Class)type).asSubclass(target);
        }
    });
    private final LoadingCache<Class<?>, NotificationCodecContext<?>> notificationsByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, NotificationCodecContext<?>>(){

        public NotificationCodecContext<?> load(Class<?> key) {
            GeneratedRuntimeType runtimeType = BindingCodecContext.this.context.getTypes().bindingChild(JavaTypeName.create(key));
            if (runtimeType instanceof NotificationRuntimeType) {
                NotificationRuntimeType notification = (NotificationRuntimeType)runtimeType;
                return new NotificationCodecContext(key, notification, BindingCodecContext.this);
            }
            if (runtimeType != null) {
                throw new IllegalArgumentException(String.valueOf(key) + " maps to unexpected " + String.valueOf(runtimeType));
            }
            throw new IllegalArgumentException(String.valueOf(key) + " is not a known class");
        }
    });
    private final LoadingCache<SchemaNodeIdentifier.Absolute, NotificationCodecContext<?>> notificationsByPath = CacheBuilder.newBuilder().build(new CacheLoader<SchemaNodeIdentifier.Absolute, NotificationCodecContext<?>>(){

        public NotificationCodecContext<?> load(SchemaNodeIdentifier.Absolute key) {
            Class cls = BindingCodecContext.this.context.getClassForSchema(key);
            try {
                return BindingCodecContext.this.getNotificationContext(cls.asSubclass(Notification.class));
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Path " + String.valueOf(key) + " does not represent a notification", e);
            }
        }
    });
    private final LoadingCache<Class<?>, ContainerLikeCodecContext<?>> rpcDataByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, ContainerLikeCodecContext<?>>(){

        public ContainerLikeCodecContext<?> load(Class<?> key) {
            RuntimeType runtimeType = (RuntimeType)BindingCodecContext.this.context.getTypes().findSchema(JavaTypeName.create(key)).orElseThrow(() -> new IllegalArgumentException(String.valueOf(key) + " is not a known class"));
            if (RpcInput.class.isAssignableFrom(key) && runtimeType instanceof InputRuntimeType) {
                InputRuntimeType input = (InputRuntimeType)runtimeType;
                return new ContainerLikeCodecContext(key, (ContainerLikeRuntimeType<?, ?>)input, BindingCodecContext.this);
            }
            if (RpcOutput.class.isAssignableFrom(key) && runtimeType instanceof OutputRuntimeType) {
                OutputRuntimeType output = (OutputRuntimeType)runtimeType;
                return new ContainerLikeCodecContext(key, (ContainerLikeRuntimeType<?, ?>)output, BindingCodecContext.this);
            }
            throw new IllegalArgumentException(String.valueOf(key) + " maps to unexpected " + String.valueOf(runtimeType));
        }
    });
    private final LoadingCache<SchemaNodeIdentifier.Absolute, ContainerLikeCodecContext<?>> rpcDataByPath = CacheBuilder.newBuilder().build(new CacheLoader<SchemaNodeIdentifier.Absolute, ContainerLikeCodecContext<?>>(){

        public ContainerLikeCodecContext<?> load(SchemaNodeIdentifier.Absolute key) {
            QName rpcName = key.firstNodeIdentifier();
            Class container = switch (key.lastNodeIdentifier().getLocalName()) {
                case "input" -> BindingCodecContext.this.context.getRpcInput(rpcName);
                case "output" -> BindingCodecContext.this.context.getRpcOutput(rpcName);
                default -> throw new IllegalArgumentException("Unhandled path " + String.valueOf(key));
            };
            return BindingCodecContext.this.getRpc(container);
        }
    });
    private final @NonNull BindingClassLoader loader = BCL_BUILDER.build();
    private final @NonNull InstanceIdentifierCodec instanceIdentifierCodec;
    private final @NonNull IdentityCodec identityCodec;
    private final @NonNull BindingRuntimeContext context;

    public BindingCodecContext() {
        this(ServiceLoader.load(BindingRuntimeContext.class).findFirst().orElseThrow(() -> new IllegalStateException("Failed to load BindingRuntimeContext")));
    }

    public BindingCodecContext(BindingRuntimeContext context) {
        this.context = Objects.requireNonNull(context, "Binding Runtime Context is required.");
        this.identityCodec = new IdentityCodec(context);
        this.instanceIdentifierCodec = new InstanceIdentifierCodec(this);
    }

    @Deprecated(since="14.0.2", forRemoval=true)
    public BindingRuntimeContext getRuntimeContext() {
        return this.context;
    }

    @Override
    public BindingRuntimeContext runtimeContext() {
        return this.context;
    }

    public BindingNormalizedNodeSerializer nodeSerializer() {
        return this;
    }

    public BindingCodecTree tree() {
        return this;
    }

    public BindingNormalizedNodeWriterFactory writerFactory() {
        return this;
    }

    @Override
    public BindingClassLoader getLoader() {
        return this.loader;
    }

    public IdentityCodec getIdentityCodec() {
        return this.identityCodec;
    }

    public BindingInstanceIdentifierCodec getInstanceIdentifierCodec() {
        return this.instanceIdentifierCodec;
    }

    public <T extends YangData<T>> BindingYangDataCodecTreeNode<T> getYangDataCodec(Class<T> yangDataClass) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public BindingYangDataCodecTreeNode<?> getYangDataCodec(YangDataName yangDataName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public DataContainerSerializer getEventStreamSerializer(Class<?> type) {
        return (DataContainerSerializer)this.serializers.getUnchecked(type);
    }

    @Override
    public DataContainerStreamer<?> getDataContainerStreamer(Class<?> type) {
        return (DataContainerStreamer)this.streamers.getUnchecked(type);
    }

    @Override
    public DataContainerSerializer getSerializer(Class<? extends DataContainer> type) {
        return (DataContainerSerializer)this.serializers.getUnchecked(type);
    }

    public Map.Entry<YangInstanceIdentifier, BindingStreamEventWriter> newWriterAndIdentifier(DataObjectReference<?> path, NormalizedNodeStreamWriter domWriter) {
        ArrayList<YangInstanceIdentifier.PathArgument> yangArgs = new ArrayList<YangInstanceIdentifier.PathArgument>();
        DataContainerCodecContext<?, ?, ?> codecContext = this.getCodecContextNode(path, yangArgs);
        return Map.entry(YangInstanceIdentifier.of(yangArgs), new BindingToNormalizedStreamWriter(codecContext, domWriter));
    }

    public BindingStreamEventWriter newWriter(DataObjectReference<?> path, NormalizedNodeStreamWriter domWriter) {
        return new BindingToNormalizedStreamWriter(this.getCodecContextNode(path, null), domWriter);
    }

    public BindingStreamEventWriter newRpcWriter(Class<? extends DataContainer> rpcInputOrOutput, NormalizedNodeStreamWriter domWriter) {
        return new BindingToNormalizedStreamWriter(this.getRpc(rpcInputOrOutput), domWriter);
    }

    public BindingStreamEventWriter newNotificationWriter(Class<? extends Notification<?>> notification, NormalizedNodeStreamWriter domWriter) {
        return new BindingToNormalizedStreamWriter(this.getNotificationContext(notification), domWriter);
    }

    public BindingStreamEventWriter newActionInputWriter(Class<? extends Action<?, ?, ?>> action, NormalizedNodeStreamWriter domWriter) {
        return new BindingToNormalizedStreamWriter(this.getActionCodec(action).input(), domWriter);
    }

    public BindingStreamEventWriter newActionOutputWriter(Class<? extends Action<?, ?, ?>> action, NormalizedNodeStreamWriter domWriter) {
        return new BindingToNormalizedStreamWriter(this.getActionCodec(action).output(), domWriter);
    }

    @NonNull DataContainerCodecContext<?, ?, ?> getCodecContextNode(DataObjectReference<?> binding, List<YangInstanceIdentifier.PathArgument> builder) {
        BindingDataContainerCodecTreeNode start;
        Iterator it = binding.steps().iterator();
        DataObjectStep step = (DataObjectStep)it.next();
        Class caseType = step.caseType();
        if (caseType != null) {
            ChoiceCodecContext choice = (ChoiceCodecContext)this.choicesByClass.getUnchecked((Object)caseType);
            choice.addYangPathArgument(step, builder);
            BindingDataContainerCodecTreeNode caze = choice.getStreamChild(caseType);
            caze.addYangPathArgument(step, builder);
            start = caze.bindingPathArgumentChild(step, (List)builder);
        } else {
            BindingDataContainerCodecTreeNode child = this.getStreamChild(step.type());
            child.addYangPathArgument(step, builder);
            start = child;
        }
        BindingDataContainerCodecTreeNode current = start;
        while (it.hasNext()) {
            current = current.bindingPathArgumentChild((DataObjectStep)it.next(), (List)builder);
        }
        return current;
    }

    @Nullable BindingDataObjectCodecTreeNode<?> getCodecContextNode(@NonNull YangInstanceIdentifier dom, @Nullable List<DataObjectStep<?>> bindingArguments) {
        CodecContext codec = this.lookupCodecContext(dom, bindingArguments);
        if (!(codec instanceof BindingDataObjectCodecTreeNode)) {
            return null;
        }
        BindingDataObjectCodecTreeNode dataObjectCodec = (BindingDataObjectCodecTreeNode)codec;
        if (dataObjectCodec instanceof CaseCodecContext) {
            LOG.debug("Instance identifier targeting a case is not representable ({})", (Object)dom);
            return null;
        }
        return dataObjectCodec;
    }

    @Nullable CodecContext lookupCodecContext(@NonNull YangInstanceIdentifier path, @Nullable List<DataObjectStep<?>> bindingArguments) {
        CodecContext currentNode;
        ListCodecContext listNode;
        CodecContext nextNode;
        Iterator<YangInstanceIdentifier.PathArgument> it = path.getPathArguments().iterator();
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Path may not be empty");
        }
        YangInstanceIdentifier.PathArgument domArg = (YangInstanceIdentifier.PathArgument)it.next();
        if (!(domArg instanceof YangInstanceIdentifier.NodeIdentifier)) {
            return null;
        }
        CodecContext codecContext = nextNode = BindingCodecContext.getOrRethrow(this.childrenByDomArg, domArg.getNodeType());
        Objects.requireNonNull(codecContext);
        CodecContext codecContext2 = codecContext;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ListCodecContext.class, ChoiceCodecContext.class, CommonDataObjectCodecContext.class, ValueNodeCodecContext.class}, (Object)codecContext2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                listNode = (ListCodecContext)codecContext2;
                if (!it.hasNext()) {
                    if (bindingArguments != null) {
                        bindingArguments.add(listNode.getBindingPathArgument(null));
                    }
                    return listNode;
                }
                YangInstanceIdentifier.PathArgument nextArg = it.next();
                if (nextArg instanceof YangInstanceIdentifier.NodeWithValue || !nextArg.getNodeType().equals((Object)domArg.getNodeType())) {
                    throw new IllegalArgumentException("List should be referenced twice in " + String.valueOf(path));
                }
                if (bindingArguments != null) {
                    bindingArguments.add(listNode.getBindingPathArgument(nextArg));
                }
                currentNode = listNode;
                break;
            }
            case 1: {
                ChoiceCodecContext choiceNode;
                currentNode = choiceNode = (ChoiceCodecContext)codecContext2;
                break;
            }
            case 2: {
                CommonDataObjectCodecContext firstContainer = (CommonDataObjectCodecContext)codecContext2;
                if (bindingArguments != null) {
                    bindingArguments.add(firstContainer.getBindingPathArgument(domArg));
                }
                currentNode = firstContainer;
                break;
            }
            case 3: {
                ValueNodeCodecContext valueNode = (ValueNodeCodecContext)codecContext2;
                return BindingCodecContext.checkValueCodec(valueNode, it);
            }
        }
        CommonDataObjectCodecContext currentList = null;
        while (it.hasNext()) {
            domArg = it.next();
            if (!(currentNode instanceof DataContainerCodecContext)) {
                throw new IllegalArgumentException("Unexpected child of non-container node " + String.valueOf(currentNode));
            }
            DataContainerCodecContext previous = currentNode;
            nextNode = previous.yangPathArgumentChild(domArg);
            if (nextNode instanceof AugmentationCodecContext) {
                AugmentationCodecContext augmContext = (AugmentationCodecContext)nextNode;
                if (bindingArguments != null) {
                    bindingArguments.add(augmContext.bindingArg());
                }
                currentNode = nextNode;
                nextNode = augmContext.yangPathArgumentChild(domArg);
            }
            if (currentList != null) {
                Preconditions.checkArgument((currentList == nextNode ? 1 : 0) != 0, (String)"List should be referenced two times in %s", (Object)path);
                if (bindingArguments != null) {
                    bindingArguments.add(currentList.getBindingPathArgument(domArg));
                }
                currentList = null;
                currentNode = nextNode;
                continue;
            }
            if (nextNode instanceof ListCodecContext) {
                listNode = (ListCodecContext)nextNode;
                currentList = listNode;
                continue;
            }
            if (nextNode instanceof ChoiceCodecContext) {
                currentNode = nextNode;
                continue;
            }
            if (nextNode instanceof CommonDataObjectCodecContext) {
                CommonDataObjectCodecContext containerNode = (CommonDataObjectCodecContext)nextNode;
                if (bindingArguments != null) {
                    bindingArguments.add(containerNode.getBindingPathArgument(domArg));
                }
                currentNode = nextNode;
                continue;
            }
            if (!(nextNode instanceof ValueNodeCodecContext)) continue;
            ValueNodeCodecContext valueNode = (ValueNodeCodecContext)nextNode;
            return BindingCodecContext.checkValueCodec(valueNode, it);
        }
        if (currentList != null) {
            if (bindingArguments != null) {
                bindingArguments.add(currentList.getBindingPathArgument(null));
            }
            return currentList;
        }
        return currentNode;
    }

    private static ValueNodeCodecContext checkValueCodec(ValueNodeCodecContext codec, Iterator<YangInstanceIdentifier.PathArgument> it) {
        if (codec instanceof LeafSetNodeCodecContext) {
            YangInstanceIdentifier.PathArgument nextArg;
            LeafSetNodeCodecContext leafSet = (LeafSetNodeCodecContext)codec;
            if (it.hasNext() && !((nextArg = it.next()) instanceof YangInstanceIdentifier.NodeWithValue)) {
                throw new IllegalArgumentException(String.valueOf(nextArg) + " should be a NodeWithValue matching " + String.valueOf(leafSet));
            }
        }
        if (it.hasNext()) {
            throw new IllegalArgumentException("Attempted to step " + String.valueOf(ImmutableList.copyOf(it)) + " past " + String.valueOf(codec));
        }
        return codec;
    }

    NotificationCodecContext<?> getNotificationContext(SchemaNodeIdentifier.Absolute notification) {
        return BindingCodecContext.getOrRethrow(this.notificationsByPath, notification);
    }

    private NotificationCodecContext<?> getNotificationContext(Class<?> notification) {
        return BindingCodecContext.getOrRethrow(this.notificationsByClass, notification);
    }

    ContainerLikeCodecContext<?> getRpc(Class<? extends DataContainer> rpcInputOrOutput) {
        return BindingCodecContext.getOrRethrow(this.rpcDataByClass, rpcInputOrOutput);
    }

    ContainerLikeCodecContext<?> getRpcInputCodec(SchemaNodeIdentifier.Absolute containerPath) {
        return BindingCodecContext.getOrRethrow(this.rpcDataByPath, containerPath);
    }

    ActionCodecContext getActionCodec(Class<? extends Action<?, ?, ?>> action) {
        return BindingCodecContext.getOrRethrow(this.actionsByClass, action);
    }

    @Override
    public ImmutableMap<Method, ValueNodeCodecContext> getLeafNodes(Class<?> type, EffectiveStatement<?, ?> schema) {
        HashMap<String, DataSchemaNode> getterToLeafSchema = new HashMap<String, DataSchemaNode>();
        for (EffectiveStatement stmt : schema.effectiveSubstatements()) {
            if (stmt instanceof TypedDataSchemaNode) {
                TypedDataSchemaNode typedSchema = (TypedDataSchemaNode)stmt;
                BindingCodecContext.putLeaf(getterToLeafSchema, (DataSchemaNode)typedSchema);
                continue;
            }
            if (stmt instanceof AnydataSchemaNode) {
                AnydataSchemaNode anydataSchema = (AnydataSchemaNode)stmt;
                BindingCodecContext.putLeaf(getterToLeafSchema, (DataSchemaNode)anydataSchema);
                continue;
            }
            if (!(stmt instanceof AnyxmlSchemaNode)) continue;
            AnyxmlSchemaNode anyxmlSchema = (AnyxmlSchemaNode)stmt;
            BindingCodecContext.putLeaf(getterToLeafSchema, (DataSchemaNode)anyxmlSchema);
        }
        return this.getLeafNodesUsingReflection(type, getterToLeafSchema);
    }

    private static void putLeaf(Map<String, DataSchemaNode> map, DataSchemaNode leaf) {
        map.put(BindingSchemaMapping.getGetterMethodName((DataSchemaNode)leaf), leaf);
    }

    private ImmutableMap<Method, ValueNodeCodecContext> getLeafNodesUsingReflection(Class<?> parentClass, Map<String, DataSchemaNode> getterToLeafSchema) {
        HashMap<Method, AnyxmlCodecContext<? extends OpaqueObject>> leaves = new HashMap<Method, AnyxmlCodecContext<? extends OpaqueObject>>();
        for (Method method : parentClass.getMethods()) {
            ValueNodeCodecContext valueNode;
            if (method.getParameterCount() != 0 || method.isBridge()) continue;
            DataSchemaNode schema = getterToLeafSchema.get(method.getName());
            if (schema instanceof LeafSchemaNode) {
                LeafSchemaNode leafSchema = (LeafSchemaNode)schema;
                Class<?> valueType = method.getReturnType();
                ValueCodec<Object, Object> codec = this.getCodec(valueType, leafSchema.getType());
                valueNode = LeafNodeCodecContext.of(leafSchema, codec, method.getName(), valueType, this.context.modelContext());
            } else if (schema instanceof LeafListSchemaNode) {
                Class valueType;
                LeafListSchemaNode leafListSchema = (LeafListSchemaNode)schema;
                Optional optType = ClassLoaderUtils.getFirstGenericParameter((java.lang.reflect.Type)method.getGenericReturnType());
                Preconditions.checkState((boolean)optType.isPresent(), (String)"Failed to find return type for %s", (Object)method);
                java.lang.reflect.Type genericType = (java.lang.reflect.Type)optType.orElseThrow();
                if (genericType instanceof Class) {
                    Class clazz;
                    valueType = clazz = (Class)genericType;
                } else if (genericType instanceof ParameterizedType) {
                    ParameterizedType parameterized = (ParameterizedType)genericType;
                    valueType = (Class)parameterized.getRawType();
                } else if (genericType instanceof WildcardType) {
                    valueType = Object.class;
                } else {
                    throw new IllegalStateException("Unexpected return type " + String.valueOf(genericType));
                }
                ValueCodec<Object, Object> codec = this.getCodec(valueType, leafListSchema.getType());
                valueNode = new LeafSetNodeCodecContext(leafListSchema, codec, method.getName(), valueType);
            } else if (schema instanceof AnyxmlSchemaNode) {
                AnyxmlSchemaNode anyxmlSchema = (AnyxmlSchemaNode)schema;
                valueNode = new AnyxmlCodecContext<OpaqueObject>(anyxmlSchema, method.getName(), BindingCodecContext.opaqueReturnType(method), this.loader);
            } else if (schema instanceof AnydataSchemaNode) {
                AnydataSchemaNode anydataSchema = (AnydataSchemaNode)schema;
                valueNode = new AnydataCodecContext<OpaqueObject>(anydataSchema, method.getName(), BindingCodecContext.opaqueReturnType(method), this.loader);
            } else {
                Verify.verify((schema == null ? 1 : 0) != 0, (String)"Unhandled schema %s for method %s", (Object)schema, (Object)method);
                continue;
            }
            leaves.put(method, (AnyxmlCodecContext<? extends OpaqueObject>)valueNode);
        }
        return ImmutableMap.copyOf(leaves);
    }

    ValueCodec<Object, Object> getCodec(Class<?> valueType, TypeDefinition<?> instantiatedType) {
        if (BaseIdentity.class.isAssignableFrom(valueType)) {
            IdentityCodec casted = this.identityCodec;
            return casted;
        }
        if (BindingInstanceIdentifier.class.equals(valueType)) {
            InstanceIdentifierCodec casted = this.instanceIdentifierCodec;
            return casted;
        }
        if (BindingReflections.isBindingClass(valueType)) {
            return this.getCodecForBindingClass(valueType, instantiatedType);
        }
        BuiltInValueCodec codec = BuiltInValueCodec.forValueType(valueType);
        if (codec != null) {
            return codec;
        }
        if (Object.class.equals(valueType)) {
            return NOOP_CODEC;
        }
        throw new VerifyException("Unsupported type " + valueType.getName());
    }

    private ValueCodec<Object, Object> getCodecForBindingClass(Class<?> valueType, TypeDefinition<?> typeDef) {
        if (typeDef instanceof IdentityrefTypeDefinition) {
            return new CompositeValueCodec.OfIdentity(valueType, this.identityCodec);
        }
        if (typeDef instanceof InstanceIdentifierTypeDefinition) {
            return new CompositeValueCodec.OfInstanceIdentifier(valueType, this.instanceIdentifierCodec);
        }
        if (typeDef instanceof UnionTypeDefinition) {
            UnionTypeDefinition unionType = (UnionTypeDefinition)typeDef;
            try {
                return UnionTypeCodec.of(valueType, unionType, this);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to load codec for " + String.valueOf(valueType), e);
            }
        }
        if (typeDef instanceof LeafrefTypeDefinition) {
            EffectiveStatement schema;
            EffectiveStatement effectiveStatement = schema = this.context.getTypeWithSchema(valueType).statement();
            Objects.requireNonNull(effectiveStatement);
            EffectiveStatement effectiveStatement2 = effectiveStatement;
            int n = 0;
            return this.getCodec(valueType, switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TypeDefinitionAware.class, TypeAware.class}, (Object)effectiveStatement2, n)) {
                case 0 -> {
                    TypeDefinitionAware typeDefAware = (TypeDefinitionAware)effectiveStatement2;
                    yield typeDefAware.getTypeDefinition();
                }
                case 1 -> {
                    TypeAware typeAware = (TypeAware)effectiveStatement2;
                    yield typeAware.getType();
                }
                default -> throw new IllegalStateException("Unexpected schema " + String.valueOf(schema));
            });
        }
        SchemaUnawareCodec cached = SchemaUnawareCodec.of(valueType, typeDef);
        if (cached != null) {
            return cached;
        }
        BuiltInValueCodec codec = BuiltInValueCodec.forValueType(valueType);
        if (codec != null) {
            return codec;
        }
        throw new VerifyException("Unsupported type " + valueType.getName());
    }

    @Override
    public IdentifiableItemCodec getPathArgumentCodec(Class<?> listClz, ListRuntimeType type) {
        Class<Key> identifier = ((Class)ClassLoaderUtils.findGenericArgument(listClz, EntryObject.class, (int)1).orElseThrow(() -> new IllegalStateException("Failed to find identifier for " + String.valueOf(listClz)))).asSubclass(Key.class);
        HashMap<QName, ValueContext> valueCtx = new HashMap<QName, ValueContext>();
        for (ValueNodeCodecContext leaf : this.getLeafNodes(identifier, (EffectiveStatement<?, ?>)type.statement()).values()) {
            QName name = leaf.getDomPathArgument().getNodeType();
            valueCtx.put(name, new ValueContext(identifier, leaf));
        }
        return IdentifiableItemCodec.of(type.statement(), identifier, listClz, valueCtx);
    }

    public <E extends DataObject> DataContainerCodecContext<E, ?, ?> getStreamChild(Class<E> childClass) {
        NotificationCodecContext<?> result = Notification.class.isAssignableFrom(childClass) ? this.getNotificationContext(childClass) : BindingCodecContext.getOrRethrow(this.childrenByClass, childClass);
        return result;
    }

    public <A extends Augmentation<?>> BindingAugmentationCodecTreeNode<A> getAugmentationCodec(DataObjectReference<A> path) {
        DataContainerCodecContext<?, ?, ?> codecContext = this.getCodecContextNode(path, null);
        if (codecContext instanceof BindingAugmentationCodecTreeNode) {
            return (BindingAugmentationCodecTreeNode)codecContext;
        }
        throw new IllegalArgumentException(String.valueOf(path) + " does not refer to an Augmentation");
    }

    public <T extends DataObject> BindingDataObjectCodecTreeNode<T> getDataObjectCodec(DataObjectReference<T> path) {
        DataContainerCodecContext<?, ?, ?> codecContext = this.getCodecContextNode(path, null);
        if (codecContext instanceof BindingDataObjectCodecTreeNode) {
            return (BindingDataObjectCodecTreeNode)codecContext;
        }
        throw new IllegalArgumentException(String.valueOf(path) + " does not refer to a plain DataObject");
    }

    public <T extends DataObject> BindingCodecTree.CodecWithPath<T> getSubtreeCodecWithPath(DataObjectReference<T> path) {
        ArrayList<YangInstanceIdentifier.PathArgument> yangArgs = new ArrayList<YangInstanceIdentifier.PathArgument>();
        DataContainerCodecContext<?, ?, ?> codecContext = this.getCodecContextNode(path, yangArgs);
        return new BindingCodecTree.CodecWithPath((CommonDataObjectCodecTreeNode)codecContext, YangInstanceIdentifier.of(yangArgs));
    }

    public <T extends DataObject> CommonDataObjectCodecTreeNode<T> getSubtreeCodec(DataObjectReference<T> path) {
        return (CommonDataObjectCodecTreeNode)this.getCodecContextNode(path, null);
    }

    public BindingCodecTreeNode getSubtreeCodec(YangInstanceIdentifier path) {
        return this.lookupCodecContext(Objects.requireNonNull(path), null);
    }

    public BindingCodecTreeNode getSubtreeCodec(SchemaNodeIdentifier.Absolute path) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public YangInstanceIdentifier toYangInstanceIdentifier(DataObjectReference<?> binding) {
        return this.instanceIdentifierCodec.fromBinding(binding);
    }

    public <T extends DataObject> DataObjectReference<T> fromYangInstanceIdentifier(YangInstanceIdentifier dom) {
        return this.instanceIdentifierCodec.toBinding(dom);
    }

    public <A extends Augmentation<?>> BindingNormalizedNodeSerializer.AugmentationResult toNormalizedAugmentation(DataObjectReference<A> path, A data) {
        BindingNormalizedNodeSerializer.NormalizedResult result = this.toNormalizedNode((DataObjectReference)path, (DataObject)data);
        if (result instanceof BindingNormalizedNodeSerializer.AugmentationResult) {
            BindingNormalizedNodeSerializer.AugmentationResult augment = (BindingNormalizedNodeSerializer.AugmentationResult)result;
            return augment;
        }
        throw new IllegalArgumentException(String.valueOf(path) + " does not identify an Augmentation");
    }

    public <T extends DataObject> BindingNormalizedNodeSerializer.NodeResult toNormalizedDataObject(DataObjectReference<T> path, T data) {
        BindingNormalizedNodeSerializer.NormalizedResult result = this.toNormalizedNode(path, data);
        if (result instanceof BindingNormalizedNodeSerializer.NodeResult) {
            BindingNormalizedNodeSerializer.NodeResult node = (BindingNormalizedNodeSerializer.NodeResult)result;
            return node;
        }
        throw new IllegalArgumentException(String.valueOf(path) + " does not identify a plain DataObject");
    }

    public <T extends DataObject> BindingNormalizedNodeSerializer.NormalizedResult toNormalizedNode(DataObjectReference<T> path, T data) {
        BindingAugmentationCodecTreeNode augmentNode;
        ArrayList<YangInstanceIdentifier.PathArgument> yangArgs = new ArrayList<YangInstanceIdentifier.PathArgument>();
        DataContainerCodecContext<?, ?, ?> codecContext = this.getCodecContextNode(path, yangArgs);
        YangInstanceIdentifier yangPath = YangInstanceIdentifier.of(yangArgs);
        NormalizationResultHolder result = new NormalizationResultHolder();
        NormalizedNodeStreamWriter domWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizationResultHolder)result);
        BindingToNormalizedStreamWriter bindingWriter = new BindingToNormalizedStreamWriter(codecContext, domWriter);
        BindingAugmentationCodecTreeNode augment = codecContext instanceof BindingAugmentationCodecTreeNode ? (augmentNode = (BindingAugmentationCodecTreeNode)codecContext) : null;
        try {
            if (augment != null) {
                domWriter.startContainerNode(FAKE_NODEID, -1);
            }
            this.getSerializer(path.lastStep().type()).serialize((DataContainer)data, bindingWriter);
            if (augment != null) {
                domWriter.endNode();
            }
        }
        catch (IOException e) {
            LOG.error("Unexpected failure while serializing path {} data {}", new Object[]{path, data, e});
            throw new IllegalStateException("Failed to create normalized node", e);
        }
        if (augment != null) {
            return new BindingNormalizedNodeSerializer.AugmentationResult(yangPath, augment.childPathArguments(), ImmutableList.copyOf((Collection)((ContainerNode)result.getResult().data()).body()));
        }
        return new BindingNormalizedNodeSerializer.NodeResult(yangPath, result.getResult().data());
    }

    public Map.Entry<DataObjectReference<?>, DataObject> fromNormalizedNode(YangInstanceIdentifier path, NormalizedNode data) {
        if (BindingCodecContext.notBindingRepresentable(data)) {
            return null;
        }
        ArrayList builder = new ArrayList();
        BindingDataObjectCodecTreeNode<?> codec = this.getCodecContextNode(path, builder);
        if (codec == null) {
            if (data != null) {
                LOG.warn("Path {} does not have a binding equivalent, should have been caught earlier ({})", (Object)path, (Object)data.getClass());
            }
            return null;
        }
        DataObject lazyObj = (DataObject)codec.deserialize(data);
        return Map.entry(DataObjectReference.ofUnsafeSteps(builder), lazyObj);
    }

    public BaseNotification fromNormalizedNodeNotification(SchemaNodeIdentifier.Absolute path, ContainerNode data) {
        return (BaseNotification)this.getNotificationContext(path).deserialize((NormalizedNode)data);
    }

    public BaseNotification fromNormalizedNodeNotification(SchemaNodeIdentifier.Absolute path, ContainerNode data, Instant eventInstant) {
        return eventInstant == null ? this.fromNormalizedNodeNotification(path, data) : this.getNotificationContext(path).deserialize(data, eventInstant);
    }

    public DataObject fromNormalizedNodeRpcData(SchemaNodeIdentifier.Absolute containerPath, ContainerNode data) {
        return this.getRpcInputCodec(containerPath).deserialize((NormalizedNode)data);
    }

    public <T extends RpcInput> T fromNormalizedNodeActionInput(Class<? extends Action<?, ?, ?>> action, ContainerNode input) {
        return (T)((RpcInput)Objects.requireNonNull((DataObject)this.getActionCodec(action).input().deserialize((NormalizedNode)Objects.requireNonNull(input))));
    }

    public <T extends RpcOutput> T fromNormalizedNodeActionOutput(Class<? extends Action<?, ?, ?>> action, ContainerNode output) {
        return (T)((RpcOutput)Objects.requireNonNull((DataObject)this.getActionCodec(action).output().deserialize((NormalizedNode)Objects.requireNonNull(output))));
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public ContainerNode toNormalizedNodeNotification(Notification<?> data) {
        return this.serializeDataObject((DataObject)data, (ctx, iface, domWriter) -> ctx.newNotificationWriter(iface.asSubclass(Notification.class), domWriter));
    }

    public ContainerNode toNormalizedNodeNotification(SchemaNodeIdentifier.Absolute path, BaseNotification data) {
        Preconditions.checkArgument((boolean)(data instanceof DataObject), (String)"Unexpected data %s", (Object)data);
        NotificationCodecContext<?> notifContext = this.getNotificationContext(path);
        NormalizedNode result = notifContext.serialize((DataObject)data);
        Verify.verify((boolean)(result instanceof ContainerNode), (String)"Unexpected result %s from %s", (Object)result, (Object)data);
        return (ContainerNode)result;
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public ContainerNode toNormalizedNodeRpcData(DataContainer data) {
        return this.serializeDataObject((DataObject)data, BindingNormalizedNodeWriterFactory::newRpcWriter);
    }

    public ContainerNode toNormalizedNodeActionInput(Class<? extends Action<?, ?, ?>> action, RpcInput input) {
        return this.serializeDataObject((DataObject)input, (ctx, iface, domWriter) -> ctx.newActionInputWriter(action, domWriter));
    }

    public ContainerNode toNormalizedNodeActionOutput(Class<? extends Action<?, ?, ?>> action, RpcOutput output) {
        return this.serializeDataObject((DataObject)output, (ctx, iface, domWriter) -> ctx.newActionOutputWriter(action, domWriter));
    }

    protected YangInstanceIdentifier.NodeIdentifier actionInputName(Class<? extends Action<?, ?, ?>> action) {
        return (YangInstanceIdentifier.NodeIdentifier)Verify.verifyNotNull((Object)this.getActionCodec(action).input().getDomPathArgument());
    }

    protected YangInstanceIdentifier.NodeIdentifier actionOutputName(Class<? extends Action<?, ?, ?>> action) {
        return (YangInstanceIdentifier.NodeIdentifier)Verify.verifyNotNull((Object)this.getActionCodec(action).output().getDomPathArgument());
    }

    private <T extends DataContainer> @NonNull ContainerNode serializeDataObject(DataObject data, WriterFactoryMethod<T> newWriter) {
        NormalizationResultHolder result = new NormalizationResultHolder();
        NormalizedNodeStreamWriter domWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizationResultHolder)result);
        Class type = data.implementedInterface();
        BindingStreamEventWriter writer = newWriter.createWriter((BindingNormalizedNodeWriterFactory)this, type, domWriter);
        try {
            this.getSerializer(type).serialize((DataContainer)data, writer);
        }
        catch (IOException e) {
            LOG.error("Unexpected failure while serializing data {}", (Object)data, (Object)e);
            throw new IllegalStateException("Failed to create normalized node", e);
        }
        return (ContainerNode)result.getResult().data();
    }

    private static boolean notBindingRepresentable(NormalizedNode data) {
        return data instanceof ValueNode || data instanceof MapNode || data instanceof UnkeyedListNode || data instanceof ChoiceNode || data instanceof LeafSetNode;
    }

    private static <K, V> V getOrRethrow(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.getUnchecked(key);
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                Throwables.throwIfUnchecked((Throwable)cause);
            }
            throw e;
        }
    }

    private static Class<? extends OpaqueObject> opaqueReturnType(Method method) {
        Class<?> valueType = method.getReturnType();
        Verify.verify((boolean)OpaqueObject.class.isAssignableFrom(valueType), (String)"Illegal value type %s", valueType);
        return valueType.asSubclass(OpaqueObject.class);
    }

    static {
        BindingClassLoader.Builder builder = BindingClassLoader.builder(BindingCodecContext.class);
        String dir = System.getProperty("org.opendaylight.mdsal.binding.dom.codec.loader.bytecodeDumpDirectory");
        if (dir != null && !dir.isEmpty()) {
            builder.dumpBytecode(Path.of(dir, new String[0]));
        }
        BCL_BUILDER = builder;
        NOOP_CODEC = new SchemaUnawareCodec(){

            @Override
            protected Object serializeImpl(Object input) {
                return BuiltInType.checkValue((Object)input);
            }

            @Override
            protected Object deserializeImpl(Object input) {
                return BuiltInType.checkValue((Object)input);
            }
        };
    }

    @FunctionalInterface
    private static interface WriterFactoryMethod<T extends DataContainer> {
        public BindingStreamEventWriter createWriter(@NonNull BindingNormalizedNodeWriterFactory var1, @NonNull Class<? extends T> var2, @NonNull NormalizedNodeStreamWriter var3);
    }
}

