/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.BitsTypeObject;
import org.opendaylight.yangtools.binding.contract.Naming;
import org.opendaylight.yangtools.binding.data.codec.impl.SchemaUnawareCodec;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;

final class BitsCodec
extends SchemaUnawareCodec {
    private static final Cache<Class<? extends BitsTypeObject>, @NonNull BitsCodec> CACHE = CacheBuilder.newBuilder().weakKeys().softValues().build();
    private static final MethodType CONSTRUCTOR_INVOKE_TYPE = MethodType.methodType(Object.class, Boolean[].class);
    private final ImmutableMap<String, Method> getters;
    private final ImmutableSet<String> ctorArgs;
    private final MethodHandle ctor;

    private BitsCodec(MethodHandle ctor, Set<String> ctorArgs, Map<String, Method> getters) {
        this.ctor = Objects.requireNonNull(ctor);
        this.ctorArgs = ImmutableSet.copyOf(ctorArgs);
        this.getters = ImmutableMap.copyOf(getters);
    }

    static @NonNull BitsCodec of(Class<?> returnType, BitsTypeDefinition rootType) throws ExecutionException {
        return (BitsCodec)CACHE.get(returnType.asSubclass(BitsTypeObject.class), () -> {
            LinkedHashMap<String, Method> getters = new LinkedHashMap<String, Method>();
            TreeSet<String> ctorArgs = new TreeSet<String>();
            for (Constructor<?>[] bit : rootType.getBits()) {
                Method valueGetter = returnType.getMethod("get" + Naming.getClassName((String)bit.getName()), new Class[0]);
                ctorArgs.add(bit.getName());
                getters.put(bit.getName(), valueGetter);
            }
            Constructor<?> constructor = null;
            for (Constructor<?> cst : returnType.getConstructors()) {
                if (cst.getParameterTypes()[0].equals(returnType)) continue;
                constructor = cst;
            }
            MethodHandle ctor = MethodHandles.publicLookup().unreflectConstructor(constructor).asSpreader(Boolean[].class, ctorArgs.size()).asType(CONSTRUCTOR_INVOKE_TYPE);
            return new BitsCodec(ctor, ctorArgs, getters);
        });
    }

    @Override
    protected Object deserializeImpl(Object input) {
        Preconditions.checkArgument((boolean)(input instanceof Set));
        Set casted = (Set)input;
        Boolean[] args = new Boolean[this.ctorArgs.size()];
        int currentArg = 0;
        for (String value : this.ctorArgs) {
            args[currentArg++] = casted.contains(value);
        }
        try {
            return this.ctor.invokeExact(args);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to instantiate object for " + String.valueOf(input), e);
        }
    }

    @Override
    protected Set<String> serializeImpl(Object input) {
        ArrayList<String> result = new ArrayList<String>(this.getters.size());
        for (Map.Entry valueGet : this.getters.entrySet()) {
            Boolean value;
            try {
                value = (Boolean)((Method)valueGet.getValue()).invoke(input, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException("Failed to get bit " + (String)valueGet.getKey(), e);
            }
            if (!value.booleanValue()) continue;
            result.add((String)valueGet.getKey());
        }
        return result.size() == this.getters.size() ? this.getters.keySet() : ImmutableSet.copyOf(result);
    }
}

