/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.ChoiceIn;
import org.opendaylight.yangtools.binding.DataContainer;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectStep;
import org.opendaylight.yangtools.binding.data.codec.api.BindingChoiceCodecTreeNode;
import org.opendaylight.yangtools.binding.data.codec.impl.CaseCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.CaseCodecPrototype;
import org.opendaylight.yangtools.binding.data.codec.impl.ChoiceCodecPrototype;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContextFactory;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContextSupplier;
import org.opendaylight.yangtools.binding.data.codec.impl.CommonDataObjectCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.CommonDataObjectCodecPrototype;
import org.opendaylight.yangtools.binding.data.codec.impl.DataContainerAnalysis;
import org.opendaylight.yangtools.binding.data.codec.impl.DataContainerCodecContext;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.yangtools.binding.runtime.api.CaseRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.ChoiceRuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ChoiceCodecContext<T extends ChoiceIn<?>>
extends DataContainerCodecContext<T, ChoiceRuntimeType, ChoiceCodecPrototype<T>>
implements BindingChoiceCodecTreeNode<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ChoiceCodecContext.class);
    private final ImmutableListMultimap<Class<?>, CommonDataObjectCodecPrototype<?>> ambiguousByCaseChildClass;
    private final ImmutableMap<Class<?>, CommonDataObjectCodecPrototype<?>> byCaseChildClass;
    private final ImmutableMap<YangInstanceIdentifier.NodeIdentifier, CaseCodecPrototype> byYangCaseChild;
    private final ImmutableMap<Class<?>, CommonDataObjectCodecPrototype<?>> byClass;
    private final Set<Class<?>> ambiguousByCaseChildWarnings;

    ChoiceCodecContext(Class<T> javaClass, ChoiceRuntimeType runtimeType, CodecContextFactory contextFactory) {
        this(new ChoiceCodecPrototype<T>(contextFactory, runtimeType, javaClass));
    }

    ChoiceCodecContext(ChoiceCodecPrototype<T> prototype) {
        super(prototype);
        HashMap byYangCaseChildBuilder = new HashMap();
        HashMap<Object, CaseCodecPrototype<Object>> byClassBuilder = new HashMap<Object, CaseCodecPrototype<Object>>();
        SetMultimap childToCase = MultimapBuilder.SetMultimapBuilder.hashKeys().hashSetValues().build();
        ChoiceRuntimeType choiceType = (ChoiceRuntimeType)prototype.runtimeType();
        CodecContextFactory factory = prototype.contextFactory();
        HashSet<JavaTypeName> localCases = new HashSet<JavaTypeName>();
        for (CaseRuntimeType caseType : choiceType.validCaseChildren()) {
            Class<?> caseClass = ChoiceCodecContext.loadCase(factory.runtimeContext(), caseType);
            CaseCodecPrototype caseCodecPrototype = new CaseCodecPrototype(caseClass, caseType, factory);
            localCases.add(caseType.getIdentifier());
            byClassBuilder.put(caseClass, caseCodecPrototype);
            for (Class<DataObject> cazeChild : ChoiceCodecContext.getChildrenClasses((Class<? extends DataContainer>)caseClass)) {
                childToCase.put(cazeChild, caseCodecPrototype);
            }
            for (EffectiveStatement stmt : caseType.statement().effectiveSubstatements()) {
                if (!(stmt instanceof DataSchemaNode)) continue;
                DataSchemaNode cazeChild = (DataSchemaNode)stmt;
                byYangCaseChildBuilder.put(YangInstanceIdentifier.NodeIdentifier.create((QName)cazeChild.getQName()), caseCodecPrototype);
            }
        }
        this.byYangCaseChild = ImmutableMap.copyOf(byYangCaseChildBuilder);
        ImmutableListMultimap.Builder ambiguousByCaseBuilder = ImmutableListMultimap.builder();
        ImmutableMap.Builder unambiguousByCaseBuilder = ImmutableMap.builder();
        for (Map.Entry entry : Multimaps.asMap((SetMultimap)childToCase).entrySet()) {
            Set cases = (Set)entry.getValue();
            if (cases.size() != 1) {
                ArrayList<CommonDataObjectCodecPrototype> list = new ArrayList<CommonDataObjectCodecPrototype>((Collection)entry.getValue());
                list.sort(Comparator.comparing(proto -> proto.javaClass().getCanonicalName()));
                ambiguousByCaseBuilder.putAll((Object)((Class)entry.getKey()), list);
                continue;
            }
            unambiguousByCaseBuilder.put((Object)((Class)entry.getKey()), (Object)((CommonDataObjectCodecPrototype)cases.iterator().next()));
        }
        this.byCaseChildClass = unambiguousByCaseBuilder.build();
        this.ambiguousByCaseChildClass = ambiguousByCaseBuilder.build();
        this.ambiguousByCaseChildWarnings = this.ambiguousByCaseChildClass.isEmpty() ? ImmutableSet.of() : ConcurrentHashMap.newKeySet();
        HashMap bySubstitutionBuilder = new HashMap();
        BindingRuntimeContext bindingRuntimeContext = factory.runtimeContext();
        block4: for (CaseRuntimeType caseType : bindingRuntimeContext.getTypes().allCaseChildren(choiceType)) {
            JavaTypeName caseName = caseType.getIdentifier();
            if (localCases.contains(caseName)) continue;
            Class<?> substitution = ChoiceCodecContext.loadCase(bindingRuntimeContext, caseType);
            for (Map.Entry real : byClassBuilder.entrySet()) {
                if (!ChoiceCodecContext.isSubstitutionFor(substitution, (Class)real.getKey())) continue;
                bySubstitutionBuilder.put(substitution, (CommonDataObjectCodecPrototype)real.getValue());
                continue block4;
            }
        }
        byClassBuilder.putAll(bySubstitutionBuilder);
        this.byClass = ImmutableMap.copyOf(byClassBuilder);
    }

    private static Class<?> loadCase(BindingRuntimeContext context, CaseRuntimeType caseType) {
        JavaTypeName className = caseType.getIdentifier();
        try {
            return context.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new LinkageError("Failed to load class for " + String.valueOf(className), e);
        }
    }

    @Deprecated(since="13.0.0", forRemoval=true)
    public DocumentedNode.WithStatus getSchema() {
        return (DocumentedNode.WithStatus)((ChoiceRuntimeType)((ChoiceCodecPrototype)this.prototype()).runtimeType()).statement();
    }

    CommonDataObjectCodecPrototype<?> streamChildPrototype(Class<?> childClass) {
        return (CommonDataObjectCodecPrototype)this.byClass.get(childClass);
    }

    Iterable<Class<?>> getCaseChildrenClasses() {
        return Iterables.concat((Iterable)this.byCaseChildClass.keySet(), (Iterable)this.ambiguousByCaseChildClass.keySet());
    }

    @Override
    public CodecContext yangPathArgumentChild(YangInstanceIdentifier.PathArgument arg) {
        return ((CaseCodecContext)super.yangPathArgumentChild(arg)).yangPathArgumentChild(arg);
    }

    @Override
    CodecContextSupplier yangChildSupplier(YangInstanceIdentifier.NodeIdentifier arg) {
        return (CodecContextSupplier)this.byYangCaseChild.get((Object)arg);
    }

    T deserializeObject(NormalizedNode normalizedNode) {
        ChoiceNode casted = ChoiceCodecContext.checkDataArgument(ChoiceNode.class, normalizedNode);
        Iterator it = casted.body().iterator();
        if (!it.hasNext()) {
            return null;
        }
        YangInstanceIdentifier.NodeIdentifier childName = ((DataContainerChild)it.next()).name();
        CaseCodecPrototype caze = this.childNonNull((CaseCodecPrototype)this.byYangCaseChild.get((Object)childName), (YangInstanceIdentifier.PathArgument)childName, "%s is not a valid case child of %s", childName, this);
        return (T)((ChoiceIn)((CodecContext)caze.getCodecContext()).deserializeObject((NormalizedNode)casted));
    }

    @Override
    public CommonDataObjectCodecContext<?, ?> bindingPathArgumentChild(DataObjectStep<?> step, List<YangInstanceIdentifier.PathArgument> builder) {
        Class caseType = step.caseType();
        DataContainerCodecContext<?, ?, ?> caze = caseType != null ? this.getStreamChild(caseType) : this.getCaseByChildClass(step.type());
        caze.addYangPathArgument(step, builder);
        return caze.bindingPathArgumentChild((DataObjectStep)step, (List)builder);
    }

    private DataContainerCodecContext<?, ?, ?> getCaseByChildClass(@NonNull Class<? extends DataObject> type) {
        ImmutableList inexact;
        CommonDataObjectCodecPrototype result = (CommonDataObjectCodecPrototype)this.byCaseChildClass.get(type);
        if (result == null && !(inexact = this.ambiguousByCaseChildClass.get(type)).isEmpty()) {
            result = (CommonDataObjectCodecPrototype)inexact.getFirst();
            if (this.ambiguousByCaseChildWarnings.add(type)) {
                LOG.warn("Ambiguous reference {} to child of {} resolved to {}, the first case in {} This mapping is not guaranteed to be stable and is subject to variations based on runtime circumstances. Please see the stack trace for hints about the source of ambiguity.", new Object[]{type, this.getBindingClass(), result.javaClass(), Lists.transform((List)inexact, CommonDataObjectCodecPrototype::javaClass), new Throwable()});
            }
        }
        return (DataContainerCodecContext)this.childNonNull(result, type, "Class %s is not child of any cases for %s", type, this.getBindingClass()).getCodecContext();
    }

    private static Iterable<Class<? extends DataObject>> getChildrenClasses(Class<? extends DataContainer> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Target type must not be null");
        Preconditions.checkArgument((boolean)DataContainer.class.isAssignableFrom(type), (Object)"Supplied type must be derived from DataContainer");
        LinkedList<Class<? extends DataObject>> ret = new LinkedList<Class<? extends DataObject>>();
        for (Method method : type.getMethods()) {
            DataContainerAnalysis.getYangModeledReturnType(method, "get").ifPresent(entity -> ret.add((Class<? extends DataObject>)entity));
        }
        return ret;
    }
}

