/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.BaseIdentity;
import org.opendaylight.yangtools.binding.data.codec.api.BindingIdentityCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.AbstractValueCodec;
import org.opendaylight.yangtools.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.yangtools.binding.runtime.api.IdentityRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.common.QName;

final class IdentityCodec
extends AbstractValueCodec<QName, BaseIdentity>
implements BindingIdentityCodec {
    private final LoadingCache<@NonNull QName, @NonNull BaseIdentity> values = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<QName, BaseIdentity>(){

        public BaseIdentity load(QName key) {
            Object value;
            Field field;
            Class clazz = IdentityCodec.this.context.getIdentityClass(key);
            try {
                field = clazz.getField("VALUE");
            }
            catch (NoSuchFieldException e) {
                throw new LinkageError(String.valueOf(clazz) + " does not define required field VALUE", e);
            }
            if (!Modifier.isStatic(field.getModifiers())) {
                throw new LinkageError(String.valueOf(field) + " is not static");
            }
            try {
                value = clazz.cast(field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new LinkageError(String.valueOf(field) + " is not accesssible", e);
            }
            if (value == null) {
                throw new LinkageError(String.valueOf(field) + " is null");
            }
            try {
                return (BaseIdentity)clazz.cast(value);
            }
            catch (ClassCastException e) {
                throw new LinkageError(String.valueOf(field) + " value " + String.valueOf(value) + " has illegal type", e);
            }
        }
    });
    private final LoadingCache<@NonNull Class<? extends BaseIdentity>, @NonNull QName> qnames = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Class<? extends BaseIdentity>, QName>(){

        public QName load(Class<? extends BaseIdentity> key) {
            RuntimeType schema = IdentityCodec.this.context.getTypeWithSchema(key);
            if (schema instanceof IdentityRuntimeType) {
                IdentityRuntimeType identitySchema = (IdentityRuntimeType)schema;
                return (QName)identitySchema.statement().argument();
            }
            throw new IllegalStateException("Unexpected schema " + String.valueOf(schema) + " for " + String.valueOf(key));
        }
    });
    private final BindingRuntimeContext context;

    IdentityCodec(BindingRuntimeContext context) {
        this.context = Objects.requireNonNull(context);
    }

    @Override
    protected BaseIdentity deserializeImpl(QName input) {
        return this.toBinding(input);
    }

    @Override
    protected QName serializeImpl(BaseIdentity input) {
        return this.fromBinding(input);
    }

    public <T extends BaseIdentity> T toBinding(QName qname) {
        try {
            return (T)((BaseIdentity)this.values.get((Object)Objects.requireNonNull(qname)));
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new IllegalStateException("Unexpected error translating " + String.valueOf(qname), e);
        }
    }

    public QName fromBinding(BaseIdentity bindingValue) {
        try {
            return (QName)this.qnames.get((Object)bindingValue.implementedInterface());
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new IllegalStateException("Unexpected error translating " + String.valueOf(bindingValue), e);
        }
    }
}

