/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectStep;
import org.opendaylight.yangtools.binding.EntryObject;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.KeyStep;
import org.opendaylight.yangtools.binding.KeylessStep;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContextFactory;
import org.opendaylight.yangtools.binding.data.codec.impl.IdentifiableItemCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.LazyBindingMap;
import org.opendaylight.yangtools.binding.data.codec.impl.ListCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.MapCodecPrototype;
import org.opendaylight.yangtools.binding.runtime.api.ListRuntimeType;
import org.opendaylight.yangtools.yang.common.Ordering;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;

abstract sealed class MapCodecContext<I extends Key<D>, D extends EntryObject<D, I>>
extends ListCodecContext<D> {
    private final IdentifiableItemCodec codec;

    private MapCodecContext(MapCodecPrototype prototype, Method keyMethod, IdentifiableItemCodec codec) {
        super(prototype, keyMethod);
        this.codec = Objects.requireNonNull(codec);
    }

    static @NonNull MapCodecContext<?, ?> of(Class<? extends DataObject> cls, ListRuntimeType type, CodecContextFactory factory) {
        return MapCodecContext.of(new MapCodecPrototype((DataObjectStep<?>)new KeylessStep(cls), type, factory));
    }

    static @NonNull MapCodecContext<?, ?> of(MapCodecPrototype prototype) {
        Method keyMethod;
        Class<DataObject> bindingClass = prototype.javaClass();
        try {
            keyMethod = bindingClass.getMethod("key", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Required method not available", e);
        }
        ListRuntimeType type = (ListRuntimeType)prototype.runtimeType();
        IdentifiableItemCodec codec = prototype.contextFactory().getPathArgumentCodec(bindingClass, type);
        return type.statement().ordering() == Ordering.SYSTEM ? new Unordered(prototype, keyMethod, codec) : new Ordered(prototype, keyMethod, codec);
    }

    @Override
    void addYangPathArgument(List<YangInstanceIdentifier.PathArgument> builder, DataObjectStep<?> step) {
        YangInstanceIdentifier.NodeIdentifier yangArg = this.getDomPathArgument();
        builder.add((YangInstanceIdentifier.PathArgument)yangArg);
        if (step instanceof KeyStep) {
            KeyStep keyStep = (KeyStep)step;
            builder.add((YangInstanceIdentifier.PathArgument)this.codec.bindingToDom(keyStep));
        } else {
            builder.add((YangInstanceIdentifier.PathArgument)yangArg);
        }
    }

    @Override
    protected final DataObjectStep<?> getBindingPathArgument(YangInstanceIdentifier.PathArgument domArg) {
        DataObjectStep<?> dataObjectStep;
        if (domArg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            YangInstanceIdentifier.NodeIdentifierWithPredicates nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)domArg;
            dataObjectStep = this.codec.domToBinding(nip);
        } else {
            dataObjectStep = super.getBindingPathArgument(domArg);
        }
        return dataObjectStep;
    }

    final YangInstanceIdentifier.NodeIdentifierWithPredicates serialize(Key<?> key) {
        return this.codec.bindingToDom(new KeyStep(this.getBindingClass(), key));
    }

    final @NonNull Key<?> deserialize(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifierWithPredicates arg) {
        return this.codec.deserializeIdentifier(arg);
    }

    @Override
    public final YangInstanceIdentifier.PathArgument serializePathArgument(DataObjectStep<?> step) {
        YangInstanceIdentifier.PathArgument pathArgument;
        if (step instanceof KeyStep) {
            KeyStep keyStep = (KeyStep)step;
            pathArgument = this.codec.bindingToDom(keyStep);
        } else {
            pathArgument = super.serializePathArgument(step);
        }
        return pathArgument;
    }

    @Override
    public final DataObjectStep<?> deserializePathArgument(YangInstanceIdentifier.PathArgument arg) {
        DataObjectStep<?> dataObjectStep;
        if (arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            YangInstanceIdentifier.NodeIdentifierWithPredicates nip = (YangInstanceIdentifier.NodeIdentifierWithPredicates)arg;
            dataObjectStep = this.codec.domToBinding(nip);
        } else {
            dataObjectStep = super.deserializePathArgument(arg);
        }
        return dataObjectStep;
    }

    static final class Unordered<I extends Key<D>, D extends EntryObject<D, I>>
    extends MapCodecContext<I, D> {
        private Unordered(MapCodecPrototype prototype, Method keyMethod, IdentifiableItemCodec codec) {
            super(prototype, keyMethod, codec);
        }

        @Override
        Map<I, D> fromMap(MapNode map, int size) {
            return LazyBindingMap.of(this, map, size);
        }
    }

    private static final class Ordered<I extends Key<D>, D extends EntryObject<D, I>>
    extends MapCodecContext<I, D> {
        Ordered(MapCodecPrototype prototype, Method keyMethod, IdentifiableItemCodec codec) {
            super(prototype, keyMethod, codec);
        }
    }
}

