/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectStep;
import org.opendaylight.yangtools.binding.NodeStep;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContextFactory;
import org.opendaylight.yangtools.binding.data.codec.impl.ContainerLikeCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.StructuralContainerCodecPrototype;
import org.opendaylight.yangtools.binding.runtime.api.ContainerRuntimeType;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;

final class StructuralContainerCodecContext<D extends DataObject>
extends ContainerLikeCodecContext<D> {
    private static final VarHandle EMPTY_OBJECT;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile D emptyObject;

    StructuralContainerCodecContext(Class<D> cls, ContainerRuntimeType type, CodecContextFactory factory) {
        this(new StructuralContainerCodecPrototype((DataObjectStep<?>)new NodeStep(cls), type, factory));
    }

    StructuralContainerCodecContext(StructuralContainerCodecPrototype prototype) {
        super(prototype);
    }

    @NonNull D emptyObject() {
        DataObject local = EMPTY_OBJECT.getAcquire(this);
        return (D)(local != null ? local : this.loadEmptyObject());
    }

    private @NonNull D loadEmptyObject() {
        Object local = this.createBindingProxy((DataContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)this.getDomPathArgument()).build());
        DataObject witness = EMPTY_OBJECT.compareAndExchangeRelease(this, null, (DataObject)local);
        return (D)(witness != null ? witness : local);
    }

    static {
        try {
            EMPTY_OBJECT = MethodHandles.lookup().findVarHandle(StructuralContainerCodecContext.class, "emptyObject", DataObject.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

