/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Map;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.DataObjectStep;
import org.opendaylight.yangtools.binding.data.codec.api.BindingAugmentationCodecTreeNode;
import org.opendaylight.yangtools.binding.data.codec.impl.AugmentationCodecPrototype;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecDataObjectGenerator;
import org.opendaylight.yangtools.binding.data.codec.impl.CommonDataObjectCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.DataContainerAnalysis;
import org.opendaylight.yangtools.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

final class AugmentationCodecContext<A extends Augmentation<?>>
extends CommonDataObjectCodecContext<A, AugmentRuntimeType>
implements BindingAugmentationCodecTreeNode<A> {
    private static final MethodType CONSTRUCTOR_TYPE = MethodType.methodType(Void.TYPE, CommonDataObjectCodecContext.class, DataContainerNode.class);
    private static final MethodType AUGMENTATION_TYPE = MethodType.methodType(Augmentation.class, AugmentationCodecContext.class, DataContainerNode.class);
    private final MethodHandle proxyConstructor;

    private AugmentationCodecContext(AugmentationCodecPrototype<A> prototype, DataContainerAnalysis<AugmentRuntimeType> analysis) {
        super(prototype, analysis);
        MethodHandle ctor;
        Class bindingClass = CodecDataObjectGenerator.generate(prototype.contextFactory().getLoader(), prototype.javaClass(), analysis.leafContexts, analysis.daoProperties, null);
        try {
            ctor = MethodHandles.publicLookup().findConstructor(bindingClass, CONSTRUCTOR_TYPE);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new LinkageError("Failed to find contructor for class " + String.valueOf(bindingClass), e);
        }
        this.proxyConstructor = ctor.asType(AUGMENTATION_TYPE);
    }

    AugmentationCodecContext(AugmentationCodecPrototype<A> prototype) {
        this(prototype, new DataContainerAnalysis<AugmentRuntimeType>(prototype));
    }

    public YangInstanceIdentifier.PathArgument serializePathArgument(DataObjectStep<?> step) {
        if (!this.bindingArg().equals(step)) {
            throw new IllegalArgumentException("Unexpected argument " + String.valueOf(step));
        }
        return null;
    }

    public DataObjectStep<?> deserializePathArgument(YangInstanceIdentifier.PathArgument arg) {
        if (arg != null) {
            throw new IllegalArgumentException("Unexpected argument " + String.valueOf(arg));
        }
        return this.bindingArg();
    }

    public A filterFrom(DataContainerNode parentData) {
        for (YangInstanceIdentifier.NodeIdentifier childArg : ((AugmentationCodecPrototype)this.prototype()).getChildArgs()) {
            if (parentData.childByArg((YangInstanceIdentifier.PathArgument)childArg) == null) continue;
            try {
                return (A)this.proxyConstructor.invokeExact(this, parentData);
            }
            catch (Throwable e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    public ImmutableSet<YangInstanceIdentifier.NodeIdentifier> childPathArguments() {
        return this.byYangKeySet();
    }

    @Override
    Object deserializeObject(NormalizedNode normalizedNode) {
        return this.filterFrom(AugmentationCodecContext.checkDataArgument(DataContainerNode.class, normalizedNode));
    }

    @Override
    void addYangPathArgument(List<YangInstanceIdentifier.PathArgument> builder, DataObjectStep<?> step) {
    }

    @Override
    YangInstanceIdentifier.NodeIdentifier getDomPathArgument() {
        return null;
    }

    @Override
    Map<Class<? extends Augmentation<?>>, Augmentation<?>> getAllAugmentationsFrom(DataContainerNode data) {
        return Map.of();
    }
}

