/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.base.VerifyException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.data.codec.api.BindingDataContainerCodecTreeNode;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContextSupplier;
import org.opendaylight.yangtools.binding.data.codec.impl.CommonDataObjectCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.MapCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.StructuralContainerCodecContext;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public abstract class CodecDataObject<T extends DataObject>
implements DataObject {
    private static final @NonNull Object NULL_VALUE = new Object();
    private static final VarHandle CACHED_HASH_CODE;
    private final @NonNull CommonDataObjectCodecContext<T, ?> context;
    private final @NonNull DataContainerNode data;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile Integer cachedHashcode;

    protected CodecDataObject(CommonDataObjectCodecContext<T, ?> context, DataContainerNode data) {
        this.data = Objects.requireNonNull(data, "Data must not be null");
        this.context = Objects.requireNonNull(context, "Context must not be null");
    }

    public final int hashCode() {
        Integer cached = CACHED_HASH_CODE.getAcquire(this);
        return cached != null ? cached.intValue() : this.loadHashCode();
    }

    public final boolean equals(Object obj) {
        return this.codecEquals(obj);
    }

    public abstract String toString();

    protected final Object codecMember(VarHandle handle, String localName) {
        Object cached = handle.getAcquire(this);
        return cached != null ? CodecDataObject.unmaskNull(cached) : this.loadMember(handle, this.context.getLeafChild(localName));
    }

    protected final Object codecMember(VarHandle handle, Class<? extends DataObject> bindingClass) {
        Object cached = handle.getAcquire(this);
        return cached != null ? CodecDataObject.unmaskNull(cached) : this.loadMember(handle, (CodecContext)this.context.getStreamChild(bindingClass));
    }

    protected final Object codecMember(VarHandle handle, CodecContextSupplier supplier) {
        Object cached = handle.getAcquire(this);
        return cached != null ? CodecDataObject.unmaskNull(cached) : this.loadMember(handle, supplier.getCodecContext());
    }

    protected final @NonNull Object codecMemberOrEmpty(@Nullable Object value, @NonNull Class<? extends DataObject> bindingClass) {
        return value != null ? value : this.emptyObject(bindingClass);
    }

    private @NonNull Object emptyObject(@NonNull Class<? extends DataObject> bindingClass) {
        BindingDataContainerCodecTreeNode childContext = this.context.getStreamChild(bindingClass);
        if (childContext instanceof StructuralContainerCodecContext) {
            StructuralContainerCodecContext structural = (StructuralContainerCodecContext)childContext;
            return structural.emptyObject();
        }
        throw new VerifyException("Unexpected context " + String.valueOf(childContext));
    }

    protected final @NonNull Object codecKey(VarHandle handle) {
        Object cached = handle.getAcquire(this);
        return cached != null ? cached : this.loadKey(handle);
    }

    protected abstract int codecHashCode();

    protected abstract boolean codecEquals(Object var1);

    final @NonNull CommonDataObjectCodecContext<T, ?> codecContext() {
        return this.context;
    }

    final @NonNull DataContainerNode codecData() {
        return this.data;
    }

    private Object loadMember(VarHandle handle, CodecContext childCtx) {
        DataContainerChild child = (DataContainerChild)this.data.childByArg((YangInstanceIdentifier.PathArgument)childCtx.getDomPathArgument());
        Object obj = child != null ? childCtx.deserializeObject((NormalizedNode)child) : childCtx.defaultObject();
        Object witness = handle.compareAndExchangeRelease(this, null, CodecDataObject.maskNull(obj));
        return witness == null ? obj : CodecDataObject.unmaskNull(witness);
    }

    private @NonNull Object loadKey(VarHandle handle) {
        DataContainerNode dataContainerNode = this.data;
        if (!(dataContainerNode instanceof MapEntryNode)) {
            throw new VerifyException("Unsupported value " + String.valueOf(this.data));
        }
        MapEntryNode mapEntry = (MapEntryNode)dataContainerNode;
        CommonDataObjectCodecContext<T, ?> commonDataObjectCodecContext = this.context;
        if (!(commonDataObjectCodecContext instanceof MapCodecContext)) {
            throw new VerifyException("Unexpected context " + String.valueOf(this.context));
        }
        MapCodecContext listContext = (MapCodecContext)commonDataObjectCodecContext;
        Key<?> obj = listContext.deserialize(mapEntry.name());
        Object witness = handle.compareAndExchangeRelease(this, null, obj);
        return witness == null ? obj : witness;
    }

    private int loadHashCode() {
        int result = this.codecHashCode();
        Object witness = CACHED_HASH_CODE.compareAndExchangeRelease(this, null, result);
        return witness == null ? result : (Integer)witness;
    }

    private static @NonNull Object maskNull(@Nullable Object unmasked) {
        return unmasked == null ? NULL_VALUE : unmasked;
    }

    private static @Nullable Object unmaskNull(Object masked) {
        return masked == NULL_VALUE ? null : masked;
    }

    static {
        try {
            CACHED_HASH_CODE = MethodHandles.lookup().findVarHandle(CodecDataObject.class, "cachedHashcode", Integer.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

