/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.BaseIdentity;
import org.opendaylight.yangtools.binding.BindingInstanceIdentifier;
import org.opendaylight.yangtools.binding.data.codec.impl.AbstractValueCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.EncapsulatedValueCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.IdentityCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.InstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

abstract sealed class CompositeValueCodec
extends AbstractValueCodec<Object, Object> {
    private final EncapsulatedValueCodec typeObjectCodec;

    private CompositeValueCodec(Class<?> valueType) {
        this.typeObjectCodec = EncapsulatedValueCodec.ofUnchecked(valueType);
    }

    @Override
    protected Object deserializeImpl(Object input) {
        return this.typeObjectCodec.deserialize(this.domToBinding(input));
    }

    abstract @NonNull Object domToBinding(@NonNull Object var1);

    @Override
    protected Object serializeImpl(Object input) {
        return this.bindingToDom(this.typeObjectCodec.serialize(input));
    }

    abstract @NonNull Object bindingToDom(@NonNull Object var1);

    static final class OfInstanceIdentifier
    extends CompositeValueCodec {
        private final InstanceIdentifierCodec valueCodec;

        OfInstanceIdentifier(Class<?> valueType, InstanceIdentifierCodec codec) {
            super(valueType);
            this.valueCodec = Objects.requireNonNull(codec);
        }

        BindingInstanceIdentifier domToBinding(Object domValue) {
            Object object = domValue;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            return this.valueCodec.deserialize(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{YangInstanceIdentifier.class}, (Object)object2, n)) {
                case 0 -> (YangInstanceIdentifier)object2;
                default -> throw new IllegalArgumentException("Unexpected DOM value " + String.valueOf(domValue));
            });
        }

        YangInstanceIdentifier bindingToDom(Object bindingValue) {
            Object object = bindingValue;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            return this.valueCodec.fromBinding(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BindingInstanceIdentifier.class}, (Object)object2, n)) {
                case 0 -> (BindingInstanceIdentifier)object2;
                default -> throw new IllegalArgumentException("Unexpected Binding value " + String.valueOf(bindingValue));
            });
        }
    }

    static final class OfIdentity
    extends CompositeValueCodec {
        private final IdentityCodec valueCodec;

        OfIdentity(Class<?> valueType, IdentityCodec codec) {
            super(valueType);
            this.valueCodec = Objects.requireNonNull(codec);
        }

        QName bindingToDom(Object bindingValue) {
            Object object = bindingValue;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            return this.valueCodec.fromBinding(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BaseIdentity.class}, (Object)object2, n)) {
                case 0 -> (BaseIdentity)object2;
                default -> throw new IllegalArgumentException("Unexpected Binding value " + String.valueOf(bindingValue));
            });
        }

        BaseIdentity domToBinding(Object domValue) {
            Object object = domValue;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            return this.valueCodec.toBinding(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{QName.class}, (Object)object2, n)) {
                case 0 -> (QName)object2;
                default -> throw new IllegalArgumentException("Unexpected DOM value " + String.valueOf(domValue));
            });
        }
    }
}

