/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.yangtools.binding.BindingInstanceIdentifier;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.binding.DataObjectStep;
import org.opendaylight.yangtools.binding.ExactPropertyStep;
import org.opendaylight.yangtools.binding.LeafListPropertyStep;
import org.opendaylight.yangtools.binding.LeafPropertyStep;
import org.opendaylight.yangtools.binding.PropertyIdentifier;
import org.opendaylight.yangtools.binding.data.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.yangtools.binding.data.codec.api.BindingInstanceIdentifierCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.AbstractOpaqueCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.BindingCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.CaseCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.ChoiceCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.CommonDataObjectCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.DataContainerCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.DataContainerPrototype;
import org.opendaylight.yangtools.binding.data.codec.impl.LeafNodeCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.LeafSetNodeCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.ValueCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.ValueNodeCodecContext;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class InstanceIdentifierCodec
implements BindingInstanceIdentifierCodec,
ValueCodec<YangInstanceIdentifier, BindingInstanceIdentifier> {
    private final BindingCodecContext context;

    InstanceIdentifierCodec(BindingCodecContext context) {
        this.context = Objects.requireNonNull(context);
    }

    public <T extends DataObject> DataObjectReference<T> toBinding(YangInstanceIdentifier domPath) {
        ArrayList builder = new ArrayList();
        BindingDataObjectCodecTreeNode<?> codec = this.context.getCodecContextNode(domPath, builder);
        return codec == null ? null : DataObjectReference.ofUnsafeSteps(builder);
    }

    public BindingInstanceIdentifier toBindingInstanceIdentifier(YangInstanceIdentifier domPath) {
        ArrayList steps = new ArrayList();
        CodecContext codecContext = this.context.lookupCodecContext(domPath, steps);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CaseCodecContext.class, ChoiceCodecContext.class, CommonDataObjectCodecContext.class, LeafSetNodeCodecContext.class, ValueNodeCodecContext.class}, (Object)codecContext, n)) {
            default -> throw new MatchException(null, null);
            case -1 -> null;
            case 0 -> {
                CaseCodecContext caseCodec = (CaseCodecContext)codecContext;
                yield null;
            }
            case 1 -> {
                ChoiceCodecContext choice = (ChoiceCodecContext)codecContext;
                yield null;
            }
            case 2 -> {
                CommonDataObjectCodecContext dataObjectCodec = (CommonDataObjectCodecContext)codecContext;
                yield InstanceIdentifierCodec.newDataObjectIdentifier(steps);
            }
            case 3 -> {
                LeafSetNodeCodecContext leafSetCodec = (LeafSetNodeCodecContext)codecContext;
                YangInstanceIdentifier.PathArgument var10_9 = domPath.getLastPathArgument();
                if (var10_9 instanceof YangInstanceIdentifier.NodeWithValue) {
                    YangInstanceIdentifier.NodeWithValue withValue = (YangInstanceIdentifier.NodeWithValue)var10_9;
                    DataObjectIdentifier<?> doi = InstanceIdentifierCodec.newDataObjectIdentifier(steps);
                    yield new PropertyIdentifier(doi, (ExactPropertyStep)new LeafListPropertyStep(doi.lastStep().type(), leafSetCodec.valueType(), leafSetCodec.getSchema().getQName().unbind(), leafSetCodec.getValueCodec().deserialize(withValue.getValue())));
                }
                yield null;
            }
            case 4 -> {
                ValueNodeCodecContext valueCodec = (ValueNodeCodecContext)codecContext;
                DataObjectIdentifier<?> doi = InstanceIdentifierCodec.newDataObjectIdentifier(steps);
                yield new PropertyIdentifier(doi, (ExactPropertyStep)new LeafPropertyStep(doi.lastStep().type(), valueCodec.valueType(), valueCodec.getSchema().getQName().unbind()));
            }
        };
    }

    private static DataObjectIdentifier<?> newDataObjectIdentifier(List<DataObjectStep<?>> steps) {
        DataObjectReference ref = DataObjectReference.ofUnsafeSteps(steps);
        try {
            return ref.toIdentifier();
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public YangInstanceIdentifier fromBinding(DataObjectReference<?> bindingPath) {
        ArrayList<YangInstanceIdentifier.PathArgument> domArgs = new ArrayList<YangInstanceIdentifier.PathArgument>();
        this.context.getCodecContextNode(bindingPath, domArgs);
        return YangInstanceIdentifier.of(domArgs);
    }

    public YangInstanceIdentifier fromBinding(PropertyIdentifier<?, ?> bindingPath) {
        ArrayList<YangInstanceIdentifier.PathArgument> domArgs = new ArrayList<YangInstanceIdentifier.PathArgument>();
        DataContainerCodecContext<?, ?, ?> containerCodec = this.context.getCodecContextNode((DataObjectReference<?>)bindingPath.container(), (List<YangInstanceIdentifier.PathArgument>)domArgs);
        ExactPropertyStep property = bindingPath.property();
        YangInstanceIdentifier.NodeIdentifier childArg = ((DataContainerPrototype)containerCodec.prototype()).bindIdentifier(property.yangIdentifier());
        CodecContext codec = containerCodec.yangPathArgumentChild((YangInstanceIdentifier.PathArgument)childArg);
        domArgs.add((YangInstanceIdentifier.PathArgument)childArg);
        ExactPropertyStep exactPropertyStep = property;
        Objects.requireNonNull(exactPropertyStep);
        ExactPropertyStep exactPropertyStep2 = exactPropertyStep;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LeafPropertyStep.class, LeafListPropertyStep.class}, (Object)exactPropertyStep2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                LeafPropertyStep leaf = (LeafPropertyStep)exactPropertyStep2;
                if (codec instanceof LeafNodeCodecContext || codec instanceof AbstractOpaqueCodecContext) break;
                throw new IllegalArgumentException(String.valueOf(leaf) + " does not match context " + String.valueOf(codec));
            }
            case 1: {
                LeafListPropertyStep leafList = (LeafListPropertyStep)exactPropertyStep2;
                if (codec instanceof LeafSetNodeCodecContext) {
                    LeafSetNodeCodecContext leafListCodec = (LeafSetNodeCodecContext)codec;
                    domArgs.add((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeWithValue(childArg.getNodeType(), leafListCodec.getValueCodec().deserialize(leafList.value())));
                    break;
                }
                throw new IllegalArgumentException(String.valueOf(leafList) + " does not match context " + String.valueOf(codec));
            }
        }
        return YangInstanceIdentifier.of(domArgs);
    }

    @Override
    @Deprecated
    public YangInstanceIdentifier serialize(BindingInstanceIdentifier input) {
        return this.fromBinding(input);
    }

    @Override
    @Deprecated
    public BindingInstanceIdentifier deserialize(YangInstanceIdentifier input) {
        BindingInstanceIdentifier binding = this.toBindingInstanceIdentifier(input);
        if (binding == null) {
            throw new IllegalArgumentException(String.valueOf(input) + " cannot be represented as a BindingInstanceIdentifier");
        }
        return binding;
    }
}

