/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.time.Instant;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.BaseNotification;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.EventInstantAware;
import org.opendaylight.yangtools.binding.data.codec.impl.AugmentableCodecDataObject;
import org.opendaylight.yangtools.binding.data.codec.impl.ByteBuddyUtils;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContextFactory;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecPackage;
import org.opendaylight.yangtools.binding.data.codec.impl.CommonDataObjectCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.CommonDataObjectCodecPrototype;
import org.opendaylight.yangtools.binding.data.codec.impl.DataObjectCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.DataObjectCodecPrototype;
import org.opendaylight.yangtools.binding.loader.BindingClassLoader;
import org.opendaylight.yangtools.binding.runtime.api.NotificationRuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

final class NotificationCodecContext<D extends DataObject & BaseNotification>
extends DataObjectCodecContext<D, NotificationRuntimeType> {
    private static final TypeDescription.Generic EVENT_INSTANT_AWARE = TypeDefinition.Sort.describe(EventInstantAware.class);
    private static final String EVENT_INSTANT_NAME;
    private static final TypeDescription.Generic EVENT_INSTANT_RETTYPE;
    private static final TypeDescription.Generic BB_DOCC;
    private static final TypeDescription.Generic BB_DCN;
    private static final TypeDescription.Generic BB_I;
    private static final MethodType CONSTRUCTOR_TYPE;
    private static final MethodType NOTIFICATION_TYPE;
    private static final String INSTANT_FIELD = "instant";
    private final MethodHandle eventProxy;

    NotificationCodecContext(Class<?> notificationClass, NotificationRuntimeType type, CodecContextFactory factory) {
        super(new Prototype(notificationClass, type, factory));
        MethodHandle ctor;
        Class bindingClass = this.getBindingClass();
        Class eventAwareClass = CodecPackage.EVENT_AWARE.generateClass(((CommonDataObjectCodecPrototype)this.prototype()).contextFactory().getLoader(), bindingClass, (loader, fqcn, bindingInterface) -> {
            Class<?> codecImpl = CodecPackage.CODEC.getGeneratedClass(loader, bindingClass);
            return BindingClassLoader.GeneratorResult.of((DynamicType.Unloaded)new ByteBuddy().subclass(codecImpl, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).implement(new TypeDefinition[]{EVENT_INSTANT_AWARE}).name(fqcn).defineField(INSTANT_FIELD, (TypeDefinition)BB_I, 4114).defineConstructor(4097).withParameters(new TypeDefinition[]{BB_DOCC, BB_DCN, BB_I}).intercept((Implementation)ConstructorImplementation.INSTANCE).defineMethod(EVENT_INSTANT_NAME, (TypeDefinition)EVENT_INSTANT_RETTYPE, 4097).intercept((Implementation)EventInstantImplementation.INSTANCE).make());
        });
        try {
            ctor = MethodHandles.publicLookup().findConstructor(eventAwareClass, CONSTRUCTOR_TYPE);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new LinkageError("Failed to acquire constructor", e);
        }
        this.eventProxy = ctor.asType(NOTIFICATION_TYPE);
    }

    public D deserialize(NormalizedNode data) {
        return this.createBindingProxy((DataContainerNode)NotificationCodecContext.checkDataArgument(ContainerNode.class, data));
    }

    @NonNull BaseNotification deserialize(@NonNull ContainerNode data, @NonNull Instant eventInstant) {
        BaseNotification ret;
        try {
            ret = this.eventProxy.invokeExact(this, data, eventInstant);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new LinkageError("Failed to instantiate notification", e);
        }
        return (BaseNotification)Verify.verifyNotNull((Object)ret);
    }

    static {
        MethodDescription eventInstance = (MethodDescription)EVENT_INSTANT_AWARE.getDeclaredMethods().getOnly();
        EVENT_INSTANT_NAME = eventInstance.getName();
        EVENT_INSTANT_RETTYPE = eventInstance.getReturnType();
        BB_DOCC = TypeDefinition.Sort.describe(DataObjectCodecContext.class);
        BB_DCN = TypeDefinition.Sort.describe(DataContainerNode.class);
        BB_I = TypeDefinition.Sort.describe(Instant.class);
        CONSTRUCTOR_TYPE = MethodType.methodType(Void.TYPE, DataObjectCodecContext.class, DataContainerNode.class, Instant.class);
        NOTIFICATION_TYPE = MethodType.methodType(BaseNotification.class, NotificationCodecContext.class, ContainerNode.class, Instant.class);
    }

    static final class Prototype<D extends DataObject & BaseNotification>
    extends DataObjectCodecPrototype<NotificationRuntimeType> {
        private Prototype(Class<?> cls, NotificationRuntimeType type, CodecContextFactory factory) {
            super(cls, YangInstanceIdentifier.NodeIdentifier.create((QName)((QName)type.statement().argument())), type, factory);
        }

        @Override
        NotificationCodecContext<?> createInstance() {
            throw new UnsupportedOperationException("Should never be invoked");
        }
    }

    private static enum ConstructorImplementation implements Implementation
    {
        INSTANCE;

        private static final StackManipulation LOAD_INSTANT_ARG;
        private static final StackManipulation LOAD_CTOR_ARGS;

        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            TypeDescription instrumentedType = implementationTarget.getInstrumentedType();
            MethodDescription.InGenericShape superCtor = (MethodDescription.InGenericShape)((MethodList)((TypeDescription.Generic)Verify.verifyNotNull((Object)instrumentedType.getSuperClass())).getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isConstructor())).getOnly();
            return new ByteCodeAppender.Simple(new StackManipulation[]{MethodVariableAccess.loadThis(), LOAD_CTOR_ARGS, MethodInvocation.invoke((MethodDescription)superCtor), MethodVariableAccess.loadThis(), LOAD_INSTANT_ARG, ByteBuddyUtils.putField(instrumentedType, NotificationCodecContext.INSTANT_FIELD), MethodReturn.VOID});
        }

        static {
            LOAD_INSTANT_ARG = MethodVariableAccess.REFERENCE.loadFrom(3);
            try {
                LOAD_CTOR_ARGS = MethodVariableAccess.allArgumentsOf((MethodDescription)new MethodDescription.ForLoadedConstructor(AugmentableCodecDataObject.class.getDeclaredConstructor(CommonDataObjectCodecContext.class, DataContainerNode.class)));
            }
            catch (NoSuchMethodException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static enum EventInstantImplementation implements Implementation
    {
        INSTANCE;


        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new ByteCodeAppender.Simple(new StackManipulation[]{MethodVariableAccess.loadThis(), ByteBuddyUtils.getField(implementationTarget.getInstrumentedType(), NotificationCodecContext.INSTANT_FIELD), MethodReturn.REFERENCE});
        }
    }
}

