/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.opendaylight.yangtools.binding.data.codec.impl.ValueCodec;
import org.opendaylight.yangtools.binding.data.codec.impl.ValueNodeCodecContext;

final class ValueContext {
    private static final MethodType OBJECT_METHOD = MethodType.methodType(Object.class, Object.class);
    private final ValueCodec<Object, Object> codec;
    private final MethodHandle getter;
    private final Class<?> identifier;
    private final String getterName;

    ValueContext(Class<?> identifier, ValueNodeCodecContext leaf) {
        this.getterName = leaf.getGetterName();
        try {
            this.getter = MethodHandles.publicLookup().unreflect(identifier.getMethod(this.getterName, new Class[0])).asType(OBJECT_METHOD);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException(String.format("Cannot find method %s in class %s", this.getterName, identifier), e);
        }
        this.identifier = identifier;
        this.codec = leaf.getValueCodec();
    }

    Object getAndSerialize(Object obj) {
        Object value;
        try {
            value = this.getter.invokeExact(obj);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"All keys must be specified for %s. Missing key is %s. Supplied key is %s", this.identifier, (Object)this.getterName, (Object)obj);
        return this.codec.serialize(value);
    }

    Object deserialize(Object obj) {
        Preconditions.checkArgument((obj != null ? 1 : 0) != 0, (String)"Attempted to serialize null for %s component of %s", (Object)this.getterName, this.identifier);
        return Verify.verifyNotNull((Object)this.codec.deserialize(obj), (String)"Codec for %s of %s returned null for %s", (Object[])new Object[]{this.getterName, this.identifier, obj});
    }
}

