/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.data.codec.impl;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.data.codec.impl.AbstractOpaqueCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.CodecContextSupplier;
import org.opendaylight.yangtools.binding.data.codec.impl.LeafNodeCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.LeafSetNodeCodecContext;
import org.opendaylight.yangtools.binding.data.codec.impl.ValueCodec;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

abstract sealed class ValueNodeCodecContext
extends CodecContext
implements CodecContextSupplier
permits AbstractOpaqueCodecContext, WithCodec {
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier yangIdentifier;
    private final @NonNull DataSchemaNode dataSchema;
    private final @NonNull Class<?> valueType;
    private final @NonNull String getterName;
    private final Object defaultObject;

    ValueNodeCodecContext(DataSchemaNode dataSchema, String getterName, Class<?> valueType, Object defaultObject) {
        this.getterName = Objects.requireNonNull(getterName);
        this.dataSchema = Objects.requireNonNull(dataSchema);
        this.valueType = Objects.requireNonNull(valueType);
        this.yangIdentifier = YangInstanceIdentifier.NodeIdentifier.create((QName)dataSchema.getQName());
        this.defaultObject = defaultObject;
    }

    @Override
    final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier getDomPathArgument() {
        return this.yangIdentifier;
    }

    @Override
    public final CodecContext getCodecContext() {
        return this;
    }

    final String getGetterName() {
        return this.getterName;
    }

    final @NonNull Class<?> valueType() {
        return this.valueType;
    }

    abstract ValueCodec<Object, Object> getValueCodec();

    @Deprecated(since="13.0.0", forRemoval=true)
    public final DataSchemaNode getSchema() {
        return this.dataSchema;
    }

    @Override
    final Object defaultObject() {
        return this.defaultObject;
    }

    static abstract sealed class WithCodec
    extends ValueNodeCodecContext
    permits LeafNodeCodecContext, LeafSetNodeCodecContext {
        private final @NonNull ValueCodec<Object, Object> valueCodec;

        WithCodec(DataSchemaNode schema, ValueCodec<Object, Object> codec, String getterName, Class<?> valueType, Object defaultObject) {
            super(schema, getterName, valueType, defaultObject);
            this.valueCodec = Objects.requireNonNull(codec);
        }

        @Override
        final ValueCodec<Object, Object> getValueCodec() {
            return this.valueCodec;
        }
    }
}

