/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractAugmentGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.GroupingGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.LinkageProgress;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ModuleAugmentGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.UsesAugmentGenerator;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

final class AugmentRequirement
implements Mutable {
    private final @NonNull Set<QNameModule> squashNamespaces = new HashSet<QNameModule>(4);
    private final @NonNull AbstractAugmentGenerator augment;
    private final @NonNull Iterator<QName> remaining;
    private @NonNull AbstractCompositeGenerator<?, ?> target;
    private QNameModule localNamespace;
    private QName qname;

    private AugmentRequirement(AbstractAugmentGenerator augment, AbstractCompositeGenerator<?, ?> target) {
        this.augment = Objects.requireNonNull(augment);
        this.target = Objects.requireNonNull(target);
        this.remaining = ((SchemaNodeIdentifier)((AugmentEffectiveStatement)augment.statement()).argument()).getNodeIdentifiers().iterator();
        this.qname = this.remaining.next();
    }

    AugmentRequirement(ModuleAugmentGenerator augment, ModuleGenerator module) {
        this((AbstractAugmentGenerator)augment, module);
    }

    AugmentRequirement(UsesAugmentGenerator augment, GroupingGenerator grouping) {
        this((AbstractAugmentGenerator)augment, grouping);
        this.localNamespace = grouping.getQName().getModule();
        this.squashNamespaces.add(this.qname.getModule());
    }

    @NonNull LinkageProgress resolve() {
        return this.qname == null ? this.resolveAsTarget() : this.resolveAsChild();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("augment", (Object)this.augment).add("target", this.target).add("qname", (Object)this.qname).add("squash", this.squashNamespaces).add("local", (Object)this.localNamespace).toString();
    }

    private @NonNull LinkageProgress resolveAsTarget() {
        AbstractExplicitGenerator original = this.target.tryOriginal();
        if (original != null) {
            this.augment.setTargetGenerator((AbstractCompositeGenerator<?, ?>)original);
            ((AbstractCompositeGenerator)original).addAugment(this.augment);
            return LinkageProgress.DONE;
        }
        return LinkageProgress.NONE;
    }

    private @NonNull LinkageProgress resolveAsChild() {
        AbstractExplicitGenerator<?, ?> gen = this.target.findLocalSchemaTreeGenerator(this.qname);
        if (gen != null) {
            return this.progressTo(gen);
        }
        AbstractAugmentGenerator aug = this.target.findAugmentForGenerator(this.qname);
        if (aug != null) {
            return this.moveTo(aug);
        }
        GroupingGenerator grp = this.target.findGroupingForGenerator(this.qname);
        if (grp != null) {
            this.squashNamespaces.add(this.qname.getModule());
            this.localNamespace = grp.getQName().getModule();
            return this.moveTo(grp);
        }
        gen = this.target.findLocalSchemaTreeGenerator(this.squashNamespaces.contains(this.qname.getModule()) ? this.qname.bindTo((QNameModule)Verify.verifyNotNull((Object)this.localNamespace)) : this.qname);
        if (gen != null) {
            return this.progressTo(gen);
        }
        return LinkageProgress.NONE;
    }

    private @NonNull LinkageProgress moveTo(@NonNull AbstractCompositeGenerator<?, ?> newTarget) {
        this.target = newTarget;
        return this.tryProgress();
    }

    private @NonNull LinkageProgress progressTo(@NonNull AbstractExplicitGenerator<?, ?> newTarget) {
        Verify.verify((boolean)(newTarget instanceof AbstractCompositeGenerator), (String)"Unexpected generator %s", newTarget);
        this.target = (AbstractCompositeGenerator)newTarget;
        this.qname = this.remaining.hasNext() ? this.remaining.next() : null;
        return this.tryProgress();
    }

    private @NonNull LinkageProgress tryProgress() {
        LinkageProgress progress = this.resolve();
        return progress != LinkageProgress.NONE ? progress : LinkageProgress.SOME;
    }
}

