/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractTypeObjectGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.Generator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.IdentityGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypedefGenerator;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.PathExpression;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityEffectiveStatement;

abstract class GeneratorContext {
    private final @NonNull EffectiveModelContext modelContext;

    GeneratorContext(EffectiveModelContext modelContext) {
        this.modelContext = Objects.requireNonNull(modelContext);
    }

    final @NonNull EffectiveModelContext modelContext() {
        return this.modelContext;
    }

    abstract @Nullable AbstractTypeObjectGenerator<?, ?> resolveLeafref(@NonNull PathExpression var1);

    abstract <E extends EffectiveStatement<QName, ?>, G extends AbstractExplicitGenerator<E, ?>> @NonNull G resolveTreeScoped(@NonNull Class<G> var1, @NonNull QName var2);

    abstract @NonNull ModuleGenerator resolveModule(@NonNull QNameModule var1);

    final @NonNull IdentityGenerator resolveIdentity(@NonNull QName name) {
        for (Generator gen : this.resolveModule(name.getModule())) {
            IdentityGenerator idgen;
            if (!(gen instanceof IdentityGenerator) || !name.equals(((IdentityEffectiveStatement)(idgen = (IdentityGenerator)gen).statement()).argument())) continue;
            return idgen;
        }
        throw new IllegalStateException("Failed to find identity " + String.valueOf(name));
    }

    final @NonNull TypedefGenerator resolveTypedef(@NonNull QName qname) {
        return this.resolveTreeScoped(TypedefGenerator.class, qname);
    }
}

