/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import com.google.common.base.Verify;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.yangtools.binding.contract.Naming;
import org.opendaylight.yangtools.binding.contract.StatementNamespace;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AugmentResolver;
import org.opendaylight.yangtools.binding.generator.impl.reactor.CollisionDomain;
import org.opendaylight.yangtools.binding.generator.impl.reactor.Generator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.LeafGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ListGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.yangtools.binding.generator.impl.rt.DefaultKeyRuntimeType;
import org.opendaylight.yangtools.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.yangtools.binding.model.ri.BindingTypes;
import org.opendaylight.yangtools.binding.runtime.api.KeyRuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

final class KeyGenerator
extends AbstractExplicitGenerator<KeyEffectiveStatement, KeyRuntimeType> {
    private final ListGenerator listGen;

    KeyGenerator(KeyEffectiveStatement statement, AbstractCompositeGenerator<?, ?> parent, ListGenerator listGen) {
        super(statement, parent);
        this.listGen = Objects.requireNonNull(listGen);
    }

    @Override
    StatementNamespace namespace() {
        return StatementNamespace.KEY;
    }

    @Override
    void pushToInference(SchemaInferenceStack inferenceStack) {
        throw new UnsupportedOperationException();
    }

    @Override
    CollisionDomain.Member createMember(CollisionDomain domain) {
        return domain.addSecondary(this, this.listGen.getMember(), "Key");
    }

    GeneratedTransferObject createTypeImpl(TypeBuilderFactory builderFactory) {
        GeneratedTOBuilder builder = builderFactory.newGeneratedTOBuilder(this.typeName());
        builder.addImplementsType((Type)BindingTypes.key((Type)Type.of((JavaTypeName)this.listGen.typeName())));
        Set leafNames = ((KeyEffectiveStatement)this.statement()).argument();
        for (Generator listChild : this.listGen) {
            LeafGenerator leafGen;
            QName qname;
            if (!(listChild instanceof LeafGenerator) || !leafNames.contains(qname = (QName)((LeafEffectiveStatement)(leafGen = (LeafGenerator)listChild).statement()).argument())) continue;
            GeneratedPropertyBuilder prop = ((GeneratedPropertyBuilder)builder.addProperty(Naming.getPropertyName((String)qname.getLocalName())).setReturnType(leafGen.methodReturnType(builderFactory))).setReadOnly(true);
            builder.addEqualsIdentity(prop);
            builder.addHashIdentity(prop);
            builder.addToStringProperty(prop);
        }
        KeyGenerator.addSerialVersionUID(builder);
        return builder.build();
    }

    @Override
    KeyRuntimeType createExternalRuntimeType(Type type) {
        Verify.verify((boolean)(type instanceof GeneratedTransferObject), (String)"Unexpected type %s", (Object)type);
        return new DefaultKeyRuntimeType((GeneratedTransferObject)type, (KeyEffectiveStatement)this.statement());
    }

    @Override
    KeyRuntimeType createInternalRuntimeType(AugmentResolver resolver, KeyEffectiveStatement statement, Type type) {
        throw new UnsupportedOperationException("Should never be called");
    }

    @Override
    void addAsGetterMethod(GeneratedTypeBuilderBase<?> builder, TypeBuilderFactory builderFactory) {
    }
}

