/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.loader;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.file.Path;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.DataContainer;
import org.opendaylight.yangtools.binding.loader.BindingClassLoader;
import org.opendaylight.yangtools.binding.loader.LeafBindingClassLoader;
import org.opendaylight.yangtools.concepts.AccessControllerCompat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RootBindingClassLoader
extends BindingClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(RootBindingClassLoader.class);
    private static final VarHandle LOADERS;
    private volatile ImmutableMap<ClassLoader, BindingClassLoader> loaders = ImmutableMap.of();

    RootBindingClassLoader(ClassLoader parentLoader, @Nullable Path dumpDir) {
        super(parentLoader, dumpDir);
    }

    @Override
    BindingClassLoader findClassLoader(Class<?> bindingClass) {
        BindingClassLoader found;
        ClassLoader target = bindingClass.getClassLoader();
        if (target == null) {
            LOG.debug("Using existing {} for {}", (Object)this, bindingClass);
            return this;
        }
        ImmutableMap local = this.loaders;
        BindingClassLoader known = (BindingClassLoader)local.get((Object)target);
        if (known != null) {
            LOG.debug("Using existing {} for {}", (Object)known, bindingClass);
            return known;
        }
        if (!this.isOurClass(bindingClass)) {
            RootBindingClassLoader.verifyStaticLinkage(target);
            found = (BindingClassLoader)AccessControllerCompat.get(() -> new LeafBindingClassLoader(this, target));
            LOG.debug("Allocated {} for {}", (Object)found, (Object)target);
        } else {
            found = this;
        }
        while (true) {
            ImmutableMap updated;
            ImmutableMap witness;
            if ((witness = LOADERS.compareAndExchange(this, local, updated = ImmutableMap.builderWithExpectedSize((int)(local.size() + 1)).putAll(local).put((Object)target, (Object)found).build())) == local) {
                LOG.debug("Using {} for {}", (Object)found, bindingClass);
                return found;
            }
            BindingClassLoader recheck = (BindingClassLoader)witness.get((Object)target);
            if (recheck != null) {
                LOG.debug("Using {} for {}", (Object)recheck, bindingClass);
                return recheck;
            }
            local = witness;
        }
    }

    @Override
    void appendLoaders(Set<LeafBindingClassLoader> newLoaders) {
        throw new IllegalStateException("Attempted to extend root loader with " + String.valueOf(newLoaders));
    }

    private boolean isOurClass(Class<?> bindingClass) {
        Class<?> ourClass;
        try {
            ourClass = this.loadClass(bindingClass.getName(), false);
        }
        catch (ClassNotFoundException e) {
            LOG.trace("Failed to load {}", bindingClass, (Object)e);
            return false;
        }
        return bindingClass.equals(ourClass);
    }

    private static void verifyStaticLinkage(ClassLoader candidate) {
        Class<?> targetClazz;
        try {
            targetClazz = candidate.loadClass(DataContainer.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("ClassLoader " + String.valueOf(candidate) + " cannot load " + String.valueOf(DataContainer.class), e);
        }
        Verify.verify((boolean)DataContainer.class.equals(targetClazz), (String)"Class mismatch on DataContainer. Ours is from %s, target %s has %s from %s", (Object)DataContainer.class.getClassLoader(), (Object)candidate, targetClazz, (Object)targetClazz.getClassLoader());
    }

    static {
        try {
            LOADERS = MethodHandles.lookup().findVarHandle(RootBindingClassLoader.class, "loaders", ImmutableMap.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
        Verify.verify((boolean)RootBindingClassLoader.registerAsParallelCapable());
    }
}

