/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.model.ri;

import org.opendaylight.yangtools.binding.contract.BuiltInType;
import org.opendaylight.yangtools.binding.model.api.ConcreteType;
import org.opendaylight.yangtools.binding.model.ri.Types;

public final class BaseYangTypes {
    public static final ConcreteType BOOLEAN_TYPE = Types.typeForBuiltIn(BuiltInType.BOOLEAN);
    public static final ConcreteType EMPTY_TYPE = Types.typeForBuiltIn(BuiltInType.EMPTY);
    public static final ConcreteType ENUMERATION_TYPE = Types.typeForBuiltIn(BuiltInType.ENUMERATION);
    public static final ConcreteType INT8_TYPE = Types.typeForBuiltIn(BuiltInType.INT8);
    public static final ConcreteType INT16_TYPE = Types.typeForBuiltIn(BuiltInType.INT16);
    public static final ConcreteType INT32_TYPE = Types.typeForBuiltIn(BuiltInType.INT32);
    public static final ConcreteType INT64_TYPE = Types.typeForBuiltIn(BuiltInType.INT64);
    public static final ConcreteType STRING_TYPE = Types.typeForBuiltIn(BuiltInType.STRING);
    public static final ConcreteType DECIMAL64_TYPE = Types.typeForBuiltIn(BuiltInType.DECIMAL64);
    public static final ConcreteType UINT8_TYPE = Types.typeForBuiltIn(BuiltInType.UINT8);
    public static final ConcreteType UINT16_TYPE = Types.typeForBuiltIn(BuiltInType.UINT16);
    public static final ConcreteType UINT32_TYPE = Types.typeForBuiltIn(BuiltInType.UINT32);
    public static final ConcreteType UINT64_TYPE = Types.typeForBuiltIn(BuiltInType.UINT64);
    public static final ConcreteType BINARY_TYPE = Types.typeForBuiltIn(BuiltInType.BINARY);
    public static final ConcreteType INSTANCE_IDENTIFIER = Types.typeForBuiltIn(BuiltInType.INSTANCE_IDENTIFIER);

    private BaseYangTypes() {
    }

    public static ConcreteType javaTypeForYangType(String type) {
        return switch (type) {
            case "binary" -> BINARY_TYPE;
            case "boolean" -> BOOLEAN_TYPE;
            case "decimal64" -> DECIMAL64_TYPE;
            case "empty" -> EMPTY_TYPE;
            case "enumeration" -> ENUMERATION_TYPE;
            case "instance-identifier" -> INSTANCE_IDENTIFIER;
            case "int8" -> INT8_TYPE;
            case "int16" -> INT16_TYPE;
            case "int32" -> INT32_TYPE;
            case "int64" -> INT64_TYPE;
            case "string" -> STRING_TYPE;
            case "uint8" -> UINT8_TYPE;
            case "uint16" -> UINT16_TYPE;
            case "uint32" -> UINT32_TYPE;
            case "uint64" -> UINT64_TYPE;
            default -> null;
        };
    }
}

