/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.model.ri;

import com.google.common.annotations.Beta;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.contract.BuiltInType;
import org.opendaylight.yangtools.binding.model.api.AbstractType;
import org.opendaylight.yangtools.binding.model.api.BaseTypeWithRestrictions;
import org.opendaylight.yangtools.binding.model.api.ConcreteType;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.model.api.ParameterizedType;
import org.opendaylight.yangtools.binding.model.api.Restrictions;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.WildcardType;

public final class Types {
    private static final LoadingCache<Class<?>, ConcreteType> TYPE_CACHE = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, ConcreteType>(){

        public ConcreteType load(Class<?> key) {
            return new ConcreteTypeImpl(JavaTypeName.create(key), null);
        }
    });
    public static final @NonNull ConcreteType BOOLEAN = Types.typeForClass(Boolean.class);
    public static final @NonNull ConcreteType BYTE_ARRAY = Types.typeForClass(byte[].class);
    public static final @NonNull ConcreteType CLASS = Types.typeForClass(Class.class);
    public static final @NonNull ConcreteType STRING = Types.typeForClass(String.class);
    public static final @NonNull ConcreteType VOID = Types.typeForClass(Void.class);
    private static final @NonNull ConcreteType LIST_TYPE = Types.typeForClass(List.class);
    private static final @NonNull ConcreteType LISTENABLE_FUTURE = Types.typeForClass(ListenableFuture.class);
    private static final @NonNull ConcreteType MAP_TYPE = Types.typeForClass(Map.class);
    private static final @NonNull ConcreteType OBJECT = Types.typeForClass(Object.class);
    private static final @NonNull ConcreteType PRIMITIVE_BOOLEAN = Types.typeForClass(Boolean.TYPE);
    private static final @NonNull ConcreteType PRIMITIVE_INT = Types.typeForClass(Integer.TYPE);
    private static final @NonNull ConcreteType PRIMITIVE_VOID = Types.typeForClass(Void.TYPE);
    private static final @NonNull ConcreteType SERIALIZABLE = Types.typeForClass(Serializable.class);
    private static final @NonNull ConcreteType SET_TYPE = Types.typeForClass(Set.class);
    private static final @NonNull ConcreteType IMMUTABLE_SET_TYPE = Types.typeForClass(ImmutableSet.class);
    private static final @NonNull ParameterizedType LIST_TYPE_WILDCARD = Types.parameterizedTypeFor(LIST_TYPE, new Type[0]);
    private static final @NonNull ParameterizedType SET_TYPE_WILDCARD = Types.parameterizedTypeFor(SET_TYPE, new Type[0]);

    private Types() {
    }

    public static @NonNull ParameterizedType classType(Type type) {
        return Types.parameterizedTypeFor(CLASS, type);
    }

    public static @NonNull ConcreteType voidType() {
        return VOID;
    }

    public static @NonNull ConcreteType objectType() {
        return OBJECT;
    }

    public static @NonNull ConcreteType primitiveBooleanType() {
        return PRIMITIVE_BOOLEAN;
    }

    public static @NonNull ConcreteType primitiveIntType() {
        return PRIMITIVE_INT;
    }

    public static @NonNull ConcreteType primitiveVoidType() {
        return PRIMITIVE_VOID;
    }

    public static @NonNull ConcreteType serializableType() {
        return SERIALIZABLE;
    }

    public static @NonNull ConcreteType typeForBuiltIn(@NonNull BuiltInType<?> type) {
        return Types.typeForClass(type.javaClass());
    }

    public static @NonNull ConcreteType typeForClass(@NonNull Class<?> cls) {
        return (ConcreteType)TYPE_CACHE.getUnchecked(cls);
    }

    public static @NonNull ConcreteType typeForClass(@NonNull Class<?> cls, @Nullable Restrictions restrictions) {
        return restrictions == null ? Types.typeForClass(cls) : Types.restrictedType(JavaTypeName.create(cls), restrictions);
    }

    @Beta
    public static @NonNull ConcreteType restrictedType(Type type, @NonNull Restrictions restrictions) {
        return Types.restrictedType((JavaTypeName)type.getIdentifier(), restrictions);
    }

    private static @NonNull ConcreteType restrictedType(JavaTypeName identifier, @NonNull Restrictions restrictions) {
        return new BaseTypeWithRestrictionsImpl(identifier, restrictions);
    }

    public static @NonNull ParameterizedType mapTypeFor(Type keyType, Type valueType) {
        return Types.parameterizedTypeFor(MAP_TYPE, keyType, valueType);
    }

    public static boolean isMapType(ParameterizedType type) {
        return MAP_TYPE.equals(type.getRawType());
    }

    public static @NonNull ParameterizedType setTypeFor(Type valueType) {
        return Types.parameterizedTypeFor(SET_TYPE, valueType);
    }

    public static @NonNull ParameterizedType immutableSetTypeFor(Type valueType) {
        return Types.parameterizedTypeFor(IMMUTABLE_SET_TYPE, valueType);
    }

    public static @NonNull ParameterizedType setTypeWildcard() {
        return SET_TYPE_WILDCARD;
    }

    public static boolean isSetType(ParameterizedType type) {
        return SET_TYPE.equals(type.getRawType());
    }

    public static @NonNull ParameterizedType listTypeFor(Type valueType) {
        return Types.parameterizedTypeFor(LIST_TYPE, valueType);
    }

    public static @NonNull ParameterizedType listTypeWildcard() {
        return LIST_TYPE_WILDCARD;
    }

    public static boolean isListType(ParameterizedType type) {
        return LIST_TYPE.equals(type.getRawType());
    }

    public static @NonNull ParameterizedType listenableFutureTypeFor(Type valueType) {
        return Types.parameterizedTypeFor(LISTENABLE_FUTURE, valueType);
    }

    public static @NonNull ParameterizedType parameterizedTypeFor(Type type, Type ... parameters) {
        return new ParametrizedTypeImpl(type, parameters);
    }

    public static WildcardType wildcardTypeFor(JavaTypeName identifier) {
        return new WildcardTypeImpl(identifier);
    }

    public static boolean strictTypeEquals(Type type1, Type type2) {
        if (!type1.equals(type2)) {
            return false;
        }
        if (type1 instanceof ParameterizedType) {
            ParameterizedType param1 = (ParameterizedType)type1;
            if (type2 instanceof ParameterizedType) {
                ParameterizedType param2 = (ParameterizedType)type2;
                return Arrays.equals(param1.getActualTypeArguments(), param2.getActualTypeArguments());
            }
            return false;
        }
        return !(type2 instanceof ParameterizedType);
    }

    public static @Nullable String getOuterClassName(Type valueType) {
        return ((JavaTypeName)valueType.getIdentifier()).immediatelyEnclosingClass().map(Object::toString).orElse(null);
    }

    private static final class BaseTypeWithRestrictionsImpl
    extends AbstractType
    implements BaseTypeWithRestrictions {
        private final Restrictions restrictions;

        BaseTypeWithRestrictionsImpl(JavaTypeName identifier, Restrictions restrictions) {
            super(identifier);
            this.restrictions = Objects.requireNonNull(restrictions);
        }

        @Override
        public Restrictions getRestrictions() {
            return this.restrictions;
        }
    }

    private static class ParametrizedTypeImpl
    extends AbstractType
    implements ParameterizedType {
        private final Type[] actualTypes;
        private final Type rawType;

        ParametrizedTypeImpl(Type rawType, Type[] actTypes) {
            super((JavaTypeName)rawType.getIdentifier());
            this.rawType = Objects.requireNonNull(rawType);
            this.actualTypes = (Type[])actTypes.clone();
            if (Arrays.stream(this.actualTypes).anyMatch(Objects::isNull)) {
                throw new NullPointerException("actTypes contains a null");
            }
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypes;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }
    }

    private static class WildcardTypeImpl
    extends AbstractType
    implements WildcardType {
        WildcardTypeImpl(JavaTypeName identifier) {
            super(identifier);
        }
    }

    private static final class ConcreteTypeImpl
    extends AbstractType
    implements ConcreteType {
        private final Restrictions restrictions;

        ConcreteTypeImpl(JavaTypeName identifier, Restrictions restrictions) {
            super(identifier);
            this.restrictions = restrictions;
        }

        @Override
        public Restrictions getRestrictions() {
            return this.restrictions;
        }
    }
}

