/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.model.ri.generated.type.builder;

import java.util.List;
import java.util.Objects;
import org.opendaylight.yangtools.binding.model.api.AccessModifier;
import org.opendaylight.yangtools.binding.model.api.AnnotationType;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.TypeMember;
import org.opendaylight.yangtools.binding.model.api.TypeMemberComment;

abstract class AbstractTypeMember
implements TypeMember {
    private final String name;
    private final TypeMemberComment comment;
    private final Type returnType;
    private final List<AnnotationType> annotations;
    private final boolean isFinal;
    private final boolean isStatic;
    private final AccessModifier accessModifier;

    protected AbstractTypeMember(String name, List<AnnotationType> annotations, TypeMemberComment comment, AccessModifier accessModifier, Type returnType, boolean isFinal, boolean isStatic) {
        this.name = name;
        this.annotations = annotations;
        this.comment = comment;
        this.accessModifier = accessModifier;
        this.returnType = returnType;
        this.isFinal = isFinal;
        this.isStatic = isStatic;
    }

    @Override
    public List<AnnotationType> getAnnotations() {
        return this.annotations;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TypeMemberComment getComment() {
        return this.comment;
    }

    @Override
    public AccessModifier getAccessModifier() {
        return this.accessModifier;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getReturnType());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTypeMember other = (AbstractTypeMember)obj;
        return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getReturnType(), other.getReturnType());
    }

    public String toString() {
        return "AbstractTypeMember [name=" + this.getName() + ", comment=" + this.getComment() + ", returnType=" + this.getReturnType() + ", annotations=" + this.getAnnotations() + ']';
    }
}

