/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.model.ri.generated.type.builder;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opendaylight.yangtools.binding.model.api.AbstractType;
import org.opendaylight.yangtools.binding.model.api.AnnotationType;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.model.api.type.builder.AnnotationTypeBuilder;
import org.opendaylight.yangtools.util.LazyCollections;

final class AnnotationTypeBuilderImpl
extends AbstractType
implements AnnotationTypeBuilder {
    private List<AnnotationTypeBuilder> annotationBuilders = Collections.emptyList();
    private List<AnnotationType.Parameter> parameters = Collections.emptyList();

    AnnotationTypeBuilderImpl(JavaTypeName identifier) {
        super(identifier);
    }

    @Override
    public AnnotationTypeBuilder addAnnotation(String packageName, String name) {
        JavaTypeName typeName = JavaTypeName.create(packageName, name);
        for (AnnotationTypeBuilder builder : this.annotationBuilders) {
            if (!typeName.equals(builder.getIdentifier())) continue;
            return builder;
        }
        AnnotationTypeBuilderImpl builder = new AnnotationTypeBuilderImpl(typeName);
        this.annotationBuilders = LazyCollections.lazyAdd(this.annotationBuilders, (Object)builder);
        return builder;
    }

    private boolean addParameter(ParameterImpl param) {
        if (this.parameters.contains(param)) {
            return false;
        }
        this.parameters = LazyCollections.lazyAdd(this.parameters, (Object)param);
        return true;
    }

    @Override
    public boolean addParameter(String paramName, String value) {
        if (paramName != null && value != null) {
            ParameterImpl param = new ParameterImpl(paramName, value);
            return this.addParameter(param);
        }
        return false;
    }

    @Override
    public boolean addParameters(String paramName, List<String> values) {
        if (paramName != null && values != null) {
            ParameterImpl param = new ParameterImpl(paramName, values);
            return this.addParameter(param);
        }
        return false;
    }

    @Override
    public AnnotationType build() {
        return new AnnotationTypeImpl((JavaTypeName)this.getIdentifier(), this.annotationBuilders, this.parameters);
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).omitNullValues().add("annotationBuilders", this.annotationBuilders).add("parameters", this.parameters);
    }

    private static final class ParameterImpl
    implements AnnotationType.Parameter {
        private final String name;
        private final String value;
        private final List<String> values;

        ParameterImpl(String name, String value) {
            this.name = name;
            this.value = value;
            this.values = Collections.emptyList();
        }

        ParameterImpl(String name, List<String> values) {
            this.name = name;
            this.values = values;
            this.value = null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public List<String> getValues() {
            return this.values;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this.name);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ParameterImpl other = (ParameterImpl)obj;
            return Objects.equals(this.name, other.name);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ParameterImpl [name=");
            builder.append(this.name);
            builder.append(", value=");
            builder.append(this.value);
            builder.append(", values=");
            builder.append(this.values);
            builder.append("]");
            return builder.toString();
        }
    }

    private static final class AnnotationTypeImpl
    extends AbstractType
    implements AnnotationType {
        private final List<AnnotationType> annotations;
        private final List<AnnotationType.Parameter> parameters;
        private final List<String> paramNames;

        AnnotationTypeImpl(JavaTypeName identifier, List<AnnotationTypeBuilder> annotationBuilders, List<AnnotationType.Parameter> parameters) {
            super(identifier);
            ArrayList<AnnotationType> a = new ArrayList<AnnotationType>();
            for (AnnotationTypeBuilder builder : annotationBuilders) {
                a.add(builder.build());
            }
            this.annotations = ImmutableList.copyOf(a);
            ArrayList<String> p = new ArrayList<String>();
            for (AnnotationType.Parameter parameter : parameters) {
                p.add(parameter.getName());
            }
            this.paramNames = ImmutableList.copyOf(p);
            this.parameters = parameters.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(parameters);
        }

        @Override
        public List<AnnotationType> getAnnotations() {
            return this.annotations;
        }

        @Override
        public AnnotationType.Parameter getParameter(String paramName) {
            if (paramName != null) {
                for (AnnotationType.Parameter parameter : this.parameters) {
                    if (!parameter.getName().equals(paramName)) continue;
                    return parameter;
                }
            }
            return null;
        }

        @Override
        public List<AnnotationType.Parameter> getParameters() {
            return this.parameters;
        }

        @Override
        public List<String> getParameterNames() {
            return this.paramNames;
        }

        @Override
        public boolean containsParameters() {
            return !this.parameters.isEmpty();
        }

        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
            return super.addToStringAttributes(toStringHelper).omitNullValues().add("annotations", this.annotations).add("parameters", this.parameters);
        }
    }
}

