/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.reflect;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.Action;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.BaseIdentity;
import org.opendaylight.yangtools.binding.ChildOf;
import org.opendaylight.yangtools.binding.DataContainer;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.Notification;
import org.opendaylight.yangtools.binding.contract.Naming;
import org.opendaylight.yangtools.binding.meta.YangModuleInfo;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BindingReflections {
    private static final Logger LOG = LoggerFactory.getLogger(BindingReflections.class);
    private static final LoadingCache<Class<?>, Optional<QName>> CLASS_TO_QNAME = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(60L, TimeUnit.SECONDS).build((CacheLoader)new ClassToQNameLoader());

    private BindingReflections() {
    }

    public static QName findQName(Class<?> dataType) {
        return ((Optional)CLASS_TO_QNAME.getUnchecked(dataType)).orElse(null);
    }

    public static @NonNull QNameModule getQNameModule(Class<?> clz) {
        if (DataContainer.class.isAssignableFrom(clz) || BaseIdentity.class.isAssignableFrom(clz) || Action.class.isAssignableFrom(clz)) {
            return BindingReflections.findQName(clz).getModule();
        }
        return BindingReflections.getModuleInfo(clz).getName().getModule();
    }

    private static @NonNull YangModuleInfo getModuleInfo(Class<?> cls) {
        Object infoInstance;
        Class<?> moduleInfoClass;
        String potentialClassName = Naming.rootToServicePackageName((String)cls.getPackage().getName()) + ".YangModuleInfoImpl";
        try {
            moduleInfoClass = cls.getClassLoader().loadClass(potentialClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to load " + potentialClassName, e);
        }
        try {
            infoInstance = moduleInfoClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to get instance of " + String.valueOf(moduleInfoClass), e);
        }
        Preconditions.checkState((boolean)(infoInstance instanceof YangModuleInfo), (String)"Unexpected instance %s", (Object)infoInstance);
        return (YangModuleInfo)infoInstance;
    }

    public static boolean isBindingClass(Class<?> cls) {
        if (DataContainer.class.isAssignableFrom(cls) || Augmentation.class.isAssignableFrom(cls)) {
            return true;
        }
        return cls.getName().startsWith("org.opendaylight.yang.gen.v1");
    }

    @VisibleForTesting
    static boolean isRpcType(Class<? extends DataObject> targetType) {
        return DataContainer.class.isAssignableFrom(targetType) && !ChildOf.class.isAssignableFrom(targetType) && !Notification.class.isAssignableFrom(targetType) && (targetType.getName().endsWith("Input") || targetType.getName().endsWith("Output"));
    }

    private static final class ClassToQNameLoader
    extends CacheLoader<Class<?>, Optional<QName>> {
        private ClassToQNameLoader() {
        }

        public Optional<QName> load(Class<?> key) throws Exception {
            return ClassToQNameLoader.resolveQNameNoCache(key);
        }

        private static Optional<QName> resolveQNameNoCache(Class<?> key) {
            try {
                Field field;
                try {
                    field = key.getField("QNAME");
                }
                catch (NoSuchFieldException e) {
                    LOG.debug("{} does not have a {} field, falling back to computation", new Object[]{key, "QNAME", e});
                    return Optional.of(ClassToQNameLoader.computeQName(key));
                }
                Object obj = field.get(null);
                if (obj instanceof QName) {
                    QName qname = (QName)obj;
                    return Optional.of(qname);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                LOG.debug("Unexpected exception during extracting QName for {}", key, (Object)e);
            }
            return Optional.empty();
        }

        private static QName computeQName(Class key) {
            Preconditions.checkArgument((boolean)BindingReflections.isBindingClass(key), (String)"Supplied class %s is not derived from YANG.", (Object)key);
            QName module = BindingReflections.getModuleInfo(key).getName();
            if (Augmentation.class.isAssignableFrom(key)) {
                return module;
            }
            if (BindingReflections.isRpcType(key)) {
                String className = key.getSimpleName();
                if (className.endsWith("Output")) {
                    return YangConstants.operationOutputQName((QNameModule)module.getModule()).intern();
                }
                return YangConstants.operationInputQName((QNameModule)module.getModule()).intern();
            }
            return module;
        }
    }
}

