/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.runtime.api;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingEffectiveStatement;

public interface GroupingRuntimeType
extends CompositeRuntimeType {
    public GroupingEffectiveStatement statement();

    default public @NonNull List<CompositeRuntimeType> instantiations() {
        List<CompositeRuntimeType> users = this.directUsers();
        return switch (users.size()) {
            case 0 -> List.of();
            case 1 -> {
                CompositeRuntimeType user = users.get(0);
                if (user instanceof GroupingRuntimeType) {
                    GroupingRuntimeType grouping = (GroupingRuntimeType)user;
                    yield grouping.instantiations();
                }
                yield List.of(user);
            }
            default -> users.stream().flatMap(user -> {
                Stream<CompositeRuntimeType> stream;
                if (user instanceof GroupingRuntimeType) {
                    GroupingRuntimeType grouping = (GroupingRuntimeType)user;
                    stream = grouping.instantiations().stream();
                } else {
                    stream = Stream.of(user);
                }
                return stream;
            }).distinct().collect(Collectors.toUnmodifiableList());
        };
    }

    public @NonNull List<CompositeRuntimeType> directUsers();
}

