/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.BindingInstanceIdentifier;
import org.opendaylight.yangtools.binding.ChildOf;
import org.opendaylight.yangtools.binding.ChoiceIn;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.binding.DataObjectStep;
import org.opendaylight.yangtools.binding.DataRoot;
import org.opendaylight.yangtools.binding.EntryObject;
import org.opendaylight.yangtools.binding.ExactDataObjectStep;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.KeyStep;
import org.opendaylight.yangtools.binding.impl.AbstractDataObjectIdentifierBuilder;
import org.opendaylight.yangtools.binding.impl.DataObjectIdentifierBuilder;
import org.opendaylight.yangtools.binding.impl.DataObjectIdentifierBuilderWithKey;
import org.opendaylight.yangtools.binding.impl.DataObjectIdentifierImpl;
import org.opendaylight.yangtools.binding.impl.DataObjectIdentifierWithKey;

public sealed interface DataObjectIdentifier<T extends DataObject>
extends DataObjectReference<T>,
BindingInstanceIdentifier
permits WithKey, DataObjectIdentifierImpl {
    public static @NonNull DataObjectIdentifier<?> ofUnsafeSteps(Iterable<? extends @NonNull ExactDataObjectStep<?>> steps) {
        return DataObjectIdentifier.ofUnsafeSteps(ImmutableList.copyOf(steps));
    }

    public static @NonNull DataObjectIdentifier<?> ofUnsafeSteps(List<? extends @NonNull ExactDataObjectStep<?>> steps) {
        return DataObjectIdentifier.ofUnsafeSteps(ImmutableList.copyOf(steps));
    }

    public static @NonNull DataObjectIdentifier<?> ofUnsafeSteps(ImmutableList<? extends @NonNull ExactDataObjectStep<?>> steps) {
        return DataObjectIdentifierImpl.ofUnsafeSteps(steps);
    }

    public static <T extends ChildOf<? extends DataRoot<?>>> @NonNull Builder<T> builder(@NonNull Class<T> container) {
        return new DataObjectIdentifierBuilder(DataObjectStep.of(container));
    }

    public static <C extends ChoiceIn<? extends DataRoot<?>> & DataObject, T extends ChildOf<? super C>> @NonNull Builder<T> builder(@NonNull Class<C> caze, @NonNull Class<T> container) {
        return new DataObjectIdentifierBuilder(DataObjectStep.of(caze, container));
    }

    public static <N extends EntryObject<N, K> & ChildOf<? extends DataRoot<?>>, K extends Key<N>> @NonNull Builder.WithKey<N, K> builder(Class<N> listItem, K listKey) {
        return new DataObjectIdentifierBuilderWithKey<N, K>(new KeyStep<K, N>(listItem, listKey));
    }

    public static <C extends ChoiceIn<? extends DataRoot<?>> & DataObject, N extends EntryObject<N, K> & ChildOf<? super C>, K extends Key<N>> @NonNull Builder.WithKey<N, K> builder(@NonNull Class<C> caze, @NonNull Class<N> listItem, @NonNull K listKey) {
        return new DataObjectIdentifierBuilderWithKey<N, K>(new KeyStep<K, N>(listItem, Objects.requireNonNull(caze), listKey));
    }

    public static <R extends DataRoot<R>, T extends ChildOf<? super R>> @NonNull Builder<T> builderOfInherited(@NonNull Class<R> root, @NonNull Class<T> container) {
        return new DataObjectIdentifierBuilder(DataObjectStep.of(container));
    }

    public static <R extends DataRoot<R>, C extends ChoiceIn<? super R> & DataObject, T extends ChildOf<? super C>> @NonNull Builder<T> builderOfInherited(Class<R> root, Class<C> caze, Class<T> container) {
        return new DataObjectIdentifierBuilder(DataObjectStep.of(caze, container));
    }

    public static <R extends DataRoot<R>, N extends EntryObject<N, K> & ChildOf<? super R>, K extends Key<N>> @NonNull Builder.WithKey<N, K> builderOfInherited(@NonNull Class<R> root, @NonNull Class<N> listItem, @NonNull K listKey) {
        return new DataObjectIdentifierBuilderWithKey<N, K>(new KeyStep<K, N>(listItem, listKey));
    }

    public static <R extends DataRoot<R>, C extends ChoiceIn<? super R> & DataObject, N extends EntryObject<N, K> & ChildOf<? super C>, K extends Key<N>> @NonNull Builder.WithKey<N, K> builderOfInherited(Class<R> root, Class<C> caze, Class<N> listItem, K listKey) {
        return new DataObjectIdentifierBuilderWithKey<N, K>(new KeyStep<K, N>(listItem, Objects.requireNonNull(caze), listKey));
    }

    @Override
    public Iterable<? extends @NonNull ExactDataObjectStep<?>> steps();

    @Override
    default public boolean isExact() {
        return true;
    }

    @Override
    public Builder<T> toBuilder();

    @Override
    @Deprecated(since="14.0.0")
    default public boolean isWildcarded() {
        return false;
    }

    public static sealed interface Builder<T extends DataObject>
    extends DataObjectReference.Builder<T>
    permits WithKey, AbstractDataObjectIdentifierBuilder {
        @Override
        public <A extends Augmentation<? super T>> Builder<A> augmentation(Class<A> var1);

        @Override
        public <N extends ChildOf<? super T>> Builder<N> child(Class<N> var1);

        @Override
        public <C extends ChoiceIn<? super T> & DataObject, N extends ChildOf<? super C>> Builder<N> child(Class<C> var1, Class<N> var2);

        @Override
        public <C extends ChoiceIn<? super T> & DataObject, K extends Key<N>, N extends EntryObject<N, K> & ChildOf<? super C>> WithKey<N, K> child(Class<C> var1, Class<N> var2, K var3);

        @Override
        public <N extends EntryObject<N, K> & ChildOf<? super T>, K extends Key<N>> WithKey<N, K> child(Class<@NonNull N> var1, K var2);

        @Override
        public DataObjectIdentifier<T> build();

        public DataObjectReference.Builder<T> toReferenceBuilder();

        public static interface WithKey<T extends EntryObject<T, K>, K extends Key<T>>
        extends Builder<T>,
        DataObjectReference.Builder.WithKey<T, K> {
            @Override
            public org.opendaylight.yangtools.binding.DataObjectIdentifier$WithKey<T, K> build();

            public DataObjectReference.Builder.WithKey<T, K> toReferenceBuilder();
        }
    }

    public static sealed interface WithKey<T extends EntryObject<T, K>, K extends Key<T>>
    extends DataObjectIdentifier<T>,
    DataObjectReference.WithKey<T, K>
    permits DataObjectIdentifierWithKey {
        @Override
        public KeyStep<K, T> lastStep();

        @Override
        public Builder.WithKey<T, K> toBuilder();
    }
}

