/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.contract;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;

public final class RegexPatterns {
    private static final String NEGATED_PATTERN_PREFIX = "^(?!";
    private static final String NEGATED_PATTERN_SUFFIX = ").*$";

    private RegexPatterns() {
    }

    public static boolean isNegatedPattern(Pattern pattern) {
        String str = pattern.toString();
        return str.startsWith(NEGATED_PATTERN_PREFIX) && str.endsWith(NEGATED_PATTERN_SUFFIX);
    }

    public static String negatePatternString(String pattern) {
        Preconditions.checkArgument((pattern.charAt(0) == '^' && pattern.charAt(pattern.length() - 1) == '$' ? 1 : 0) != 0, (String)"Pattern '%s' does not have expected format", (Object)pattern);
        boolean hasGroup = pattern.startsWith("^(?:") && pattern.endsWith(")$");
        int len = pattern.length();
        StringBuilder sb = new StringBuilder(len + (hasGroup ? 7 : 11)).append(NEGATED_PATTERN_PREFIX);
        if (hasGroup) {
            sb.append(pattern, 1, len);
        } else {
            sb.append("(?:").append(pattern, 1, len - 1).append(")$");
        }
        return sb.append(NEGATED_PATTERN_SUFFIX).toString();
    }
}

