/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.impl;

import com.google.common.collect.ImmutableList;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.ChildOf;
import org.opendaylight.yangtools.binding.ChoiceIn;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.binding.DataObjectStep;
import org.opendaylight.yangtools.binding.EntryObject;
import org.opendaylight.yangtools.binding.ExactDataObjectStep;
import org.opendaylight.yangtools.binding.InexactDataObjectStep;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.KeyStep;
import org.opendaylight.yangtools.binding.NodeStep;
import org.opendaylight.yangtools.binding.impl.AbstractDataObjectIdentifierBuilder;
import org.opendaylight.yangtools.binding.impl.AppendIterable;
import org.opendaylight.yangtools.binding.impl.DataObjectReferenceBuilder;
import org.opendaylight.yangtools.binding.impl.DataObjectReferenceBuilderWithKey;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public abstract sealed class AbstractDataObjectReferenceBuilder<T extends DataObject>
implements DataObjectReference.Builder<T>
permits AbstractDataObjectIdentifierBuilder, DataObjectReferenceBuilder, DataObjectReferenceBuilderWithKey, InstanceIdentifier.Builder {
    private final ArrayList<@NonNull DataObjectStep<?>> pathBuilder;
    private final Iterable<? extends @NonNull DataObjectStep<?>> basePath;
    private boolean wildcard;

    protected AbstractDataObjectReferenceBuilder(AbstractDataObjectReferenceBuilder<?> prev) {
        this.pathBuilder = prev.pathBuilder;
        this.basePath = prev.basePath;
        this.wildcard = prev.wildcard;
    }

    protected AbstractDataObjectReferenceBuilder(DataObjectReference<T> base) {
        this.pathBuilder = new ArrayList(4);
        this.wildcard = base.isWildcarded();
        this.basePath = base.steps();
    }

    protected AbstractDataObjectReferenceBuilder(DataObjectStep<?> item) {
        this.pathBuilder = new ArrayList(4);
        this.basePath = null;
        this.pathBuilder.add(Objects.requireNonNull(item));
        this.wildcard = item instanceof InexactDataObjectStep;
    }

    protected AbstractDataObjectReferenceBuilder(ExactDataObjectStep<?> item) {
        this.pathBuilder = new ArrayList(4);
        this.basePath = null;
        this.pathBuilder.add((DataObjectStep)Objects.requireNonNull(item));
        this.wildcard = false;
    }

    @Override
    public <A extends Augmentation<? super T>> DataObjectReference.Builder<A> augmentation(Class<A> augmentation) {
        return this.append(new NodeStep<A>(augmentation));
    }

    @Override
    public <N extends ChildOf<? super T>> DataObjectReference.Builder<N> child(Class<N> container) {
        return this.append(DataObjectStep.of(container));
    }

    @Override
    public <C extends ChoiceIn<? super T> & DataObject, N extends ChildOf<? super C>> DataObjectReference.Builder<N> child(Class<C> caze, Class<N> container) {
        return this.append(DataObjectStep.of(caze, container));
    }

    @Override
    public <N extends EntryObject<N, K> & ChildOf<? super T>, K extends Key<N>> DataObjectReference.Builder.WithKey<N, K> child(Class<N> listItem, K listKey) {
        return this.append(new KeyStep<K, N>(listItem, listKey));
    }

    @Override
    public <C extends ChoiceIn<? super T> & DataObject, K extends Key<N>, N extends EntryObject<N, K> & ChildOf<? super C>> DataObjectReference.Builder.WithKey<N, K> child(Class<C> caze, Class<N> listItem, K listKey) {
        return this.append(new KeyStep<K, N>(listItem, Objects.requireNonNull(caze), listKey));
    }

    @Override
    public abstract DataObjectReference<T> build();

    protected abstract <X extends DataObject> @NonNull DataObjectReference.Builder<X> append(@NonNull DataObjectStep<X> var1);

    protected abstract <X extends EntryObject<X, Y>, Y extends Key<X>> @NonNull DataObjectReference.Builder.WithKey<X, Y> append(@NonNull KeyStep<Y, X> var1);

    protected final boolean wildcard() {
        return this.wildcard;
    }

    protected final void appendItem(DataObjectStep<?> item) {
        DataObjectStep<?> dataObjectStep = item;
        Objects.requireNonNull(dataObjectStep);
        DataObjectStep<?> dataObjectStep2 = dataObjectStep;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExactDataObjectStep.class, InexactDataObjectStep.class}, dataObjectStep2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ExactDataObjectStep exact = (ExactDataObjectStep)dataObjectStep2;
                this.appendItem(exact);
                break;
            }
            case 1: {
                InexactDataObjectStep inexact = (InexactDataObjectStep)dataObjectStep2;
                this.appendItem(inexact);
            }
        }
    }

    protected final void appendItem(@NonNull ExactDataObjectStep<?> item) {
        this.pathBuilder.add(item);
    }

    protected void appendItem(@NonNull InexactDataObjectStep<?> item) {
        this.pathBuilder.add(item);
        this.wildcard = true;
    }

    protected final @NonNull Iterable<? extends @NonNull DataObjectStep<?>> buildSteps() {
        AppendIterable prefix = this.basePath;
        if (prefix == null) {
            return this.pathBuilder.isEmpty() ? ImmutableList.of() : ImmutableList.copyOf(this.pathBuilder);
        }
        return switch (this.pathBuilder.size()) {
            case 0 -> prefix;
            case 1 -> new AppendIterable(prefix, this.pathBuilder.getFirst());
            default -> ImmutableList.builder().addAll((Iterable)prefix).addAll(this.pathBuilder).build();
        };
    }
}

