/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.impl;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.DataObjectStep;
import org.opendaylight.yangtools.binding.ExactDataObjectStep;
import org.opendaylight.yangtools.binding.KeyStep;
import org.opendaylight.yangtools.binding.impl.AbstractDataObjectIdentifierBuilder;
import org.opendaylight.yangtools.binding.impl.AbstractDataObjectReference;
import org.opendaylight.yangtools.binding.impl.DataObjectIdentifierBuilder;
import org.opendaylight.yangtools.binding.impl.DataObjectIdentifierWithKey;

public sealed class DataObjectIdentifierImpl<T extends DataObject>
extends AbstractDataObjectReference<T, ExactDataObjectStep<?>>
implements DataObjectIdentifier<T>
permits DataObjectIdentifierWithKey {
    private static final long serialVersionUID = 1L;

    DataObjectIdentifierImpl(Iterable<? extends @NonNull ExactDataObjectStep<?>> steps) {
        super(steps);
    }

    public DataObjectIdentifierImpl(Void unused, Iterable<? extends @NonNull DataObjectStep<?>> steps) {
        this(DataObjectIdentifierImpl.verifySteps(steps));
    }

    private static @NonNull Iterable<? extends @NonNull ExactDataObjectStep<?>> verifySteps(Iterable<? extends @NonNull DataObjectStep<?>> steps) {
        steps.forEach(step -> Verify.verify((boolean)(step instanceof ExactDataObjectStep), (String)"%s is not an exact step", (Object)step));
        return steps;
    }

    public static final @NonNull DataObjectIdentifierImpl<?> ofUnsafeSteps(ImmutableList<? extends @NonNull ExactDataObjectStep<?>> steps) {
        ExactDataObjectStep last = (ExactDataObjectStep)steps.getLast();
        return last instanceof KeyStep ? new DataObjectIdentifierWithKey((Iterable<? extends ExactDataObjectStep<?>>)((Iterable<ExactDataObjectStep<?>>)steps)) : new DataObjectIdentifierImpl((Iterable<? extends ExactDataObjectStep<?>>)((Iterable<ExactDataObjectStep<?>>)steps));
    }

    @Override
    public AbstractDataObjectIdentifierBuilder<T> toBuilder() {
        return new DataObjectIdentifierBuilder(this);
    }

    @Override
    public DataObjectIdentifierImpl<T> toIdentifier() {
        return this;
    }

    @Override
    protected final Class<?> contract() {
        return DataObjectIdentifier.class;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.throwNSE();
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.throwNSE();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.throwNSE();
    }
}

