/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.concepts;

import com.google.common.base.MoreObjects;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Registration;

public abstract class AbstractRegistration
implements Registration {
    private static final VarHandle CLOSED;
    private volatile byte closed;

    protected abstract void removeRegistration();

    public final boolean isClosed() {
        return CLOSED.getAcquire(this) != 0;
    }

    public final boolean notClosed() {
        return CLOSED.getAcquire(this) == 0;
    }

    @Override
    public final void close() {
        if (CLOSED.compareAndSet(this, (byte)0, (byte)1)) {
            this.removeRegistration();
        }
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("closed", this.isClosed());
    }

    @Deprecated(forRemoval=true)
    final void spotbugs2749() {
        if (this.closed == 2) {
            this.closed = (byte)3;
        }
    }

    static {
        try {
            CLOSED = MethodHandles.lookup().findVarHandle(AbstractRegistration.class, "closed", Byte.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

